/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import io.netty.util.Recycler;

public class EntryBatchSizes {
    private int[] sizes = new int[100];
    private final Recycler.Handle<EntryBatchSizes> handle;
    private static final Recycler<EntryBatchSizes> RECYCLER = new Recycler<EntryBatchSizes>(){

        protected EntryBatchSizes newObject(Recycler.Handle<EntryBatchSizes> handle) {
            return new EntryBatchSizes(handle);
        }
    };

    public int getBatchSize(int entryIdx) {
        return this.sizes[entryIdx];
    }

    public int setBatchSize(int entryIdx, int batchSize) {
        this.sizes[entryIdx] = batchSize;
        return this.sizes[entryIdx];
    }

    public void recyle() {
        this.handle.recycle((Object)this);
    }

    public static EntryBatchSizes get(int entriesListSize) {
        EntryBatchSizes ebs = (EntryBatchSizes)RECYCLER.get();
        if (ebs.sizes.length < entriesListSize) {
            ebs.sizes = new int[entriesListSize];
        }
        return ebs;
    }

    private EntryBatchSizes(Recycler.Handle<EntryBatchSizes> handle) {
        this.handle = handle;
    }
}

