/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.intercept;

import io.netty.buffer.ByteBuf;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.intercept.ManagedLedgerInterceptor;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.pulsar.common.intercept.AppendIndexMetadataInterceptor;
import org.apache.pulsar.common.intercept.BrokerEntryMetadataInterceptor;
import org.apache.pulsar.common.intercept.ManagedLedgerPayloadProcessor;
import org.apache.pulsar.common.protocol.Commands;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedLedgerInterceptorImpl
implements ManagedLedgerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ManagedLedgerInterceptorImpl.class);
    private static final String INDEX = "index";
    private final Set<BrokerEntryMetadataInterceptor> brokerEntryMetadataInterceptors;
    private final AppendIndexMetadataInterceptor appendIndexMetadataInterceptor;
    private final Set<ManagedLedgerPayloadProcessor.Processor> inputProcessors;
    private final Set<ManagedLedgerPayloadProcessor.Processor> outputProcessors;

    public ManagedLedgerInterceptorImpl(Set<BrokerEntryMetadataInterceptor> brokerEntryMetadataInterceptors, Set<ManagedLedgerPayloadProcessor> brokerEntryPayloadProcessors) {
        this.brokerEntryMetadataInterceptors = brokerEntryMetadataInterceptors;
        AppendIndexMetadataInterceptor appendIndexMetadataInterceptor = null;
        for (BrokerEntryMetadataInterceptor interceptor : this.brokerEntryMetadataInterceptors) {
            if (!(interceptor instanceof AppendIndexMetadataInterceptor)) continue;
            appendIndexMetadataInterceptor = (AppendIndexMetadataInterceptor)interceptor;
            break;
        }
        this.appendIndexMetadataInterceptor = appendIndexMetadataInterceptor;
        if (brokerEntryPayloadProcessors != null) {
            this.inputProcessors = new LinkedHashSet<ManagedLedgerPayloadProcessor.Processor>();
            this.outputProcessors = new LinkedHashSet<ManagedLedgerPayloadProcessor.Processor>();
            for (ManagedLedgerPayloadProcessor processor : brokerEntryPayloadProcessors) {
                this.inputProcessors.add(processor.inputProcessor());
                this.outputProcessors.add(processor.outputProcessor());
            }
        } else {
            this.inputProcessors = null;
            this.outputProcessors = null;
        }
    }

    public long getIndex() {
        long index = -1L;
        if (this.appendIndexMetadataInterceptor != null) {
            return this.appendIndexMetadataInterceptor.getIndex();
        }
        return index;
    }

    public void beforeAddEntry(ManagedLedgerInterceptor.AddEntryOperation op, int numberOfMessages) {
        if (op == null || numberOfMessages <= 0) {
            return;
        }
        op.setData(Commands.addBrokerEntryMetadata((ByteBuf)op.getData(), this.brokerEntryMetadataInterceptors, (int)numberOfMessages));
    }

    public void afterFailedAddEntry(int numberOfMessages) {
        if (this.appendIndexMetadataInterceptor != null) {
            this.appendIndexMetadataInterceptor.decreaseWithNumberOfMessages(numberOfMessages);
        }
    }

    public void onManagedLedgerPropertiesInitialize(Map<String, String> propertiesMap) {
        if (propertiesMap == null || propertiesMap.size() == 0) {
            return;
        }
        if (propertiesMap.containsKey(INDEX) && this.appendIndexMetadataInterceptor != null) {
            this.appendIndexMetadataInterceptor.recoveryIndexGenerator(Long.parseLong(propertiesMap.get(INDEX)));
        }
    }

    public CompletableFuture<Void> onManagedLedgerLastLedgerInitialize(String name, ManagedLedgerInterceptor.LastEntryHandle lh) {
        return lh.readLastEntryAsync().thenAccept(lastEntryOptional -> {
            if (lastEntryOptional.isPresent()) {
                Entry lastEntry = (Entry)lastEntryOptional.get();
                try {
                    Commands.peekBrokerEntryMetadataAndConsume((ByteBuf)lastEntry.getDataBuffer(), brokerEntryMetadata -> {
                        if (brokerEntryMetadata != null && brokerEntryMetadata.hasIndex()) {
                            this.appendIndexMetadataInterceptor.recoveryIndexGenerator(brokerEntryMetadata.getIndex());
                        }
                    });
                }
                finally {
                    lastEntry.release();
                }
            }
        });
    }

    public void onUpdateManagedLedgerInfo(Map<String, String> propertiesMap) {
        if (this.appendIndexMetadataInterceptor != null) {
            propertiesMap.put(INDEX, String.valueOf(this.appendIndexMetadataInterceptor.getIndex()));
        }
    }

    private ManagedLedgerInterceptor.PayloadProcessorHandle processPayload(Set<ManagedLedgerPayloadProcessor.Processor> processors, Object context, ByteBuf payload) {
        ByteBuf tmpData = payload;
        final LinkedHashSet<ImmutablePair> processedSet = new LinkedHashSet<ImmutablePair>();
        for (ManagedLedgerPayloadProcessor.Processor payloadProcessor : processors) {
            if (payloadProcessor == null) continue;
            tmpData = payloadProcessor.process(context, tmpData);
            processedSet.add(new ImmutablePair((Object)payloadProcessor, (Object)tmpData));
        }
        final ByteBuf dataToReturn = tmpData;
        return new ManagedLedgerInterceptor.PayloadProcessorHandle(){

            public ByteBuf getProcessedPayload() {
                return dataToReturn;
            }

            public void release() {
                for (ImmutablePair p : processedSet) {
                    ((ManagedLedgerPayloadProcessor.Processor)p.left).release((ByteBuf)p.right);
                }
                processedSet.clear();
            }
        };
    }

    public ManagedLedgerInterceptor.PayloadProcessorHandle processPayloadBeforeLedgerWrite(Object ctx, ByteBuf ledgerData) {
        if (this.inputProcessors == null || this.inputProcessors.size() == 0) {
            return null;
        }
        return this.processPayload(this.inputProcessors, ctx, ledgerData);
    }

    public ManagedLedgerInterceptor.PayloadProcessorHandle processPayloadBeforeEntryCache(ByteBuf ledgerData) {
        if (this.outputProcessors == null || this.outputProcessors.size() == 0) {
            return null;
        }
        return this.processPayload(this.outputProcessors, null, ledgerData);
    }
}

