/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.WorkerExecutor;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.logging.Logger;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.logging.LoggerFactory;

public class TaskQueue {
    static final Logger log = LoggerFactory.getLogger(TaskQueue.class);
    private final LinkedList<Task> tasks = new LinkedList();
    private final Set<ContinuationTask> continuations = new HashSet<ContinuationTask>();
    private boolean closed;
    private Executor currentExecutor;
    private Thread currentThread;
    private ExecuteTask currentTask;
    private final Runnable runner = this::run;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        while (true) {
            ExecuteTask execute;
            LinkedList<Task> linkedList = this.tasks;
            synchronized (linkedList) {
                Task task = this.tasks.poll();
                if (task == null) {
                    this.currentExecutor = null;
                    return;
                }
                if (task instanceof ContinuationTask) {
                    ContinuationTask resume = (ContinuationTask)task;
                    this.currentExecutor = resume.executor;
                    this.currentThread = resume.thread;
                    this.currentTask = resume.task;
                    resume.latch.run();
                    return;
                }
                execute = (ExecuteTask)task;
                if (execute.exec != this.currentExecutor) {
                    this.tasks.addFirst(execute);
                    execute.exec.execute(this.runner);
                    this.currentExecutor = execute.exec;
                    return;
                }
            }
            try {
                this.currentThread = Thread.currentThread();
                this.currentTask = execute;
                execute.runnable.run();
                continue;
            }
            catch (Throwable t) {
                log.error("Caught unexpected Throwable", t);
                continue;
            }
            finally {
                this.currentThread = null;
                this.currentTask = null;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContinuationTask continuationTask() {
        ExecuteTask task;
        Executor executor;
        Thread thread;
        LinkedList<Task> linkedList = this.tasks;
        synchronized (linkedList) {
            if (Thread.currentThread() != this.currentThread) {
                throw new IllegalStateException();
            }
            thread = this.currentThread;
            executor = this.currentExecutor;
            task = this.currentTask;
        }
        return new ContinuationTask(task, thread, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable task, Executor executor) throws RejectedExecutionException {
        LinkedList<Task> linkedList = this.tasks;
        synchronized (linkedList) {
            if (this.currentExecutor == null) {
                this.currentExecutor = executor;
                try {
                    executor.execute(this.runner);
                }
                catch (RejectedExecutionException e) {
                    this.currentExecutor = null;
                    throw e;
                }
            }
            this.tasks.add(new ExecuteTask(task, executor));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        LinkedList<Task> linkedList = this.tasks;
        synchronized (linkedList) {
            return this.tasks.isEmpty() && this.currentExecutor == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseResult close() {
        Runnable activeTask;
        Thread activeThread;
        ArrayList<Runnable> suspendedTasks;
        ArrayList<Thread> suspendedThreads;
        LinkedList<Task> linkedList = this.tasks;
        synchronized (linkedList) {
            if (this.closed) {
                throw new IllegalStateException("Already closed");
            }
            suspendedThreads = new ArrayList<Thread>(this.continuations.size());
            suspendedTasks = new ArrayList<Runnable>(this.continuations.size());
            Iterator it = this.tasks.iterator();
            while (it.hasNext()) {
                Task task = (Task)it.next();
                if (!(task instanceof ContinuationTask)) continue;
                ContinuationTask continuationTask = (ContinuationTask)task;
                suspendedThreads.add(continuationTask.thread);
                suspendedTasks.add(continuationTask.task.runnable);
                it.remove();
            }
            for (ContinuationTask cont : this.continuations) {
                suspendedThreads.add(cont.thread);
                suspendedTasks.add(cont.task.runnable);
            }
            this.continuations.clear();
            activeThread = this.currentThread;
            activeTask = this.currentTask != null ? this.currentTask.runnable : null;
            this.currentExecutor = null;
            this.closed = true;
        }
        return new CloseResult(activeThread, activeTask, suspendedThreads, suspendedTasks);
    }

    public CountDownLatch suspend() {
        return this.suspend(cont -> {});
    }

    public CountDownLatch suspend(Consumer<WorkerExecutor.Continuation> abc) {
        ContinuationTask continuationTask = this.continuationTask();
        abc.accept(continuationTask);
        if (continuationTask.suspend()) {
            return continuationTask;
        }
        return null;
    }

    private static class ExecuteTask
    implements Task {
        private final Runnable runnable;
        private final Executor exec;

        public ExecuteTask(Runnable runnable, Executor exec) {
            this.runnable = runnable;
            this.exec = exec;
        }
    }

    private class ContinuationTask
    extends CountDownLatch
    implements WorkerExecutor.Continuation,
    Task {
        private static final int ST_CREATED = 0;
        private static final int ST_SUSPENDED = 1;
        private static final int ST_RESUMED = 2;
        private final ExecuteTask task;
        private final Thread thread;
        private final Executor executor;
        private int status;
        private Runnable latch;

        public ContinuationTask(ExecuteTask task, Thread thread, Executor executor) {
            super(1);
            this.task = task;
            this.thread = thread;
            this.executor = executor;
            this.status = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resume(Runnable callback) {
            LinkedList linkedList = TaskQueue.this.tasks;
            synchronized (linkedList) {
                if (TaskQueue.this.closed) {
                    return;
                }
                switch (this.status) {
                    case 1: {
                        boolean removed = TaskQueue.this.continuations.remove(this);
                        assert (removed);
                        this.latch = () -> {
                            callback.run();
                            this.countDown();
                        };
                        if (TaskQueue.this.currentExecutor != null) {
                            TaskQueue.this.tasks.addFirst(this);
                            return;
                        }
                        TaskQueue.this.currentExecutor = this.executor;
                        TaskQueue.this.currentThread = this.thread;
                        TaskQueue.this.currentTask = this.task;
                        break;
                    }
                    case 0: {
                        assert (TaskQueue.this.currentExecutor == this.executor);
                        assert (TaskQueue.this.currentThread == this.thread);
                        assert (TaskQueue.this.currentTask == this.task);
                        this.latch = callback;
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                this.status = 2;
            }
            this.latch.run();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean suspend() {
            if (Thread.currentThread() != this.thread) {
                throw new IllegalStateException();
            }
            LinkedList linkedList = TaskQueue.this.tasks;
            synchronized (linkedList) {
                if (TaskQueue.this.closed) {
                    return false;
                }
                if (TaskQueue.this.currentThread == null || TaskQueue.this.currentThread != this.thread) {
                    throw new IllegalStateException();
                }
                switch (this.status) {
                    case 2: {
                        this.countDown();
                        return false;
                    }
                    case 1: {
                        throw new IllegalStateException();
                    }
                }
                this.status = 1;
                boolean added = TaskQueue.this.continuations.add(this);
                assert (added);
                TaskQueue.this.currentThread = null;
                TaskQueue.this.currentTask = null;
            }
            this.executor.execute(TaskQueue.this.runner);
            return true;
        }
    }

    public static final class CloseResult {
        private final Thread activeThread;
        private final Runnable activeTask;
        private final List<Runnable> suspendedTasks;
        private final List<Thread> suspendedThreads;

        private CloseResult(Thread activeThread, Runnable activeTask, List<Thread> suspendedThreads, List<Runnable> suspendedTasks) {
            this.activeThread = activeThread;
            this.activeTask = activeTask;
            this.suspendedThreads = suspendedThreads;
            this.suspendedTasks = suspendedTasks;
        }

        public Thread activeThread() {
            return this.activeThread;
        }

        public Runnable activeTask() {
            return this.activeTask;
        }

        public List<Thread> suspendedThreads() {
            return this.suspendedThreads;
        }

        public List<Runnable> suspendedTasks() {
            return this.suspendedTasks;
        }
    }

    private static interface Task {
    }
}

