/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.file.impl;

import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.VertxException;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.file.FileSystemOptions;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.file.impl.FileCache;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.file.impl.FileSystemImpl;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.Utils;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.impl.URIDecoder;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.spi.file.FileResolver;

public class FileResolverImpl
implements FileResolver {
    public static final String DISABLE_FILE_CACHING_PROP_NAME = "vertx.disableFileCaching";
    public static final String DISABLE_CP_RESOLVING_PROP_NAME = "vertx.disableFileCPResolving";
    public static final String CACHE_DIR_BASE_PROP_NAME = "vertx.cacheDirBase";
    private static final boolean NON_UNIX_FILE_SEP = File.separatorChar != '/';
    private static final String JAR_URL_SEP = "!/";
    private final File cwd;
    private final boolean enableCaching;
    private final boolean enableCPResolving;
    private final FileCache cache;

    public FileResolverImpl() {
        this(new FileSystemOptions());
    }

    public FileResolverImpl(FileSystemOptions fileSystemOptions) {
        this.enableCaching = fileSystemOptions.isFileCachingEnabled();
        this.enableCPResolving = fileSystemOptions.isClassPathResolvingEnabled();
        this.cache = this.enableCPResolving ? FileCache.setupCache(fileSystemOptions.getFileCacheDir()) : null;
        String cwdOverride = System.getProperty("vertx.cwd");
        this.cwd = cwdOverride != null ? new File(cwdOverride).getAbsoluteFile() : null;
    }

    public String cacheDir() {
        if (this.cache != null) {
            return this.cache.cacheDir();
        }
        return null;
    }

    FileCache getFileCache() {
        return this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.enableCPResolving) {
            FileCache fileCache = this.cache;
            synchronized (fileCache) {
                this.cache.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File resolveFile(String fileName) {
        File file = new File(fileName);
        boolean absolute = file.isAbsolute();
        File resolved = this.cwd != null && !absolute ? new File(this.cwd, fileName) : file;
        if (this.cache == null) {
            return resolved;
        }
        if (resolved.getPath().isEmpty() || !resolved.exists()) {
            FileCache fileCache = this.cache;
            synchronized (fileCache) {
                File cacheFile = this.cache.getCanonicalFile(file);
                if (cacheFile == null) {
                    return file;
                }
                String relativize = this.cache.relativize(cacheFile.getPath());
                if (relativize != null) {
                    if (this.enableCaching && cacheFile.exists()) {
                        return cacheFile;
                    }
                    if (absolute) {
                        fileName = relativize;
                        file = new File(relativize);
                        absolute = false;
                    }
                }
                if (!absolute) {
                    URL url;
                    ClassLoader cl = this.getClassLoader();
                    for (File parentFile = file.getParentFile(); parentFile != null; parentFile = parentFile.getParentFile()) {
                        URL directoryContents;
                        String parentFileName = parentFile.getPath();
                        if (NON_UNIX_FILE_SEP) {
                            parentFileName = parentFileName.replace(File.separatorChar, '/');
                        }
                        if ((directoryContents = FileResolverImpl.getValidClassLoaderResource(cl, parentFileName)) == null) continue;
                        this.unpackUrlResource(directoryContents, parentFileName, cl, true);
                    }
                    if (NON_UNIX_FILE_SEP) {
                        fileName = fileName.replace(File.separatorChar, '/');
                    }
                    if ((url = FileResolverImpl.getValidClassLoaderResource(cl, fileName)) != null) {
                        return this.unpackUrlResource(url, fileName, cl, false);
                    }
                }
            }
        }
        return file;
    }

    private static boolean isValidWindowsCachePath(char c) {
        if (c < ' ') {
            return false;
        }
        switch (c) {
            case '\"': 
            case '*': 
            case ':': 
            case '<': 
            case '>': 
            case '?': 
            case '|': {
                return false;
            }
        }
        return true;
    }

    private static boolean isValidCachePath(String fileName) {
        if (PlatformDependent.isWindows()) {
            int len = fileName.length();
            for (int i = 0; i < len; ++i) {
                char c = fileName.charAt(i);
                if (!FileResolverImpl.isValidWindowsCachePath(c)) {
                    return false;
                }
                if (c != ' ' || i + 1 != len && fileName.charAt(i + 1) != '/') continue;
                return false;
            }
            return true;
        }
        return fileName.indexOf(0) == -1;
    }

    private static URL getValidClassLoaderResource(ClassLoader cl, String fileName) {
        URL resource = cl.getResource(fileName);
        if (resource != null && !FileResolverImpl.isValidCachePath(fileName)) {
            return null;
        }
        return resource;
    }

    private File unpackUrlResource(URL url, String fileName, ClassLoader cl, boolean isDir) {
        String prot;
        switch (prot = url.getProtocol()) {
            case "file": {
                return this.unpackFromFileURL(url, fileName, cl);
            }
            case "jar": {
                return this.unpackFromJarURL(url, fileName, cl);
            }
            case "bundle": 
            case "bundleentry": 
            case "bundleresource": 
            case "jrt": 
            case "resource": 
            case "vfs": {
                return this.unpackFromBundleURL(url, fileName, isDir);
            }
        }
        throw new IllegalStateException("Invalid url protocol: " + prot);
    }

    private File unpackFromFileURL(URL url, String fileName, ClassLoader cl) {
        String[] listing;
        File cacheFile;
        File resource = new File(URIDecoder.decodeURIComponent(url.getPath(), false));
        boolean isDirectory = resource.isDirectory();
        try {
            cacheFile = this.cache.cacheFile(fileName, resource, !this.enableCaching);
        }
        catch (IOException e) {
            throw new VertxException(FileSystemImpl.getFileAccessErrorMessage("unpack", url.toString()), e);
        }
        if (isDirectory && (listing = resource.list()) != null) {
            for (String file : listing) {
                String subResource = fileName + "/" + file;
                URL url2 = FileResolverImpl.getValidClassLoaderResource(cl, subResource);
                if (url2 == null) {
                    throw new VertxException("Invalid resource: " + subResource);
                }
                this.unpackFromFileURL(url2, subResource, cl);
            }
        }
        return cacheFile;
    }

    private List<String> listOfEntries(URL url) {
        String path = url.getPath();
        ArrayList<String> list = new ArrayList<String>();
        int last = path.length();
        int i = path.length() - 2;
        while (i >= 0) {
            if (path.charAt(i) == '!' && path.charAt(i + 1) == '/') {
                list.add(path.substring(2 + i, last));
                last = i;
                i -= 2;
                continue;
            }
            --i;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private File unpackFromJarURL(URL url, String fileName, ClassLoader cl) {
        try {
            listOfEntries = this.listOfEntries(url);
            switch (listOfEntries.size()) {
                case 1: {
                    conn = (JarURLConnection)url.openConnection();
                    if (conn.getContentLength() == -1) {
                        return this.cache.getFile(fileName);
                    }
                    zip = conn.getJarFile();
                    try {
                        this.extractFilesFromJarFile(zip, fileName);
                        break;
                    }
                    finally {
                        if (!conn.getUseCaches()) {
                            zip.close();
                        }
                    }
                }
                case 2: {
                    nestedURL = cl.getResource(listOfEntries.get(1));
                    if (nestedURL == null || !nestedURL.getProtocol().equals("jar")) ** GOTO lbl54
                    root = this.unpackFromJarURL(nestedURL, listOfEntries.get(1), cl);
                    if (root.isDirectory()) {
                        path = root.toPath();
                        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                            @Override
                            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                                Path relative = path.relativize(dir);
                                FileResolverImpl.this.cache.cacheDir(relative.toString());
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                Path relative = path.relativize(file);
                                FileResolverImpl.this.cache.cacheFile(relative.toString(), file.toFile(), false);
                                return FileVisitResult.CONTINUE;
                            }
                        });
                        break;
                    }
                    zip = new ZipFile(root);
                    var8_13 = null;
                    this.extractFilesFromJarFile(zip, fileName);
                    if (zip == null) break;
                    if (var8_13 == null) ** GOTO lbl37
                    try {
                        zip.close();
                    }
                    catch (Throwable var9_14) {
                        var8_13.addSuppressed(var9_14);
                    }
                    break;
lbl37:
                    // 1 sources

                    zip.close();
                    break;
                    catch (Throwable var9_15) {
                        try {
                            var8_13 = var9_15;
                            throw var9_15;
                        }
                        catch (Throwable var10_16) {
                            if (zip != null) {
                                if (var8_13 != null) {
                                    try {
                                        zip.close();
                                    }
                                    catch (Throwable var11_17) {
                                        var8_13.addSuppressed(var11_17);
                                    }
                                } else {
                                    zip.close();
                                }
                            }
                            throw var10_16;
                        }
                    }
lbl54:
                    // 1 sources

                    throw new VertxException("Unexpected nested url : " + nestedURL);
                }
                default: {
                    throw new VertxException("Nesting more than two levels is not supported");
                }
            }
        }
        catch (IOException e) {
            throw new VertxException(FileSystemImpl.getFileAccessErrorMessage("unpack", url.toString()), e);
        }
        return this.cache.getFile(fileName);
    }

    private void extractFilesFromJarFile(ZipFile zip, String entryFilter) throws IOException {
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            int len = name.length();
            if (len == 0) {
                return;
            }
            if (name.charAt(len - 1) == ' ' && Utils.isWindows() || !name.startsWith(entryFilter)) continue;
            if (name.charAt(len - 1) == '/') {
                this.cache.cacheDir(name);
                continue;
            }
            InputStream is = zip.getInputStream(entry);
            Throwable throwable = null;
            try {
                this.cache.cacheFile(name, is, !this.enableCaching);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                is.close();
            }
        }
    }

    private boolean isBundleUrlDirectory(URL url) {
        return url.toExternalForm().endsWith("/") || FileResolverImpl.getValidClassLoaderResource(this.getClassLoader(), url.getPath().substring(1) + "/") != null;
    }

    private File unpackFromBundleURL(URL url, String fileName, boolean isDir) {
        block15: {
            try {
                if (this.getClassLoader() != null && this.isBundleUrlDirectory(url) || isDir) {
                    this.cache.cacheDir(fileName);
                    break block15;
                }
                try (InputStream is = url.openStream();){
                    this.cache.cacheFile(fileName, is, !this.enableCaching);
                }
            }
            catch (IOException e) {
                throw new VertxException(FileSystemImpl.getFileAccessErrorMessage("unpack", url.toString()), e);
            }
        }
        return this.cache.getFile(fileName);
    }

    private ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        if (cl == null) {
            cl = Object.class.getClassLoader();
        }
        return cl;
    }
}

