/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.util.ReferenceCountUtil;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.LogRecordSet;
import org.apache.distributedlog.exceptions.LogRecordTooLongException;
import org.apache.distributedlog.exceptions.WriteException;
import org.apache.distributedlog.io.CompressionCodec;
import org.apache.distributedlog.io.CompressionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EnvelopedRecordSetWriter
implements LogRecordSet.Writer {
    private static final Logger log = LoggerFactory.getLogger(EnvelopedRecordSetWriter.class);
    private final ByteBuf buffer;
    private final List<CompletableFuture<DLSN>> promiseList;
    private final CompressionCodec.Type codec;
    private final int metadata;
    private final int codecCode;
    private int count = 0;
    private ByteBuf recordSetBuffer = null;

    EnvelopedRecordSetWriter(int initialBufferSize, CompressionCodec.Type codec) {
        this.buffer = PooledByteBufAllocator.DEFAULT.buffer(Math.max(initialBufferSize, 16), 1044480);
        this.promiseList = new LinkedList<CompletableFuture<DLSN>>();
        this.codec = codec;
        this.codecCode = codec.code();
        this.metadata = 0x1000 | this.codecCode & 3;
        this.buffer.writeInt(this.metadata);
        this.buffer.writeInt(0);
        this.buffer.writeInt(0);
        this.buffer.writeInt(0);
    }

    synchronized List<CompletableFuture<DLSN>> getPromiseList() {
        return this.promiseList;
    }

    @Override
    public synchronized void writeRecord(ByteBuffer record, CompletableFuture<DLSN> transmitPromise) throws LogRecordTooLongException, WriteException {
        int logRecordSize = record.remaining();
        if (logRecordSize > 1040384) {
            throw new LogRecordTooLongException("Log Record of size " + logRecordSize + " written when only " + 1040384 + " is allowed");
        }
        this.buffer.writeInt(logRecordSize);
        this.buffer.writeBytes(record);
        ++this.count;
        this.promiseList.add(transmitPromise);
    }

    private synchronized void satisfyPromises(long lssn, long entryId, long startSlotId) {
        long nextSlotId = startSlotId;
        for (CompletableFuture<DLSN> promise : this.promiseList) {
            promise.complete(new DLSN(lssn, entryId, nextSlotId));
            ++nextSlotId;
        }
        this.promiseList.clear();
    }

    private synchronized void cancelPromises(Throwable reason) {
        for (CompletableFuture<DLSN> promise : this.promiseList) {
            promise.completeExceptionally(reason);
        }
        this.promiseList.clear();
    }

    @Override
    public int getNumBytes() {
        return this.buffer.readableBytes();
    }

    @Override
    public synchronized int getNumRecords() {
        return this.count;
    }

    @Override
    public synchronized ByteBuf getBuffer() {
        if (null == this.recordSetBuffer) {
            this.recordSetBuffer = this.createBuffer();
        }
        return this.recordSetBuffer.retainedSlice();
    }

    ByteBuf createBuffer() {
        int dataOffset = 16;
        int dataLen = this.buffer.readableBytes() - 16;
        if (CompressionCodec.Type.NONE.code() == this.codecCode) {
            this.buffer.setInt(4, this.count);
            this.buffer.setInt(8, dataLen);
            this.buffer.setInt(12, dataLen);
            return this.buffer.retain();
        }
        CompressionCodec compressor = CompressionUtils.getCompressionCodec((CompressionCodec.Type)this.codec);
        ByteBuf uncompressedBuf = this.buffer.slice(dataOffset, dataLen);
        ByteBuf compressedBuf = compressor.compress(uncompressedBuf, 16);
        compressedBuf.setInt(0, this.metadata);
        compressedBuf.setInt(4, this.count);
        compressedBuf.setInt(8, dataLen);
        compressedBuf.setInt(12, compressedBuf.readableBytes() - 16);
        return compressedBuf;
    }

    @Override
    public synchronized void completeTransmit(long lssn, long entryId, long startSlotId) {
        this.satisfyPromises(lssn, entryId, startSlotId);
        ReferenceCountUtil.release((Object)this.buffer);
        ReferenceCountUtil.release((Object)this.recordSetBuffer);
    }

    @Override
    public synchronized void abortTransmit(Throwable reason) {
        this.cancelPromises(reason);
        ReferenceCountUtil.release((Object)this.buffer);
        ReferenceCountUtil.release((Object)this.recordSetBuffer);
    }
}

