/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.ApiextensionsV1WebhookClientConfig;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="WebhookConversion describes how to call a conversion webhook")
public class V1WebhookConversion {
    public static final String SERIALIZED_NAME_CLIENT_CONFIG = "clientConfig";
    @SerializedName(value="clientConfig")
    private ApiextensionsV1WebhookClientConfig clientConfig;
    public static final String SERIALIZED_NAME_CONVERSION_REVIEW_VERSIONS = "conversionReviewVersions";
    @SerializedName(value="conversionReviewVersions")
    private List<String> conversionReviewVersions = new ArrayList<String>();

    public V1WebhookConversion clientConfig(ApiextensionsV1WebhookClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ApiextensionsV1WebhookClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public void setClientConfig(ApiextensionsV1WebhookClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    public V1WebhookConversion conversionReviewVersions(List<String> conversionReviewVersions) {
        this.conversionReviewVersions = conversionReviewVersions;
        return this;
    }

    public V1WebhookConversion addConversionReviewVersionsItem(String conversionReviewVersionsItem) {
        this.conversionReviewVersions.add(conversionReviewVersionsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="conversionReviewVersions is an ordered list of preferred `ConversionReview` versions the Webhook expects. The API server will use the first version in the list which it supports. If none of the versions specified in this list are supported by API server, conversion will fail for the custom resource. If a persisted Webhook configuration specifies allowed versions and does not include any versions known to the API Server, calls to the webhook will fail.")
    public List<String> getConversionReviewVersions() {
        return this.conversionReviewVersions;
    }

    public void setConversionReviewVersions(List<String> conversionReviewVersions) {
        this.conversionReviewVersions = conversionReviewVersions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1WebhookConversion v1WebhookConversion = (V1WebhookConversion)o;
        return Objects.equals(this.clientConfig, v1WebhookConversion.clientConfig) && Objects.equals(this.conversionReviewVersions, v1WebhookConversion.conversionReviewVersions);
    }

    public int hashCode() {
        return Objects.hash(this.clientConfig, this.conversionReviewVersions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1WebhookConversion {\n");
        sb.append("    clientConfig: ").append(this.toIndentedString(this.clientConfig)).append("\n");
        sb.append("    conversionReviewVersions: ").append(this.toIndentedString(this.conversionReviewVersions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

