/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1Toleration;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Scheduling specifies the scheduling constraints for nodes supporting a RuntimeClass.")
public class V1Scheduling {
    public static final String SERIALIZED_NAME_NODE_SELECTOR = "nodeSelector";
    @SerializedName(value="nodeSelector")
    private Map<String, String> nodeSelector = null;
    public static final String SERIALIZED_NAME_TOLERATIONS = "tolerations";
    @SerializedName(value="tolerations")
    private List<V1Toleration> tolerations = null;

    public V1Scheduling nodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector;
        return this;
    }

    public V1Scheduling putNodeSelectorItem(String key, String nodeSelectorItem) {
        if (this.nodeSelector == null) {
            this.nodeSelector = new HashMap<String, String>();
        }
        this.nodeSelector.put(key, nodeSelectorItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="nodeSelector lists labels that must be present on nodes that support this RuntimeClass. Pods using this RuntimeClass can only be scheduled to a node matched by this selector. The RuntimeClass nodeSelector is merged with a pod's existing nodeSelector. Any conflicts will cause the pod to be rejected in admission.")
    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    public void setNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector;
    }

    public V1Scheduling tolerations(List<V1Toleration> tolerations) {
        this.tolerations = tolerations;
        return this;
    }

    public V1Scheduling addTolerationsItem(V1Toleration tolerationsItem) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<V1Toleration>();
        }
        this.tolerations.add(tolerationsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="tolerations are appended (excluding duplicates) to pods running with this RuntimeClass during admission, effectively unioning the set of nodes tolerated by the pod and the RuntimeClass.")
    public List<V1Toleration> getTolerations() {
        return this.tolerations;
    }

    public void setTolerations(List<V1Toleration> tolerations) {
        this.tolerations = tolerations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1Scheduling v1Scheduling = (V1Scheduling)o;
        return Objects.equals(this.nodeSelector, v1Scheduling.nodeSelector) && Objects.equals(this.tolerations, v1Scheduling.tolerations);
    }

    public int hashCode() {
        return Objects.hash(this.nodeSelector, this.tolerations);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1Scheduling {\n");
        sb.append("    nodeSelector: ").append(this.toIndentedString(this.nodeSelector)).append("\n");
        sb.append("    tolerations: ").append(this.toIndentedString(this.tolerations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

