/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import lombok.Generated;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.RemovedHashRanges;

public class ImpactedConsumersResult {
    private final Map<Consumer, RemovedHashRanges> removedHashRanges;

    private ImpactedConsumersResult(Map<Consumer, RemovedHashRanges> removedHashRanges) {
        this.removedHashRanges = removedHashRanges;
    }

    public static ImpactedConsumersResult of(Map<Consumer, RemovedHashRanges> removedHashRanges) {
        return new ImpactedConsumersResult(removedHashRanges);
    }

    public void processRemovedHashRanges(RemovedHashRangesProcessor processor) {
        this.removedHashRanges.forEach((c, r) -> processor.process((Consumer)c, (RemovedHashRanges)r));
    }

    public boolean isEmpty() {
        return this.removedHashRanges.isEmpty();
    }

    @VisibleForTesting
    Map<Consumer, RemovedHashRanges> getRemovedHashRanges() {
        return this.removedHashRanges;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImpactedConsumersResult)) {
            return false;
        }
        ImpactedConsumersResult other = (ImpactedConsumersResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<Consumer, RemovedHashRanges> this$removedHashRanges = this.getRemovedHashRanges();
        Map<Consumer, RemovedHashRanges> other$removedHashRanges = other.getRemovedHashRanges();
        return !(this$removedHashRanges == null ? other$removedHashRanges != null : !((Object)this$removedHashRanges).equals(other$removedHashRanges));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ImpactedConsumersResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<Consumer, RemovedHashRanges> $removedHashRanges = this.getRemovedHashRanges();
        result = result * 59 + ($removedHashRanges == null ? 43 : ((Object)$removedHashRanges).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ImpactedConsumersResult(removedHashRanges=" + this.getRemovedHashRanges() + ")";
    }

    public static interface RemovedHashRangesProcessor {
        public void process(Consumer var1, RemovedHashRanges var2);
    }
}

