/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.metrics.BatchCallback;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import org.apache.bookkeeper.mledger.ManagedLedgerFactoryMXBean;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerFactoryImpl;
import org.apache.bookkeeper.mledger.impl.cache.PooledByteBufAllocatorStats;
import org.apache.bookkeeper.mledger.impl.cache.RangeEntryCacheImpl;
import org.apache.pulsar.opentelemetry.OpenTelemetryAttributes;

public class OpenTelemetryManagedLedgerCacheStats
implements AutoCloseable {
    public static final String MANAGED_LEDGER_COUNTER = "pulsar.broker.managed_ledger.count";
    private final ObservableLongMeasurement managedLedgerCounter;
    public static final String CACHE_EVICTION_OPERATION_COUNTER = "pulsar.broker.managed_ledger.cache.eviction.count";
    private final ObservableLongMeasurement cacheEvictionOperationCounter;
    public static final String CACHE_ENTRY_COUNTER = "pulsar.broker.managed_ledger.cache.entry.count";
    private final ObservableLongMeasurement cacheEntryCounter;
    public static final String CACHE_SIZE_COUNTER = "pulsar.broker.managed_ledger.cache.entry.size";
    private final ObservableLongMeasurement cacheSizeCounter;
    public static final String CACHE_OPERATION_COUNTER = "pulsar.broker.managed_ledger.cache.operation.count";
    private final ObservableLongMeasurement cacheOperationCounter;
    public static final String CACHE_OPERATION_BYTES_COUNTER = "pulsar.broker.managed_ledger.cache.operation.size";
    private final ObservableLongMeasurement cacheOperationBytesCounter;
    public static final String CACHE_POOL_ACTIVE_ALLOCATION_COUNTER = "pulsar.broker.managed_ledger.cache.pool.allocation.active.count";
    private final ObservableLongMeasurement cachePoolActiveAllocationCounter;
    public static final String CACHE_POOL_ACTIVE_ALLOCATION_SIZE_COUNTER = "pulsar.broker.managed_ledger.cache.pool.allocation.size";
    private final ObservableLongMeasurement cachePoolActiveAllocationSizeCounter;
    private final BatchCallback batchCallback;

    public OpenTelemetryManagedLedgerCacheStats(OpenTelemetry openTelemetry, ManagedLedgerFactoryImpl factory) {
        Meter meter = openTelemetry.getMeter("org.apache.pulsar.broker");
        this.managedLedgerCounter = meter.upDownCounterBuilder(MANAGED_LEDGER_COUNTER).setUnit("{managed_ledger}").setDescription("The total number of managed ledgers.").buildObserver();
        this.cacheEvictionOperationCounter = meter.counterBuilder(CACHE_EVICTION_OPERATION_COUNTER).setUnit("{eviction}").setDescription("The total number of cache eviction operations.").buildObserver();
        this.cacheEntryCounter = meter.upDownCounterBuilder(CACHE_ENTRY_COUNTER).setUnit("{entry}").setDescription("The number of entries in the entry cache.").buildObserver();
        this.cacheSizeCounter = meter.upDownCounterBuilder(CACHE_SIZE_COUNTER).setUnit("{By}").setDescription("The byte amount of entries stored in the entry cache.").buildObserver();
        this.cacheOperationCounter = meter.counterBuilder(CACHE_OPERATION_COUNTER).setUnit("{entry}").setDescription("The number of cache operations.").buildObserver();
        this.cacheOperationBytesCounter = meter.counterBuilder(CACHE_OPERATION_BYTES_COUNTER).setUnit("{By}").setDescription("The byte amount of data retrieved from cache operations.").buildObserver();
        this.cachePoolActiveAllocationCounter = meter.upDownCounterBuilder(CACHE_POOL_ACTIVE_ALLOCATION_COUNTER).setUnit("{allocation}").setDescription("The number of currently active allocations in the direct arena.").buildObserver();
        this.cachePoolActiveAllocationSizeCounter = meter.upDownCounterBuilder(CACHE_POOL_ACTIVE_ALLOCATION_SIZE_COUNTER).setUnit("{By}").setDescription("The memory allocated in the direct arena.").buildObserver();
        this.batchCallback = meter.batchCallback(() -> this.recordMetrics(factory), (ObservableMeasurement)this.managedLedgerCounter, new ObservableMeasurement[]{this.cacheEvictionOperationCounter, this.cacheEntryCounter, this.cacheSizeCounter, this.cacheOperationCounter, this.cacheOperationBytesCounter, this.cachePoolActiveAllocationCounter, this.cachePoolActiveAllocationSizeCounter});
    }

    @Override
    public void close() {
        this.batchCallback.close();
    }

    private void recordMetrics(ManagedLedgerFactoryImpl factory) {
        ManagedLedgerFactoryMXBean stats = factory.getCacheStats();
        this.managedLedgerCounter.record((long)stats.getNumberOfManagedLedgers());
        this.cacheEvictionOperationCounter.record(stats.getNumberOfCacheEvictionsTotal());
        long entriesOut = stats.getCacheEvictedEntriesCount();
        long entriesIn = stats.getCacheInsertedEntriesCount();
        long entriesActive = entriesIn - entriesOut;
        this.cacheEntryCounter.record(entriesActive, OpenTelemetryAttributes.CacheEntryStatus.ACTIVE.attributes);
        this.cacheEntryCounter.record(entriesIn, OpenTelemetryAttributes.CacheEntryStatus.INSERTED.attributes);
        this.cacheEntryCounter.record(entriesOut, OpenTelemetryAttributes.CacheEntryStatus.EVICTED.attributes);
        this.cacheSizeCounter.record(stats.getCacheUsedSize());
        this.cacheOperationCounter.record(stats.getCacheHitsTotal(), OpenTelemetryAttributes.CacheOperationStatus.HIT.attributes);
        this.cacheOperationBytesCounter.record(stats.getCacheHitsBytesTotal(), OpenTelemetryAttributes.CacheOperationStatus.HIT.attributes);
        this.cacheOperationCounter.record(stats.getCacheMissesTotal(), OpenTelemetryAttributes.CacheOperationStatus.MISS.attributes);
        this.cacheOperationBytesCounter.record(stats.getCacheMissesBytesTotal(), OpenTelemetryAttributes.CacheOperationStatus.MISS.attributes);
        PooledByteBufAllocatorStats allocatorStats = new PooledByteBufAllocatorStats(RangeEntryCacheImpl.ALLOCATOR);
        this.cachePoolActiveAllocationCounter.record(allocatorStats.activeAllocationsSmall, OpenTelemetryAttributes.PoolArenaType.SMALL.attributes);
        this.cachePoolActiveAllocationCounter.record(allocatorStats.activeAllocationsNormal, OpenTelemetryAttributes.PoolArenaType.NORMAL.attributes);
        this.cachePoolActiveAllocationCounter.record(allocatorStats.activeAllocationsHuge, OpenTelemetryAttributes.PoolArenaType.HUGE.attributes);
        this.cachePoolActiveAllocationSizeCounter.record(allocatorStats.totalAllocated, OpenTelemetryAttributes.PoolChunkAllocationType.ALLOCATED.attributes);
        this.cachePoolActiveAllocationSizeCounter.record(allocatorStats.totalUsed, OpenTelemetryAttributes.PoolChunkAllocationType.USED.attributes);
    }
}

