/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stats.prometheus;

import com.google.common.annotations.VisibleForTesting;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.internal.PlatformDependent;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Gauge;
import io.prometheus.client.hotspot.GarbageCollectorExports;
import io.prometheus.client.hotspot.MemoryPoolsExports;
import io.prometheus.client.hotspot.StandardExports;
import io.prometheus.client.hotspot.ThreadExports;
import java.io.IOException;
import java.io.Writer;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import javax.servlet.Servlet;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stats.StatsProvider;
import org.apache.bookkeeper.stats.ThreadRegistry;
import org.apache.bookkeeper.stats.prometheus.DataSketchesOpStatsLogger;
import org.apache.bookkeeper.stats.prometheus.LongAdderCounter;
import org.apache.bookkeeper.stats.prometheus.PrometheusServlet;
import org.apache.bookkeeper.stats.prometheus.PrometheusStatsLogger;
import org.apache.bookkeeper.stats.prometheus.PrometheusTextFormat;
import org.apache.bookkeeper.stats.prometheus.ScopeContext;
import org.apache.bookkeeper.stats.prometheus.SimpleGauge;
import org.apache.bookkeeper.stats.prometheus.ThreadScopedDataSketchesStatsLogger;
import org.apache.bookkeeper.stats.prometheus.ThreadScopedLongAdderCounter;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusMetricsProvider
implements StatsProvider {
    private ScheduledExecutorService executor;
    public static final String PROMETHEUS_STATS_HTTP_ENABLE = "prometheusStatsHttpEnable";
    public static final boolean DEFAULT_PROMETHEUS_STATS_HTTP_ENABLE = true;
    public static final String PROMETHEUS_STATS_HTTP_ADDRESS = "prometheusStatsHttpAddress";
    public static final String DEFAULT_PROMETHEUS_STATS_HTTP_ADDR = "0.0.0.0";
    public static final String PROMETHEUS_STATS_HTTP_PORT = "prometheusStatsHttpPort";
    public static final int DEFAULT_PROMETHEUS_STATS_HTTP_PORT = 8000;
    public static final String PROMETHEUS_STATS_LATENCY_ROLLOVER_SECONDS = "prometheusStatsLatencyRolloverSeconds";
    public static final int DEFAULT_PROMETHEUS_STATS_LATENCY_ROLLOVER_SECONDS = 60;
    final CollectorRegistry registry;
    Server server;
    final ConcurrentMap<ScopeContext, LongAdderCounter> counters = new ConcurrentHashMap<ScopeContext, LongAdderCounter>();
    final ConcurrentMap<ScopeContext, SimpleGauge<? extends Number>> gauges = new ConcurrentHashMap<ScopeContext, SimpleGauge<? extends Number>>();
    final ConcurrentMap<ScopeContext, DataSketchesOpStatsLogger> opStats = new ConcurrentHashMap<ScopeContext, DataSketchesOpStatsLogger>();
    final ConcurrentMap<ScopeContext, ThreadScopedDataSketchesStatsLogger> threadScopedOpStats = new ConcurrentHashMap<ScopeContext, ThreadScopedDataSketchesStatsLogger>();
    final ConcurrentMap<ScopeContext, ThreadScopedLongAdderCounter> threadScopedCounters = new ConcurrentHashMap<ScopeContext, ThreadScopedLongAdderCounter>();
    private static final Logger log = LoggerFactory.getLogger(PrometheusMetricsProvider.class);
    private static final AtomicLong directMemoryUsage;
    private static final Optional<BufferPoolMXBean> poolMxBeanOp;
    private static final Supplier<Double> getDirectMemoryUsage;

    public PrometheusMetricsProvider() {
        this(CollectorRegistry.defaultRegistry);
    }

    public PrometheusMetricsProvider(CollectorRegistry registry) {
        this.registry = registry;
    }

    public void start(Configuration conf) {
        boolean httpEnabled = conf.getBoolean(PROMETHEUS_STATS_HTTP_ENABLE, true);
        boolean bkHttpServerEnabled = conf.getBoolean("httpServerEnabled", false);
        boolean exposeDefaultJVMMetrics = conf.getBoolean("exposeDefaultJVMMetrics", true);
        if (httpEnabled && !bkHttpServerEnabled) {
            String httpAddr = conf.getString(PROMETHEUS_STATS_HTTP_ADDRESS, DEFAULT_PROMETHEUS_STATS_HTTP_ADDR);
            int httpPort = conf.getInt(PROMETHEUS_STATS_HTTP_PORT, 8000);
            InetSocketAddress httpEndpoint = InetSocketAddress.createUnresolved(httpAddr, httpPort);
            this.server = new Server(httpEndpoint);
            ServletContextHandler context = new ServletContextHandler();
            context.setContextPath("/");
            this.server.setHandler((Handler)context);
            context.addServlet(new ServletHolder((Servlet)new PrometheusServlet(this)), "/metrics");
            try {
                this.server.start();
                log.info("Started Prometheus stats endpoint at {}", (Object)httpEndpoint);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (exposeDefaultJVMMetrics) {
            this.registerMetrics((Collector)new StandardExports());
            this.registerMetrics((Collector)new MemoryPoolsExports());
            this.registerMetrics((Collector)new GarbageCollectorExports());
            this.registerMetrics((Collector)new ThreadExports());
            this.registerMetrics(Gauge.build((String)"jvm_memory_direct_bytes_used", (String)"-").create().setChild((Object)new Gauge.Child(){

                public double get() {
                    return (Double)getDirectMemoryUsage.get();
                }
            }, new String[0]));
            this.registerMetrics(Gauge.build((String)"jvm_memory_direct_bytes_max", (String)"-").create().setChild((Object)new Gauge.Child(){

                public double get() {
                    return PlatformDependent.estimateMaxDirectMemory();
                }
            }, new String[0]));
        }
        this.executor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("metrics"));
        int latencyRolloverSeconds = conf.getInt(PROMETHEUS_STATS_LATENCY_ROLLOVER_SECONDS, 60);
        this.executor.scheduleAtFixedRate(() -> this.rotateLatencyCollection(), 1L, latencyRolloverSeconds, TimeUnit.SECONDS);
    }

    public void stop() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                log.warn("Failed to shutdown Jetty server", (Throwable)e);
            }
            finally {
                ThreadRegistry.clear();
            }
        }
    }

    public StatsLogger getStatsLogger(String scope) {
        return new PrometheusStatsLogger(this, scope, Collections.emptyMap());
    }

    public void writeAllMetrics(Writer writer) throws IOException {
        PrometheusTextFormat prometheusTextFormat = new PrometheusTextFormat();
        PrometheusTextFormat.writeMetricsCollectedByPrometheusClient(writer, this.registry);
        this.gauges.forEach((sc, gauge) -> prometheusTextFormat.writeGauge(writer, sc.getScope(), (SimpleGauge<? extends Number>)gauge));
        this.counters.forEach((sc, counter) -> prometheusTextFormat.writeCounter(writer, sc.getScope(), (LongAdderCounter)counter));
        this.opStats.forEach((sc, opStatLogger) -> prometheusTextFormat.writeOpStat(writer, sc.getScope(), (DataSketchesOpStatsLogger)opStatLogger));
    }

    public String getStatsName(String ... statsComponents) {
        if (statsComponents.length == 0) {
            return "";
        }
        String completeName = statsComponents[0].isEmpty() ? StringUtils.join((Object[])statsComponents, (char)'_', (int)1, (int)statsComponents.length) : StringUtils.join((Object[])statsComponents, (char)'_');
        return Collector.sanitizeMetricName((String)completeName);
    }

    @VisibleForTesting
    void rotateLatencyCollection() {
        this.opStats.forEach((name, metric) -> metric.rotateLatencyCollection());
    }

    private void registerMetrics(Collector collector) {
        block2: {
            try {
                collector.register(this.registry);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("Failed to register Prometheus collector exports", (Throwable)e);
            }
        }
    }

    static {
        if (PlatformDependent.useDirectBufferNoCleaner()) {
            poolMxBeanOp = Optional.empty();
            AtomicLong tmpDirectMemoryUsage = null;
            try {
                Field field = PlatformDependent.class.getDeclaredField("DIRECT_MEMORY_COUNTER");
                field.setAccessible(true);
                tmpDirectMemoryUsage = (AtomicLong)field.get(null);
            }
            catch (Throwable t) {
                log.warn("Failed to access netty DIRECT_MEMORY_COUNTER field {}", (Object)t.getMessage());
            }
            directMemoryUsage = tmpDirectMemoryUsage;
            getDirectMemoryUsage = () -> directMemoryUsage != null ? (double)directMemoryUsage.get() : Double.NaN;
        } else {
            directMemoryUsage = null;
            List<BufferPoolMXBean> platformMXBeans = ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class);
            poolMxBeanOp = platformMXBeans.stream().filter(bufferPoolMXBean -> bufferPoolMXBean.getName().equals("direct")).findAny();
            getDirectMemoryUsage = () -> poolMxBeanOp.isPresent() ? (double)poolMxBeanOp.get().getMemoryUsed() : Double.NaN;
        }
    }
}

