/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.ClientStreamTracer;
import io.grpc.ConnectivityState;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.util.MultiChildLoadBalancer;
import io.grpc.xds.LeastRequestLoadBalancerProvider;
import io.grpc.xds.ThreadSafeRandom;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

final class LeastRequestLoadBalancer
extends MultiChildLoadBalancer {
    private final ThreadSafeRandom random;
    private LoadBalancer.SubchannelPicker currentPicker = new EmptyPicker();
    private int choiceCount = LeastRequestLoadBalancerProvider.DEFAULT_CHOICE_COUNT;

    LeastRequestLoadBalancer(LoadBalancer.Helper helper) {
        this(helper, ThreadSafeRandom.ThreadSafeRandomImpl.instance);
    }

    @VisibleForTesting
    LeastRequestLoadBalancer(LoadBalancer.Helper helper, ThreadSafeRandom random) {
        super(helper);
        this.random = (ThreadSafeRandom)Preconditions.checkNotNull((Object)random, (Object)"random");
    }

    public Status acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        Status addressAcceptanceStatus;
        int oldChoiceCount = this.choiceCount;
        LeastRequestConfig config = (LeastRequestConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
        if (config != null) {
            this.choiceCount = config.choiceCount;
        }
        if (!(addressAcceptanceStatus = super.acceptResolvedAddresses(resolvedAddresses)).isOk()) {
            this.choiceCount = oldChoiceCount;
        }
        return addressAcceptanceStatus;
    }

    protected void updateOverallBalancingState() {
        List activeList = this.getReadyChildren();
        if (activeList.isEmpty()) {
            boolean isConnecting = false;
            ArrayList<MultiChildLoadBalancer.ChildLbState> childrenInTf = new ArrayList<MultiChildLoadBalancer.ChildLbState>();
            for (MultiChildLoadBalancer.ChildLbState childLbState : this.getChildLbStates()) {
                ConnectivityState state = childLbState.getCurrentState();
                if (state == ConnectivityState.CONNECTING || state == ConnectivityState.IDLE) {
                    isConnecting = true;
                    continue;
                }
                if (state != ConnectivityState.TRANSIENT_FAILURE) continue;
                childrenInTf.add(childLbState);
            }
            if (isConnecting) {
                this.updateBalancingState(ConnectivityState.CONNECTING, new EmptyPicker());
            } else {
                this.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new ReadyPicker(childrenInTf, this.choiceCount, this.random));
            }
        } else {
            this.updateBalancingState(ConnectivityState.READY, new ReadyPicker(activeList, this.choiceCount, this.random));
        }
    }

    protected MultiChildLoadBalancer.ChildLbState createChildLbState(Object key) {
        return new LeastRequestLbState(key, this.pickFirstLbProvider);
    }

    private void updateBalancingState(ConnectivityState state, LoadBalancer.SubchannelPicker picker) {
        if (state != this.currentConnectivityState || !picker.equals(this.currentPicker)) {
            this.getHelper().updateBalancingState(state, picker);
            this.currentConnectivityState = state;
            this.currentPicker = picker;
        }
    }

    @VisibleForTesting
    void setResolvingAddresses(boolean newValue) {
        this.resolvingAddresses = newValue;
    }

    private static AtomicInteger getInFlights(MultiChildLoadBalancer.ChildLbState childLbState) {
        return ((LeastRequestLbState)childLbState).activeRequests;
    }

    protected class LeastRequestLbState
    extends MultiChildLoadBalancer.ChildLbState {
        private final AtomicInteger activeRequests;

        public LeastRequestLbState(Object key, LoadBalancerProvider policyProvider) {
            super((MultiChildLoadBalancer)LeastRequestLoadBalancer.this, key, (LoadBalancer.Factory)policyProvider);
            this.activeRequests = new AtomicInteger(0);
        }

        int getActiveRequests() {
            return this.activeRequests.get();
        }

        protected MultiChildLoadBalancer.ChildLbState.ChildLbStateHelper createChildHelper() {
            return new MultiChildLoadBalancer.ChildLbState.ChildLbStateHelper(){

                public void updateBalancingState(ConnectivityState newState, LoadBalancer.SubchannelPicker newPicker) {
                    super.updateBalancingState(newState, newPicker);
                    if (!LeastRequestLoadBalancer.this.resolvingAddresses && newState == ConnectivityState.IDLE) {
                        LeastRequestLbState.this.getLb().requestConnection();
                    }
                }
            };
        }
    }

    static final class LeastRequestConfig {
        final int choiceCount;

        LeastRequestConfig(int choiceCount) {
            Preconditions.checkArgument((choiceCount >= 2 ? 1 : 0) != 0, (Object)"choiceCount <= 1");
            this.choiceCount = Math.min(choiceCount, 10);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("choiceCount", this.choiceCount).toString();
        }
    }

    private static final class OutstandingRequestsTracingFactory
    extends ClientStreamTracer.Factory {
        private final AtomicInteger inFlights;

        private OutstandingRequestsTracingFactory(AtomicInteger inFlights) {
            this.inFlights = (AtomicInteger)Preconditions.checkNotNull((Object)inFlights, (Object)"inFlights");
        }

        public ClientStreamTracer newClientStreamTracer(ClientStreamTracer.StreamInfo info, Metadata headers) {
            return new ClientStreamTracer(){

                public void streamCreated(Attributes transportAttrs, Metadata headers) {
                    inFlights.incrementAndGet();
                }

                public void streamClosed(Status status) {
                    inFlights.decrementAndGet();
                }
            };
        }
    }

    @VisibleForTesting
    static final class EmptyPicker
    extends LoadBalancer.SubchannelPicker {
        EmptyPicker() {
        }

        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            return LoadBalancer.PickResult.withNoResult();
        }

        public int hashCode() {
            return ((Object)((Object)this)).getClass().hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof EmptyPicker;
        }

        public String toString() {
            return MoreObjects.toStringHelper(EmptyPicker.class).toString();
        }
    }

    @VisibleForTesting
    static final class ReadyPicker
    extends LoadBalancer.SubchannelPicker {
        private final List<LoadBalancer.SubchannelPicker> childPickers;
        private final List<AtomicInteger> childInFlights;
        private final int choiceCount;
        private final ThreadSafeRandom random;
        private final int hashCode;

        ReadyPicker(List<MultiChildLoadBalancer.ChildLbState> childLbStates, int choiceCount, ThreadSafeRandom random) {
            Preconditions.checkArgument((!childLbStates.isEmpty() ? 1 : 0) != 0, (Object)"empty list");
            this.childPickers = new ArrayList<LoadBalancer.SubchannelPicker>(childLbStates.size());
            this.childInFlights = new ArrayList<AtomicInteger>(childLbStates.size());
            for (MultiChildLoadBalancer.ChildLbState state : childLbStates) {
                this.childPickers.add(state.getCurrentPicker());
                this.childInFlights.add(LeastRequestLoadBalancer.getInFlights(state));
            }
            this.choiceCount = choiceCount;
            this.random = (ThreadSafeRandom)Preconditions.checkNotNull((Object)random, (Object)"random");
            int sum = 0;
            for (LoadBalancer.SubchannelPicker child : this.childPickers) {
                sum += child.hashCode();
            }
            this.hashCode = sum ^ choiceCount;
        }

        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            int child = this.nextChildToUse();
            LoadBalancer.PickResult childResult = this.childPickers.get(child).pickSubchannel(args);
            if (!childResult.getStatus().isOk() || childResult.getSubchannel() == null) {
                return childResult;
            }
            if (childResult.getStreamTracerFactory() != null) {
                return childResult;
            }
            OutstandingRequestsTracingFactory factory = new OutstandingRequestsTracingFactory(this.childInFlights.get(child));
            return LoadBalancer.PickResult.withSubchannel((LoadBalancer.Subchannel)childResult.getSubchannel(), (ClientStreamTracer.Factory)factory);
        }

        public String toString() {
            return MoreObjects.toStringHelper(ReadyPicker.class).add("list", this.childPickers).add("choiceCount", this.choiceCount).toString();
        }

        private int nextChildToUse() {
            int candidate = this.random.nextInt(this.childPickers.size());
            for (int i = 0; i < this.choiceCount - 1; ++i) {
                int sampled = this.random.nextInt(this.childPickers.size());
                if (this.childInFlights.get(sampled).get() >= this.childInFlights.get(candidate).get()) continue;
                candidate = sampled;
            }
            return candidate;
        }

        @VisibleForTesting
        List<LoadBalancer.SubchannelPicker> getChildPickers() {
            return this.childPickers;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ReadyPicker)) {
                return false;
            }
            ReadyPicker other = (ReadyPicker)((Object)o);
            if (other == this) {
                return true;
            }
            return this.hashCode == other.hashCode && this.choiceCount == other.choiceCount && this.childPickers.size() == other.childPickers.size() && new HashSet<LoadBalancer.SubchannelPicker>(this.childPickers).containsAll(other.childPickers);
        }
    }
}

