/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.loadbalance.LoadManager;
import org.apache.pulsar.broker.loadbalance.ResourceUnit;
import org.apache.pulsar.broker.loadbalance.impl.PulsarResourceDescription;
import org.apache.pulsar.broker.loadbalance.impl.SimpleResourceUnit;
import org.apache.pulsar.common.naming.ServiceUnitId;
import org.apache.pulsar.common.stats.Metrics;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.coordination.LockManager;
import org.apache.pulsar.policies.data.loadbalancer.LoadManagerReport;
import org.apache.pulsar.policies.data.loadbalancer.LocalBrokerData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoopLoadManager
implements LoadManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NoopLoadManager.class);
    private PulsarService pulsar;
    private String brokerId;
    private ResourceUnit localResourceUnit;
    private LockManager<LocalBrokerData> lockManager;
    private Map<String, String> bundleBrokerAffinityMap;

    @Override
    public void initialize(PulsarService pulsar) {
        this.pulsar = pulsar;
        this.lockManager = pulsar.getCoordinationService().getLockManager(LocalBrokerData.class);
        this.bundleBrokerAffinityMap = new ConcurrentHashMap<String, String>();
    }

    @Override
    public void start() throws PulsarServerException {
        this.brokerId = this.pulsar.getBrokerId();
        this.localResourceUnit = new SimpleResourceUnit(this.brokerId, new PulsarResourceDescription());
        LocalBrokerData localData = new LocalBrokerData(this.pulsar.getWebServiceAddress(), this.pulsar.getWebServiceAddressTls(), this.pulsar.getBrokerServiceUrl(), this.pulsar.getBrokerServiceUrlTls(), this.pulsar.getAdvertisedListeners());
        localData.setProtocols(this.pulsar.getProtocolDataToAdvertise());
        localData.setLoadManagerClassName(this.pulsar.getConfig().getLoadManagerClassName());
        String brokerReportPath = "/loadbalance/brokers/" + this.brokerId;
        try {
            log.info("Acquiring broker resource lock on {}", (Object)brokerReportPath);
            this.lockManager.acquireLock(brokerReportPath, (Object)localData).join();
            log.info("Acquired broker resource lock on {}", (Object)brokerReportPath);
        }
        catch (CompletionException ce) {
            throw new PulsarServerException((Throwable)MetadataStoreException.unwrap((Throwable)ce));
        }
    }

    @Override
    public boolean isCentralized() {
        return false;
    }

    @Override
    public Optional<ResourceUnit> getLeastLoaded(ServiceUnitId su) throws Exception {
        return Optional.of(this.localResourceUnit);
    }

    @Override
    public LoadManagerReport generateLoadReport() throws Exception {
        return null;
    }

    @Override
    public void setLoadReportForceUpdateFlag() {
    }

    @Override
    public void writeLoadReportOnZookeeper() throws Exception {
    }

    @Override
    public void writeResourceQuotasToZooKeeper() throws Exception {
    }

    @Override
    public List<Metrics> getLoadBalancingMetrics() {
        return Collections.emptyList();
    }

    @Override
    public void doLoadShedding() {
    }

    @Override
    public void doNamespaceBundleSplit() throws Exception {
    }

    @Override
    public void disableBroker() throws Exception {
    }

    @Override
    public Set<String> getAvailableBrokers() throws Exception {
        return Collections.singleton(this.brokerId);
    }

    @Override
    public CompletableFuture<Set<String>> getAvailableBrokersAsync() {
        return CompletableFuture.completedFuture(Collections.singleton(this.brokerId));
    }

    @Override
    public void stop() throws PulsarServerException {
        if (this.lockManager != null) {
            try {
                this.lockManager.close();
            }
            catch (Exception e) {
                throw new PulsarServerException((Throwable)e);
            }
        }
    }

    @Override
    public String setNamespaceBundleAffinity(String bundle, String broker) {
        if (StringUtils.isBlank((CharSequence)broker)) {
            return this.bundleBrokerAffinityMap.remove(bundle);
        }
        return this.bundleBrokerAffinityMap.put(bundle, broker);
    }
}

