/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client.api;

import io.streamnative.oxia.client.api.OptionEphemeral;
import io.streamnative.oxia.client.api.OptionPartitionKey;
import io.streamnative.oxia.client.api.OptionSecondaryIndex;
import io.streamnative.oxia.client.api.OptionSequenceKeysDeltas;
import io.streamnative.oxia.client.api.OptionVersionId;
import java.util.List;
import lombok.NonNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface PutOption {
    public static final PutOption IfRecordDoesNotExist = new OptionVersionId.OptionRecordDoesNotExist();
    public static final PutOption AsEphemeralRecord = new OptionEphemeral();

    public static OptionVersionId.OptionVersionIdEqual IfVersionIdEquals(long versionId) {
        return new OptionVersionId.OptionVersionIdEqual(versionId);
    }

    public static PutOption PartitionKey(@NonNull String partitionKey) {
        if (partitionKey == null) {
            throw new NullPointerException("partitionKey is marked non-null but is null");
        }
        return new OptionPartitionKey(partitionKey);
    }

    public static PutOption SequenceKeysDeltas(@NonNull List<Long> sequenceKeysDeltas) {
        if (sequenceKeysDeltas == null) {
            throw new NullPointerException("sequenceKeysDeltas is marked non-null but is null");
        }
        return new OptionSequenceKeysDeltas(sequenceKeysDeltas);
    }

    public static PutOption SecondaryIndex(@NonNull String indexName, String secondaryKey) {
        if (indexName == null) {
            throw new NullPointerException("indexName is marked non-null but is null");
        }
        return new OptionSecondaryIndex(indexName, secondaryKey);
    }
}

