/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.namespace;

import io.netty.util.Recycler;
import lombok.Generated;
import org.apache.pulsar.common.policies.data.TopicType;

public class TopicExistsInfo {
    private static final Recycler<TopicExistsInfo> RECYCLER = new Recycler<TopicExistsInfo>(){

        protected TopicExistsInfo newObject(Recycler.Handle<TopicExistsInfo> handle) {
            return new TopicExistsInfo(handle);
        }
    };
    private static TopicExistsInfo nonPartitionedExists = new TopicExistsInfo(true, 0);
    private static TopicExistsInfo notExists = new TopicExistsInfo(false, 0);
    private final Recycler.Handle<TopicExistsInfo> handle;
    private int partitions;
    private boolean exists;

    public static TopicExistsInfo newPartitionedTopicExists(Integer partitions) {
        TopicExistsInfo info = (TopicExistsInfo)RECYCLER.get();
        info.exists = true;
        info.partitions = partitions;
        return info;
    }

    public static TopicExistsInfo newNonPartitionedTopicExists() {
        return nonPartitionedExists;
    }

    public static TopicExistsInfo newTopicNotExists() {
        return notExists;
    }

    private TopicExistsInfo(Recycler.Handle<TopicExistsInfo> handle) {
        this.handle = handle;
    }

    private TopicExistsInfo(boolean exists, int partitions) {
        this.handle = null;
        this.partitions = partitions;
        this.exists = exists;
    }

    public void recycle() {
        if (this == notExists || this == nonPartitionedExists || this.handle == null) {
            return;
        }
        this.exists = false;
        this.partitions = 0;
        this.handle.recycle((Object)this);
    }

    public TopicType getTopicType() {
        return this.partitions > 0 ? TopicType.PARTITIONED : TopicType.NON_PARTITIONED;
    }

    @Generated
    public int getPartitions() {
        return this.partitions;
    }

    @Generated
    public boolean isExists() {
        return this.exists;
    }
}

