/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.operator.AbstractRowChangeOperator;
import io.trino.operator.DriverContext;
import io.trino.operator.Operator;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorFactory;
import io.trino.spi.Page;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class UpdateOperator
extends AbstractRowChangeOperator {
    private final List<Integer> columnValueAndRowIdChannels;

    public UpdateOperator(OperatorContext operatorContext, List<Integer> columnValueAndRowIdChannels) {
        super(operatorContext);
        this.columnValueAndRowIdChannels = columnValueAndRowIdChannels;
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((this.state == AbstractRowChangeOperator.State.RUNNING ? 1 : 0) != 0, (String)"Operator is %s", (Object)((Object)this.state));
        this.pageSource().updateRows(page, this.columnValueAndRowIdChannels);
        this.rowCount += (long)page.getPositionCount();
    }

    public static class UpdateOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final List<Integer> columnValueAndRowIdChannels;
        private boolean closed;

        public UpdateOperatorFactory(int operatorId, PlanNodeId planNodeId, List<Integer> columnValueAndRowIdChannels) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.columnValueAndRowIdChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnValueAndRowIdChannels, "columnValueAndRowIdChannels is null"));
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext context = driverContext.addOperatorContext(this.operatorId, this.planNodeId, UpdateOperator.class.getSimpleName());
            return new UpdateOperator(context, this.columnValueAndRowIdChannels);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new UpdateOperatorFactory(this.operatorId, this.planNodeId, this.columnValueAndRowIdChannels);
        }
    }
}

