/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cli;

import com.google.common.collect.ImmutableList;
import io.trino.cli.TerminalUtils;
import io.trino.cli.WarningsPrinter;
import io.trino.client.Warning;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;

abstract class AbstractWarningsPrinter
implements WarningsPrinter {
    private final OptionalInt maxWarnings;
    private boolean hasProcessedWarnings;
    private int processedWarnings;

    AbstractWarningsPrinter(OptionalInt maxWarnings) {
        this.maxWarnings = Objects.requireNonNull(maxWarnings, "maxWarnings is null");
    }

    private String getWarningMessage(Warning warning) {
        if (TerminalUtils.isRealTerminal()) {
            return new AttributedStringBuilder().style(AttributedStyle.DEFAULT.foreground(3)).append((CharSequence)"WARNING: ").append((CharSequence)warning.getMessage()).style(AttributedStyle.DEFAULT).toAnsi();
        }
        return String.format("WARNING: %s", warning.getMessage());
    }

    private List<String> getNewWarnings(List<Warning> warnings) {
        int end = warnings.size();
        if (this.maxWarnings.isPresent()) {
            end = Math.min(this.processedWarnings + this.maxWarnings.getAsInt(), end);
        }
        List subList = (List)warnings.subList(this.processedWarnings, end).stream().map(this::getWarningMessage).collect(ImmutableList.toImmutableList());
        this.processedWarnings = end;
        return subList;
    }

    protected abstract void print(List<String> var1);

    protected abstract void printSeparator();

    private void printWithSeparators(List<String> warnings) {
        if (!warnings.isEmpty()) {
            this.printSeparator();
            this.print(warnings);
            this.printSeparator();
        }
    }

    private void printWithInitialSeparator(List<String> warnings) {
        if (!this.hasProcessedWarnings && !warnings.isEmpty()) {
            this.printSeparator();
            this.hasProcessedWarnings = true;
            this.print(warnings);
        }
    }

    private void printWithTrailingSeparator(List<String> warnings) {
        if (!warnings.isEmpty()) {
            this.print(warnings);
            this.printSeparator();
        }
    }

    @Override
    public void print(List<Warning> warnings, boolean withInitialSeparator, boolean withTrailingSeparator) {
        Objects.requireNonNull(warnings, "warnings is null");
        List<String> newWarnings = this.getNewWarnings(warnings);
        if (withInitialSeparator) {
            if (withTrailingSeparator) {
                this.printWithSeparators(newWarnings);
            } else {
                this.printWithInitialSeparator(newWarnings);
            }
        } else if (withTrailingSeparator) {
            this.printWithTrailingSeparator(newWarnings);
        } else {
            this.print(newWarnings);
        }
    }
}

