/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.portals.applications.webcontent2.rewriter;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

/**
 * Content source as input to <code>ContentRewriter</code>.
 */
public interface Source
{
    /**
     * Retrieves the content as binary data using a {@link InputStream}.
     * 
     * @return
     * @throws IOException
     */
    public InputStream getInputStream() throws IOException;

    /**
     * Retrieves the content as character data using a {@link Reader}. 
     * 
     * @return
     * @throws IOException
     */
    public Reader getReader() throws IOException;
}
