/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.portals.applications.webcontent.proxy.impl;

import java.net.InetAddress;
import java.util.Map;

import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.RouteInfo.LayerType;
import org.apache.http.conn.routing.RouteInfo.TunnelType;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.impl.conn.DefaultHttpRoutePlanner;
import org.apache.http.protocol.HttpContext;

/**
 * CustomHttpRoutePlanner
 * 
 * @version $Id: ProxyHttpRoutePlanner.java 884123 2009-11-25 14:53:03Z woonsan $
 */
public class ProxyHttpRoutePlanner extends DefaultHttpRoutePlanner
{
    
    private HttpHost [] defaultProxyHosts;
    private Map<HttpHost, HttpRoute> proxyRouteMap;
    
    public ProxyHttpRoutePlanner(SchemeRegistry schreg)
    {
        super(schreg);
    }
    
    public void setDefaultProxyHosts(HttpHost [] defaultProxyHosts)
    {
        this.defaultProxyHosts = defaultProxyHosts;
    }
    
    public void setProxyRouteMap(Map<HttpHost, HttpRoute> proxyRouteMap)
    {
        this.proxyRouteMap = proxyRouteMap;
    }
    
    public HttpRoute determineRoute(HttpHost target, HttpRequest request, HttpContext context) throws HttpException 
    {
        if (proxyRouteMap != null)
        {
            HttpRoute targetRoute = proxyRouteMap.get(target);
            
            if (targetRoute != null)
            {
                return targetRoute;
            }
        }
        
        HttpRoute route = super.determineRoute(target, request, context);
        
        if (defaultProxyHosts != null && defaultProxyHosts.length > 0)
        {
            HttpHost targetHost = route.getTargetHost();
            InetAddress local = route.getLocalAddress();
            boolean secure = route.isSecure();
            TunnelType tunnelType = route.getTunnelType();
            LayerType layerType = route.getLayerType();
            route = new HttpRoute(targetHost, local, defaultProxyHosts, secure, tunnelType, layerType);
        }
        
        return route;
    }
    
}
