/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.portals.applications.webcontent.proxy;

/**
 * The <CODE>HttpReverseProxyNotFoundException</CODE> class defines a not-found-exception
 * that an http reverse proxy component can throw when it is unable to find web resources
 * successfully.
 * 
 * @version $Id: HttpReverseProxyNotFoundException.java 821934 2009-10-05 17:50:07Z woonsan $
 */
public class HttpReverseProxyNotFoundException extends HttpReverseProxyException {

    private static final long serialVersionUID = 1L;

    /**
     * Constructs a new HttpReverseProxyNotFoundException exception.
     */
    public HttpReverseProxyNotFoundException() {
        super();
    }

    /**
     * Constructs a new HttpReverseProxyNotFoundException exception with the given message.
     *
     * @param   message
     *          the exception message
     */
    public HttpReverseProxyNotFoundException(String message) {
        super(message);
    }

    /**
     * Constructs a new HttpReverseProxyNotFoundException exception with the nested exception.
     *
     * @param   nested
     *          the nested exception
     */
    public HttpReverseProxyNotFoundException(Throwable nested) {
        super(nested);
    }

    /**
     * Constructs a new HttpReverseProxyNotFoundException exception when the container needs to do
     * the following:
     * <ul>
     * <li>throw an exception 
     * <li>include the "nested" exception
     * <li>include a description message
     * </ul>
     *
     * @param   msg
     *          the exception message
     * @param   nested
     *          the nested exception
     */
    public HttpReverseProxyNotFoundException(String msg, Throwable nested) {
        super(msg, nested);
    }
    
}
