/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class InterfaceOptions1 implements Message {

  // Properties.
  protected final boolean idmon;
  protected final boolean monitor;
  protected final boolean smart;
  protected final boolean srchk;
  protected final boolean xonXoff;
  protected final boolean connect;

  // Reserved Fields
  private Boolean reservedField0;
  private Boolean reservedField1;

  public InterfaceOptions1(
      boolean idmon,
      boolean monitor,
      boolean smart,
      boolean srchk,
      boolean xonXoff,
      boolean connect) {
    super();
    this.idmon = idmon;
    this.monitor = monitor;
    this.smart = smart;
    this.srchk = srchk;
    this.xonXoff = xonXoff;
    this.connect = connect;
  }

  public boolean getIdmon() {
    return idmon;
  }

  public boolean getMonitor() {
    return monitor;
  }

  public boolean getSmart() {
    return smart;
  }

  public boolean getSrchk() {
    return srchk;
  }

  public boolean getXonXoff() {
    return xonXoff;
  }

  public boolean getConnect() {
    return connect;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("InterfaceOptions1");

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField0 != null ? reservedField0 : (boolean) false,
        writeBoolean(writeBuffer));

    // Simple Field (idmon)
    writeSimpleField("idmon", idmon, writeBoolean(writeBuffer));

    // Simple Field (monitor)
    writeSimpleField("monitor", monitor, writeBoolean(writeBuffer));

    // Simple Field (smart)
    writeSimpleField("smart", smart, writeBoolean(writeBuffer));

    // Simple Field (srchk)
    writeSimpleField("srchk", srchk, writeBoolean(writeBuffer));

    // Simple Field (xonXoff)
    writeSimpleField("xonXoff", xonXoff, writeBoolean(writeBuffer));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField1 != null ? reservedField1 : (boolean) false,
        writeBoolean(writeBuffer));

    // Simple Field (connect)
    writeSimpleField("connect", connect, writeBoolean(writeBuffer));

    writeBuffer.popContext("InterfaceOptions1");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    InterfaceOptions1 _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Reserved Field (reserved)
    lengthInBits += 1;

    // Simple field (idmon)
    lengthInBits += 1;

    // Simple field (monitor)
    lengthInBits += 1;

    // Simple field (smart)
    lengthInBits += 1;

    // Simple field (srchk)
    lengthInBits += 1;

    // Simple field (xonXoff)
    lengthInBits += 1;

    // Reserved Field (reserved)
    lengthInBits += 1;

    // Simple field (connect)
    lengthInBits += 1;

    return lengthInBits;
  }

  public static InterfaceOptions1 staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("InterfaceOptions1");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    Boolean reservedField0 =
        readReservedField("reserved", readBoolean(readBuffer), (boolean) false);

    boolean idmon = readSimpleField("idmon", readBoolean(readBuffer));

    boolean monitor = readSimpleField("monitor", readBoolean(readBuffer));

    boolean smart = readSimpleField("smart", readBoolean(readBuffer));

    boolean srchk = readSimpleField("srchk", readBoolean(readBuffer));

    boolean xonXoff = readSimpleField("xonXoff", readBoolean(readBuffer));

    Boolean reservedField1 =
        readReservedField("reserved", readBoolean(readBuffer), (boolean) false);

    boolean connect = readSimpleField("connect", readBoolean(readBuffer));

    readBuffer.closeContext("InterfaceOptions1");
    // Create the instance
    InterfaceOptions1 _interfaceOptions1;
    _interfaceOptions1 = new InterfaceOptions1(idmon, monitor, smart, srchk, xonXoff, connect);
    _interfaceOptions1.reservedField0 = reservedField0;
    _interfaceOptions1.reservedField1 = reservedField1;
    return _interfaceOptions1;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof InterfaceOptions1)) {
      return false;
    }
    InterfaceOptions1 that = (InterfaceOptions1) o;
    return (getIdmon() == that.getIdmon())
        && (getMonitor() == that.getMonitor())
        && (getSmart() == that.getSmart())
        && (getSrchk() == that.getSrchk())
        && (getXonXoff() == that.getXonXoff())
        && (getConnect() == that.getConnect())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        getIdmon(), getMonitor(), getSmart(), getSrchk(), getXonXoff(), getConnect());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
