/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataAckedTransitions is the corresponding interface of BACnetConstructedDataAckedTransitions
type BACnetConstructedDataAckedTransitions interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetAckedTransitions returns AckedTransitions (property field)
	GetAckedTransitions() BACnetEventTransitionBitsTagged
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetEventTransitionBitsTagged
	// IsBACnetConstructedDataAckedTransitions is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataAckedTransitions()
	// CreateBuilder creates a BACnetConstructedDataAckedTransitionsBuilder
	CreateBACnetConstructedDataAckedTransitionsBuilder() BACnetConstructedDataAckedTransitionsBuilder
}

// _BACnetConstructedDataAckedTransitions is the data-structure of this message
type _BACnetConstructedDataAckedTransitions struct {
	BACnetConstructedDataContract
	AckedTransitions BACnetEventTransitionBitsTagged
}

var _ BACnetConstructedDataAckedTransitions = (*_BACnetConstructedDataAckedTransitions)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataAckedTransitions)(nil)

// NewBACnetConstructedDataAckedTransitions factory function for _BACnetConstructedDataAckedTransitions
func NewBACnetConstructedDataAckedTransitions(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, ackedTransitions BACnetEventTransitionBitsTagged, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataAckedTransitions {
	if ackedTransitions == nil {
		panic("ackedTransitions of type BACnetEventTransitionBitsTagged for BACnetConstructedDataAckedTransitions must not be nil")
	}
	_result := &_BACnetConstructedDataAckedTransitions{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		AckedTransitions:              ackedTransitions,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataAckedTransitionsBuilder is a builder for BACnetConstructedDataAckedTransitions
type BACnetConstructedDataAckedTransitionsBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(ackedTransitions BACnetEventTransitionBitsTagged) BACnetConstructedDataAckedTransitionsBuilder
	// WithAckedTransitions adds AckedTransitions (property field)
	WithAckedTransitions(BACnetEventTransitionBitsTagged) BACnetConstructedDataAckedTransitionsBuilder
	// WithAckedTransitionsBuilder adds AckedTransitions (property field) which is build by the builder
	WithAckedTransitionsBuilder(func(BACnetEventTransitionBitsTaggedBuilder) BACnetEventTransitionBitsTaggedBuilder) BACnetConstructedDataAckedTransitionsBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataAckedTransitions or returns an error if something is wrong
	Build() (BACnetConstructedDataAckedTransitions, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataAckedTransitions
}

// NewBACnetConstructedDataAckedTransitionsBuilder() creates a BACnetConstructedDataAckedTransitionsBuilder
func NewBACnetConstructedDataAckedTransitionsBuilder() BACnetConstructedDataAckedTransitionsBuilder {
	return &_BACnetConstructedDataAckedTransitionsBuilder{_BACnetConstructedDataAckedTransitions: new(_BACnetConstructedDataAckedTransitions)}
}

type _BACnetConstructedDataAckedTransitionsBuilder struct {
	*_BACnetConstructedDataAckedTransitions

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataAckedTransitionsBuilder) = (*_BACnetConstructedDataAckedTransitionsBuilder)(nil)

func (b *_BACnetConstructedDataAckedTransitionsBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataAckedTransitions
}

func (b *_BACnetConstructedDataAckedTransitionsBuilder) WithMandatoryFields(ackedTransitions BACnetEventTransitionBitsTagged) BACnetConstructedDataAckedTransitionsBuilder {
	return b.WithAckedTransitions(ackedTransitions)
}

func (b *_BACnetConstructedDataAckedTransitionsBuilder) WithAckedTransitions(ackedTransitions BACnetEventTransitionBitsTagged) BACnetConstructedDataAckedTransitionsBuilder {
	b.AckedTransitions = ackedTransitions
	return b
}

func (b *_BACnetConstructedDataAckedTransitionsBuilder) WithAckedTransitionsBuilder(builderSupplier func(BACnetEventTransitionBitsTaggedBuilder) BACnetEventTransitionBitsTaggedBuilder) BACnetConstructedDataAckedTransitionsBuilder {
	builder := builderSupplier(b.AckedTransitions.CreateBACnetEventTransitionBitsTaggedBuilder())
	var err error
	b.AckedTransitions, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetEventTransitionBitsTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataAckedTransitionsBuilder) Build() (BACnetConstructedDataAckedTransitions, error) {
	if b.AckedTransitions == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'ackedTransitions' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataAckedTransitions.deepCopy(), nil
}

func (b *_BACnetConstructedDataAckedTransitionsBuilder) MustBuild() BACnetConstructedDataAckedTransitions {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataAckedTransitionsBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataAckedTransitionsBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataAckedTransitionsBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataAckedTransitionsBuilder().(*_BACnetConstructedDataAckedTransitionsBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataAckedTransitionsBuilder creates a BACnetConstructedDataAckedTransitionsBuilder
func (b *_BACnetConstructedDataAckedTransitions) CreateBACnetConstructedDataAckedTransitionsBuilder() BACnetConstructedDataAckedTransitionsBuilder {
	if b == nil {
		return NewBACnetConstructedDataAckedTransitionsBuilder()
	}
	return &_BACnetConstructedDataAckedTransitionsBuilder{_BACnetConstructedDataAckedTransitions: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataAckedTransitions) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataAckedTransitions) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_ACKED_TRANSITIONS
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataAckedTransitions) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataAckedTransitions) GetAckedTransitions() BACnetEventTransitionBitsTagged {
	return m.AckedTransitions
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataAckedTransitions) GetActualValue() BACnetEventTransitionBitsTagged {
	ctx := context.Background()
	_ = ctx
	return CastBACnetEventTransitionBitsTagged(m.GetAckedTransitions())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataAckedTransitions(structType any) BACnetConstructedDataAckedTransitions {
	if casted, ok := structType.(BACnetConstructedDataAckedTransitions); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataAckedTransitions); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataAckedTransitions) GetTypeName() string {
	return "BACnetConstructedDataAckedTransitions"
}

func (m *_BACnetConstructedDataAckedTransitions) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (ackedTransitions)
	lengthInBits += m.AckedTransitions.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataAckedTransitions) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataAckedTransitions) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataAckedTransitions BACnetConstructedDataAckedTransitions, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataAckedTransitions"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataAckedTransitions")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	ackedTransitions, err := ReadSimpleField[BACnetEventTransitionBitsTagged](ctx, "ackedTransitions", ReadComplex[BACnetEventTransitionBitsTagged](BACnetEventTransitionBitsTaggedParseWithBufferProducer((uint8)(uint8(0)), (TagClass)(TagClass_APPLICATION_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'ackedTransitions' field"))
	}
	m.AckedTransitions = ackedTransitions

	actualValue, err := ReadVirtualField[BACnetEventTransitionBitsTagged](ctx, "actualValue", (*BACnetEventTransitionBitsTagged)(nil), ackedTransitions)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataAckedTransitions"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataAckedTransitions")
	}

	return m, nil
}

func (m *_BACnetConstructedDataAckedTransitions) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataAckedTransitions) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataAckedTransitions"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataAckedTransitions")
		}

		if err := WriteSimpleField[BACnetEventTransitionBitsTagged](ctx, "ackedTransitions", m.GetAckedTransitions(), WriteComplex[BACnetEventTransitionBitsTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'ackedTransitions' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataAckedTransitions"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataAckedTransitions")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataAckedTransitions) IsBACnetConstructedDataAckedTransitions() {}

func (m *_BACnetConstructedDataAckedTransitions) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataAckedTransitions) deepCopy() *_BACnetConstructedDataAckedTransitions {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataAckedTransitionsCopy := &_BACnetConstructedDataAckedTransitions{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetEventTransitionBitsTagged](m.AckedTransitions),
	}
	_BACnetConstructedDataAckedTransitionsCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataAckedTransitionsCopy
}

func (m *_BACnetConstructedDataAckedTransitions) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
