/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetConfirmedServiceRequestCreateObject extends BACnetConfirmedServiceRequest
    implements Message {

  // Accessors for discriminator values.
  public BACnetConfirmedServiceChoice getServiceChoice() {
    return BACnetConfirmedServiceChoice.CREATE_OBJECT;
  }

  // Properties.
  protected final BACnetConfirmedServiceRequestCreateObjectObjectSpecifier objectSpecifier;
  protected final BACnetPropertyValues listOfValues;

  // Arguments.
  protected final Long serviceRequestLength;

  public BACnetConfirmedServiceRequestCreateObject(
      BACnetConfirmedServiceRequestCreateObjectObjectSpecifier objectSpecifier,
      BACnetPropertyValues listOfValues,
      Long serviceRequestLength) {
    super(serviceRequestLength);
    this.objectSpecifier = objectSpecifier;
    this.listOfValues = listOfValues;
    this.serviceRequestLength = serviceRequestLength;
  }

  public BACnetConfirmedServiceRequestCreateObjectObjectSpecifier getObjectSpecifier() {
    return objectSpecifier;
  }

  public BACnetPropertyValues getListOfValues() {
    return listOfValues;
  }

  @Override
  protected void serializeBACnetConfirmedServiceRequestChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetConfirmedServiceRequestCreateObject");

    // Simple Field (objectSpecifier)
    writeSimpleField("objectSpecifier", objectSpecifier, writeComplex(writeBuffer));

    // Optional Field (listOfValues) (Can be skipped, if the value is null)
    writeOptionalField("listOfValues", listOfValues, writeComplex(writeBuffer));

    writeBuffer.popContext("BACnetConfirmedServiceRequestCreateObject");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    BACnetConfirmedServiceRequestCreateObject _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (objectSpecifier)
    lengthInBits += objectSpecifier.getLengthInBits();

    // Optional Field (listOfValues)
    if (listOfValues != null) {
      lengthInBits += listOfValues.getLengthInBits();
    }

    return lengthInBits;
  }

  public static BACnetConfirmedServiceRequestBuilder
      staticParseBACnetConfirmedServiceRequestBuilder(
          ReadBuffer readBuffer, Long serviceRequestLength) throws ParseException {
    readBuffer.pullContext("BACnetConfirmedServiceRequestCreateObject");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetConfirmedServiceRequestCreateObjectObjectSpecifier objectSpecifier =
        readSimpleField(
            "objectSpecifier",
            readComplex(
                () ->
                    BACnetConfirmedServiceRequestCreateObjectObjectSpecifier.staticParse(
                        readBuffer, (short) (0)),
                readBuffer));

    BACnetPropertyValues listOfValues =
        readOptionalField(
            "listOfValues",
            readComplex(
                () ->
                    BACnetPropertyValues.staticParse(
                        readBuffer,
                        (short) (1),
                        (BACnetObjectType)
                            (((objectSpecifier.getIsObjectType())
                                ? objectSpecifier.getObjectType()
                                : objectSpecifier.getObjectIdentifier().getObjectType()))),
                readBuffer));

    readBuffer.closeContext("BACnetConfirmedServiceRequestCreateObject");
    // Create the instance
    return new BACnetConfirmedServiceRequestCreateObjectBuilderImpl(
        objectSpecifier, listOfValues, serviceRequestLength);
  }

  public static class BACnetConfirmedServiceRequestCreateObjectBuilderImpl
      implements BACnetConfirmedServiceRequest.BACnetConfirmedServiceRequestBuilder {
    private final BACnetConfirmedServiceRequestCreateObjectObjectSpecifier objectSpecifier;
    private final BACnetPropertyValues listOfValues;
    private final Long serviceRequestLength;

    public BACnetConfirmedServiceRequestCreateObjectBuilderImpl(
        BACnetConfirmedServiceRequestCreateObjectObjectSpecifier objectSpecifier,
        BACnetPropertyValues listOfValues,
        Long serviceRequestLength) {
      this.objectSpecifier = objectSpecifier;
      this.listOfValues = listOfValues;
      this.serviceRequestLength = serviceRequestLength;
    }

    public BACnetConfirmedServiceRequestCreateObject build(Long serviceRequestLength) {

      BACnetConfirmedServiceRequestCreateObject bACnetConfirmedServiceRequestCreateObject =
          new BACnetConfirmedServiceRequestCreateObject(
              objectSpecifier, listOfValues, serviceRequestLength);
      return bACnetConfirmedServiceRequestCreateObject;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetConfirmedServiceRequestCreateObject)) {
      return false;
    }
    BACnetConfirmedServiceRequestCreateObject that = (BACnetConfirmedServiceRequestCreateObject) o;
    return (getObjectSpecifier() == that.getObjectSpecifier())
        && (getListOfValues() == that.getListOfValues())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getObjectSpecifier(), getListOfValues());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
