/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataDoorUnlockDelayTime is the corresponding interface of BACnetConstructedDataDoorUnlockDelayTime
type BACnetConstructedDataDoorUnlockDelayTime interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetDoorUnlockDelayTime returns DoorUnlockDelayTime (property field)
	GetDoorUnlockDelayTime() BACnetApplicationTagUnsignedInteger
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagUnsignedInteger
	// IsBACnetConstructedDataDoorUnlockDelayTime is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataDoorUnlockDelayTime()
	// CreateBuilder creates a BACnetConstructedDataDoorUnlockDelayTimeBuilder
	CreateBACnetConstructedDataDoorUnlockDelayTimeBuilder() BACnetConstructedDataDoorUnlockDelayTimeBuilder
}

// _BACnetConstructedDataDoorUnlockDelayTime is the data-structure of this message
type _BACnetConstructedDataDoorUnlockDelayTime struct {
	BACnetConstructedDataContract
	DoorUnlockDelayTime BACnetApplicationTagUnsignedInteger
}

var _ BACnetConstructedDataDoorUnlockDelayTime = (*_BACnetConstructedDataDoorUnlockDelayTime)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataDoorUnlockDelayTime)(nil)

// NewBACnetConstructedDataDoorUnlockDelayTime factory function for _BACnetConstructedDataDoorUnlockDelayTime
func NewBACnetConstructedDataDoorUnlockDelayTime(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, doorUnlockDelayTime BACnetApplicationTagUnsignedInteger, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataDoorUnlockDelayTime {
	if doorUnlockDelayTime == nil {
		panic("doorUnlockDelayTime of type BACnetApplicationTagUnsignedInteger for BACnetConstructedDataDoorUnlockDelayTime must not be nil")
	}
	_result := &_BACnetConstructedDataDoorUnlockDelayTime{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		DoorUnlockDelayTime:           doorUnlockDelayTime,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataDoorUnlockDelayTimeBuilder is a builder for BACnetConstructedDataDoorUnlockDelayTime
type BACnetConstructedDataDoorUnlockDelayTimeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(doorUnlockDelayTime BACnetApplicationTagUnsignedInteger) BACnetConstructedDataDoorUnlockDelayTimeBuilder
	// WithDoorUnlockDelayTime adds DoorUnlockDelayTime (property field)
	WithDoorUnlockDelayTime(BACnetApplicationTagUnsignedInteger) BACnetConstructedDataDoorUnlockDelayTimeBuilder
	// WithDoorUnlockDelayTimeBuilder adds DoorUnlockDelayTime (property field) which is build by the builder
	WithDoorUnlockDelayTimeBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataDoorUnlockDelayTimeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataDoorUnlockDelayTime or returns an error if something is wrong
	Build() (BACnetConstructedDataDoorUnlockDelayTime, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataDoorUnlockDelayTime
}

// NewBACnetConstructedDataDoorUnlockDelayTimeBuilder() creates a BACnetConstructedDataDoorUnlockDelayTimeBuilder
func NewBACnetConstructedDataDoorUnlockDelayTimeBuilder() BACnetConstructedDataDoorUnlockDelayTimeBuilder {
	return &_BACnetConstructedDataDoorUnlockDelayTimeBuilder{_BACnetConstructedDataDoorUnlockDelayTime: new(_BACnetConstructedDataDoorUnlockDelayTime)}
}

type _BACnetConstructedDataDoorUnlockDelayTimeBuilder struct {
	*_BACnetConstructedDataDoorUnlockDelayTime

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataDoorUnlockDelayTimeBuilder) = (*_BACnetConstructedDataDoorUnlockDelayTimeBuilder)(nil)

func (b *_BACnetConstructedDataDoorUnlockDelayTimeBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataDoorUnlockDelayTime
}

func (b *_BACnetConstructedDataDoorUnlockDelayTimeBuilder) WithMandatoryFields(doorUnlockDelayTime BACnetApplicationTagUnsignedInteger) BACnetConstructedDataDoorUnlockDelayTimeBuilder {
	return b.WithDoorUnlockDelayTime(doorUnlockDelayTime)
}

func (b *_BACnetConstructedDataDoorUnlockDelayTimeBuilder) WithDoorUnlockDelayTime(doorUnlockDelayTime BACnetApplicationTagUnsignedInteger) BACnetConstructedDataDoorUnlockDelayTimeBuilder {
	b.DoorUnlockDelayTime = doorUnlockDelayTime
	return b
}

func (b *_BACnetConstructedDataDoorUnlockDelayTimeBuilder) WithDoorUnlockDelayTimeBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataDoorUnlockDelayTimeBuilder {
	builder := builderSupplier(b.DoorUnlockDelayTime.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.DoorUnlockDelayTime, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataDoorUnlockDelayTimeBuilder) Build() (BACnetConstructedDataDoorUnlockDelayTime, error) {
	if b.DoorUnlockDelayTime == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'doorUnlockDelayTime' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataDoorUnlockDelayTime.deepCopy(), nil
}

func (b *_BACnetConstructedDataDoorUnlockDelayTimeBuilder) MustBuild() BACnetConstructedDataDoorUnlockDelayTime {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataDoorUnlockDelayTimeBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataDoorUnlockDelayTimeBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataDoorUnlockDelayTimeBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataDoorUnlockDelayTimeBuilder().(*_BACnetConstructedDataDoorUnlockDelayTimeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataDoorUnlockDelayTimeBuilder creates a BACnetConstructedDataDoorUnlockDelayTimeBuilder
func (b *_BACnetConstructedDataDoorUnlockDelayTime) CreateBACnetConstructedDataDoorUnlockDelayTimeBuilder() BACnetConstructedDataDoorUnlockDelayTimeBuilder {
	if b == nil {
		return NewBACnetConstructedDataDoorUnlockDelayTimeBuilder()
	}
	return &_BACnetConstructedDataDoorUnlockDelayTimeBuilder{_BACnetConstructedDataDoorUnlockDelayTime: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataDoorUnlockDelayTime) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataDoorUnlockDelayTime) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_DOOR_UNLOCK_DELAY_TIME
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataDoorUnlockDelayTime) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataDoorUnlockDelayTime) GetDoorUnlockDelayTime() BACnetApplicationTagUnsignedInteger {
	return m.DoorUnlockDelayTime
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataDoorUnlockDelayTime) GetActualValue() BACnetApplicationTagUnsignedInteger {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagUnsignedInteger(m.GetDoorUnlockDelayTime())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataDoorUnlockDelayTime(structType any) BACnetConstructedDataDoorUnlockDelayTime {
	if casted, ok := structType.(BACnetConstructedDataDoorUnlockDelayTime); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataDoorUnlockDelayTime); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataDoorUnlockDelayTime) GetTypeName() string {
	return "BACnetConstructedDataDoorUnlockDelayTime"
}

func (m *_BACnetConstructedDataDoorUnlockDelayTime) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (doorUnlockDelayTime)
	lengthInBits += m.DoorUnlockDelayTime.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataDoorUnlockDelayTime) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataDoorUnlockDelayTime) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataDoorUnlockDelayTime BACnetConstructedDataDoorUnlockDelayTime, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataDoorUnlockDelayTime"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataDoorUnlockDelayTime")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	doorUnlockDelayTime, err := ReadSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "doorUnlockDelayTime", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'doorUnlockDelayTime' field"))
	}
	m.DoorUnlockDelayTime = doorUnlockDelayTime

	actualValue, err := ReadVirtualField[BACnetApplicationTagUnsignedInteger](ctx, "actualValue", (*BACnetApplicationTagUnsignedInteger)(nil), doorUnlockDelayTime)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataDoorUnlockDelayTime"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataDoorUnlockDelayTime")
	}

	return m, nil
}

func (m *_BACnetConstructedDataDoorUnlockDelayTime) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataDoorUnlockDelayTime) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataDoorUnlockDelayTime"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataDoorUnlockDelayTime")
		}

		if err := WriteSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "doorUnlockDelayTime", m.GetDoorUnlockDelayTime(), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'doorUnlockDelayTime' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataDoorUnlockDelayTime"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataDoorUnlockDelayTime")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataDoorUnlockDelayTime) IsBACnetConstructedDataDoorUnlockDelayTime() {}

func (m *_BACnetConstructedDataDoorUnlockDelayTime) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataDoorUnlockDelayTime) deepCopy() *_BACnetConstructedDataDoorUnlockDelayTime {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataDoorUnlockDelayTimeCopy := &_BACnetConstructedDataDoorUnlockDelayTime{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.DoorUnlockDelayTime),
	}
	_BACnetConstructedDataDoorUnlockDelayTimeCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataDoorUnlockDelayTimeCopy
}

func (m *_BACnetConstructedDataDoorUnlockDelayTime) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
