/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.IOException;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.params.BasicFormatParams;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;

public abstract class AbstractSampleStreamFactory<T, P>
implements ObjectStreamFactory<T, P> {
    protected Class<P> params;

    private AbstractSampleStreamFactory() {
    }

    protected AbstractSampleStreamFactory(Class<P> params) {
        this.params = params;
    }

    public String getLang() {
        return "eng";
    }

    @Override
    public Class<P> getParameters() {
        return this.params;
    }

    protected <P extends BasicFormatParams> ObjectStream<String> readData(String[] args, Class<P> parametersClass) {
        P params = this.validateBasicFormatParameters(args, parametersClass);
        PlainTextByLineStream lineStream = null;
        try {
            InputStreamFactory sampleDataIn = CmdLineUtil.createInputStreamFactory(params.getData());
            lineStream = new PlainTextByLineStream(sampleDataIn, params.getEncoding());
        }
        catch (IOException ex) {
            CmdLineUtil.handleCreateObjectStreamError(ex);
        }
        return lineStream;
    }

    protected <P extends BasicFormatParams> P validateBasicFormatParameters(String[] args, Class<P> clazz) {
        if (args == null) {
            throw new IllegalArgumentException("Passed args must not be null!");
        }
        BasicFormatParams params = (BasicFormatParams)ArgumentParser.parse(args, clazz);
        CmdLineUtil.checkInputFile("Data", params.getData());
        return (P)params;
    }
}

