/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.doccat;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import opennlp.tools.doccat.BagOfWordsFeatureGenerator;
import opennlp.tools.doccat.FeatureGenerator;
import opennlp.tools.util.BaseToolFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.ext.ExtensionLoader;

public class DoccatFactory
extends BaseToolFactory {
    private static final String FEATURE_GENERATORS = "doccat.featureGenerators";
    private FeatureGenerator[] featureGenerators;

    public DoccatFactory() {
    }

    public DoccatFactory(FeatureGenerator[] featureGenerators) {
        this.init(featureGenerators);
    }

    protected void init(FeatureGenerator[] featureGenerators) {
        this.featureGenerators = featureGenerators;
    }

    @Override
    public Map<String, String> createManifestEntries() {
        Map<String, String> manifestEntries = super.createManifestEntries();
        if (this.getFeatureGenerators() != null) {
            manifestEntries.put(FEATURE_GENERATORS, this.featureGeneratorsAsString());
        }
        return manifestEntries;
    }

    private String featureGeneratorsAsString() {
        List<FeatureGenerator> fgs = Arrays.asList(this.getFeatureGenerators());
        Iterator<FeatureGenerator> iter = fgs.iterator();
        StringBuilder sb = new StringBuilder();
        if (iter.hasNext()) {
            sb.append(iter.next().getClass().getCanonicalName());
            while (iter.hasNext()) {
                sb.append(',').append(iter.next().getClass().getCanonicalName());
            }
        }
        return sb.toString();
    }

    @Override
    public void validateArtifactMap() throws InvalidFormatException {
    }

    public static DoccatFactory create(String subclassName, FeatureGenerator[] featureGenerators) throws InvalidFormatException {
        if (subclassName == null) {
            return new DoccatFactory(featureGenerators);
        }
        try {
            DoccatFactory theFactory = ExtensionLoader.instantiateExtension(DoccatFactory.class, subclassName);
            theFactory.init(featureGenerators);
            return theFactory;
        }
        catch (Exception e) {
            String msg = "Could not instantiate the " + subclassName + ". The initialization threw an exception.";
            throw new InvalidFormatException(msg, e);
        }
    }

    private FeatureGenerator[] loadFeatureGenerators(String classNames) {
        String[] classes = classNames.split(",");
        FeatureGenerator[] fgs = new FeatureGenerator[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            fgs[i] = ExtensionLoader.instantiateExtension(FeatureGenerator.class, classes[i]);
        }
        return fgs;
    }

    public FeatureGenerator[] getFeatureGenerators() {
        if (this.featureGenerators == null) {
            String classNames;
            if (this.artifactProvider != null && (classNames = this.artifactProvider.getManifestProperty(FEATURE_GENERATORS)) != null) {
                this.featureGenerators = this.loadFeatureGenerators(classNames);
            }
            if (this.featureGenerators == null) {
                this.featureGenerators = new FeatureGenerator[]{new BagOfWordsFeatureGenerator()};
            }
        }
        return this.featureGenerators;
    }

    public void setFeatureGenerators(FeatureGenerator[] featureGenerators) {
        this.featureGenerators = featureGenerators;
    }
}

