/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.access;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.StringResult;
import org.apache.nifi.toolkit.client.NiFiClient;
import org.apache.nifi.toolkit.client.NiFiClientException;

public class GetAccessToken
extends AbstractNiFiCommand<StringResult> {
    public GetAccessToken() {
        super("get-access-token", StringResult.class);
    }

    @Override
    public String getDescription() {
        return "Authenticates to NiFi with the given username and password and returns an access token for use on future requests as the value of the " + CommandOption.BEARER_TOKEN.getLongName() + " argument";
    }

    @Override
    public void doInitialize(Context context) {
        this.addOption(CommandOption.USERNAME.createOption());
        this.addOption(CommandOption.PASSWORD.createOption());
    }

    @Override
    public StringResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String username = this.getRequiredArg(properties, CommandOption.USERNAME);
        String password = this.getRequiredArg(properties, CommandOption.PASSWORD);
        String token = client.getAccessClient().getToken(username, password);
        return new StringResult(token, this.getContext().isInteractive());
    }
}

