/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.completion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.Modifier;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.type.ArrayType;
import jpt30.lang.model.type.DeclaredType;
import jpt30.lang.model.type.ErrorType;
import jpt30.lang.model.type.TypeKind;
import jpt30.lang.model.type.TypeMirror;
import jpt30.lang.model.type.WildcardType;
import jpt30.lang.model.util.Elements;
import jpt30.lang.model.util.Types;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.CodeStyleUtils;
import org.openide.util.WeakListeners;

public final class Utilities {
    private static final String EMPTY = "";
    private static final String ERROR = "<error>";
    private static final String COMPLETION_CASE_SENSITIVE = "completion-case-sensitive";
    private static final boolean COMPLETION_CASE_SENSITIVE_DEFAULT = true;
    private static final String SHOW_DEPRECATED_MEMBERS = "show-deprecated-members";
    private static final boolean SHOW_DEPRECATED_MEMBERS_DEFAULT = true;
    private static final String JAVA_COMPLETION_WHITELIST = "javaCompletionWhitelist";
    private static final String JAVA_COMPLETION_BLACKLIST = "javaCompletionBlacklist";
    private static final String JAVA_COMPLETION_BLACKLIST_DEFAULT = "";
    private static final String JAVA_COMPLETION_EXCLUDER_METHODS = "javaCompletionExcluderMethods";
    private static final boolean JAVA_COMPLETION_EXCLUDER_METHODS_DEFAULT = false;
    private static final String JAVA_COMPLETION_SUBWORDS = "javaCompletionSubwords";
    private static final boolean JAVA_COMPLETION_SUBWORDS_DEFAULT = false;
    private static boolean caseSensitive = true;
    private static boolean showDeprecatedMembers = true;
    private static boolean javaCompletionExcluderMethods = false;
    private static boolean javaCompletionSubwords = false;
    private static final AtomicBoolean inited = new AtomicBoolean(false);
    private static Preferences preferences;
    private static final PreferenceChangeListener preferencesTracker;
    private static String cachedPrefix;
    private static Pattern cachedCamelCasePattern;
    private static Pattern cachedSubwordsPattern;
    private static final AtomicReference<Collection<String>> excludeRef;
    private static final AtomicReference<Collection<String>> includeRef;

    public static boolean startsWith(String theString, String prefix) {
        if (theString == null || theString.length() == 0 || ERROR.equals(theString)) {
            return false;
        }
        if (prefix == null || prefix.length() == 0) {
            return true;
        }
        if (javaCompletionSubwords) {
            if (!prefix.equals(cachedPrefix)) {
                cachedCamelCasePattern = null;
                cachedSubwordsPattern = null;
            }
            if (cachedSubwordsPattern == null) {
                cachedPrefix = prefix;
                String patternString = Utilities.createSubwordsPattern(prefix);
                Pattern pattern = cachedSubwordsPattern = patternString != null ? Pattern.compile(patternString) : null;
            }
            if (cachedSubwordsPattern != null && cachedSubwordsPattern.matcher(theString).matches()) {
                return true;
            }
        }
        return Utilities.isCaseSensitive() ? theString.startsWith(prefix) : theString.toLowerCase(Locale.ENGLISH).startsWith(prefix.toLowerCase(Locale.ENGLISH));
    }

    static String createSubwordsPattern(String prefix) {
        StringBuilder sb = new StringBuilder(3 + 8 * prefix.length());
        sb.append(".*?");
        for (int i = 0; i < prefix.length(); ++i) {
            char charAt = prefix.charAt(i);
            if (!Character.isJavaIdentifierPart(charAt)) {
                return null;
            }
            if (Character.isLowerCase(charAt)) {
                sb.append("[");
                sb.append(charAt);
                sb.append(Character.toUpperCase(charAt));
                sb.append("]");
            } else {
                sb.append(charAt);
            }
            sb.append(".*?");
        }
        return sb.toString();
    }

    public static boolean startsWithCamelCase(String theString, String prefix) {
        if (theString == null || theString.length() == 0 || prefix == null || prefix.length() == 0) {
            return false;
        }
        if (!prefix.equals(cachedPrefix)) {
            cachedCamelCasePattern = null;
            cachedSubwordsPattern = null;
        }
        if (cachedCamelCasePattern == null) {
            int index;
            StringBuilder sb = new StringBuilder();
            int lastIndex = 0;
            do {
                String token = prefix.substring(lastIndex, (index = Utilities.findNextUpper(prefix, lastIndex + 1)) == -1 ? prefix.length() : index);
                sb.append(token);
                sb.append(index != -1 ? "[\\p{javaLowerCase}\\p{Digit}_\\$]*" : ".*");
                lastIndex = index;
            } while (index != -1);
            cachedPrefix = prefix;
            cachedCamelCasePattern = Pattern.compile(sb.toString());
        }
        return cachedCamelCasePattern.matcher(theString).matches();
    }

    private static int findNextUpper(String text, int offset) {
        for (int i = offset; i < text.length(); ++i) {
            if (!Character.isUpperCase(text.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static boolean isCaseSensitive() {
        Utilities.lazyInit();
        return caseSensitive;
    }

    public static boolean isSubwordSensitive() {
        Utilities.lazyInit();
        return javaCompletionSubwords;
    }

    public static boolean isShowDeprecatedMembers() {
        Utilities.lazyInit();
        return showDeprecatedMembers;
    }

    private static void updateExcluder(AtomicReference<Collection<String>> existing, String updated) {
        String[] entries;
        LinkedList<String> nue = new LinkedList<String>();
        if (updated == null || updated.length() == 0) {
            existing.set(nue);
            return;
        }
        for (String entry : entries = updated.split(",")) {
            if (entry.length() == 0) continue;
            nue.add(entry);
        }
        existing.set(nue);
    }

    public static boolean isExcludeMethods() {
        Utilities.lazyInit();
        return javaCompletionExcluderMethods;
    }

    public static boolean isExcluded(CharSequence fqn) {
        if (fqn == null || fqn.length() == 0) {
            return true;
        }
        Utilities.lazyInit();
        String s = fqn.toString();
        Collection<String> include = includeRef.get();
        Collection<String> exclude = excludeRef.get();
        if (include != null && !include.isEmpty()) {
            for (String entry : include) {
                if (s.endsWith(".") && entry.startsWith(s)) {
                    return false;
                }
                if ((!entry.endsWith("*") || entry.length() - 1 > s.length() || !s.startsWith(entry.substring(0, entry.length() - 1))) && !s.equals(entry)) continue;
                return false;
            }
        }
        if (exclude != null && !exclude.isEmpty()) {
            for (String entry : exclude) {
                if ((!entry.endsWith("*") || entry.length() - 1 > s.length() || !s.startsWith(entry.substring(0, entry.length() - 1))) && !s.equals(entry)) continue;
                return true;
            }
        }
        return false;
    }

    public static void exclude(CharSequence fqn) {
        if (fqn != null && fqn.length() > 0) {
            Utilities.lazyInit();
            Object blacklist = preferences.get(JAVA_COMPLETION_BLACKLIST, "");
            blacklist = (String)blacklist + (CharSequence)(((String)blacklist).length() > 0 ? "," + fqn : fqn);
            preferences.put(JAVA_COMPLETION_BLACKLIST, (String)blacklist);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> varNamesSuggestions(TypeMirror type, ElementKind kind, Set<Modifier> modifiers, String suggestedName, String prefix, Types types, Elements elements, Iterable<? extends Element> locals, CodeStyle codeStyle) {
        ArrayList<String> result = new ArrayList<String>();
        if (type == null && suggestedName == null) {
            return result;
        }
        List<String> vnct = suggestedName != null ? Collections.singletonList(suggestedName) : Utilities.varNamesForType(type, types, elements, prefix);
        boolean isConst = false;
        String namePrefix = null;
        String nameSuffix = null;
        switch (kind) {
            case FIELD: {
                if (modifiers.contains((Object)Modifier.STATIC)) {
                    if (codeStyle != null) {
                        namePrefix = codeStyle.getStaticFieldNamePrefix();
                        nameSuffix = codeStyle.getStaticFieldNameSuffix();
                    }
                    isConst = modifiers.contains((Object)Modifier.FINAL);
                    break;
                }
                if (codeStyle == null) break;
                namePrefix = codeStyle.getFieldNamePrefix();
                nameSuffix = codeStyle.getFieldNameSuffix();
                break;
            }
            case LOCAL_VARIABLE: 
            case EXCEPTION_PARAMETER: 
            case RESOURCE_VARIABLE: {
                if (codeStyle == null) break;
                namePrefix = codeStyle.getLocalVarNamePrefix();
                nameSuffix = codeStyle.getLocalVarNameSuffix();
                break;
            }
            case PARAMETER: {
                if (codeStyle == null) break;
                namePrefix = codeStyle.getParameterNamePrefix();
                nameSuffix = codeStyle.getParameterNameSuffix();
            }
        }
        if (isConst) {
            ArrayList<String> ls = new ArrayList<String>(vnct.size());
            for (String string : vnct) {
                ls.add(Utilities.getConstName(string));
            }
            vnct = ls;
        }
        if (vnct.isEmpty() && prefix != null && prefix.length() > 0 && (namePrefix != null && namePrefix.length() > 0 || nameSuffix != null && nameSuffix.length() > 0)) {
            vnct = Collections.singletonList(prefix);
        }
        String p = prefix;
        while (p != null && p.length() > 0) {
            ArrayList<String> l = new ArrayList<String>();
            for (String name : vnct) {
                if (!Utilities.startsWith(name, p)) continue;
                l.add(name);
            }
            if (l.isEmpty()) {
                p = Utilities.nextName(p);
                continue;
            }
            vnct = l;
            prefix = prefix.substring(0, prefix.length() - p.length());
            p = null;
        }
        for (String string : vnct) {
            void var16_25;
            void var16_23;
            boolean isPrimitive;
            boolean bl = isPrimitive = type != null && type.getKind().isPrimitive();
            if (prefix != null && prefix.length() > 0) {
                if (isConst) {
                    String string2 = prefix.toUpperCase(Locale.ENGLISH) + "_" + string;
                } else {
                    String string3 = prefix + string.toUpperCase(Locale.ENGLISH).charAt(0) + string.substring(1);
                }
            }
            int cnt = 1;
            void baseName = var16_23;
            String string4 = CodeStyleUtils.addPrefixSuffix((CharSequence)var16_23, namePrefix, nameSuffix);
            while (Utilities.isClashing((String)var16_25, type, locals)) {
                if (isPrimitive) {
                    char c = var16_25.charAt(namePrefix != null ? namePrefix.length() : 0);
                    c = (char)(c + '\u0001');
                    String string5 = CodeStyleUtils.addPrefixSuffix(Character.toString(c), namePrefix, nameSuffix);
                    if (c != 'z' && c != 'Z') continue;
                    isPrimitive = false;
                    continue;
                }
                String string6 = CodeStyleUtils.addPrefixSuffix((String)baseName + cnt++, namePrefix, nameSuffix);
            }
            result.add((String)var16_25);
        }
        return result;
    }

    private static List<String> varNamesForType(TypeMirror type, Types types, Elements elements, String prefix) {
        switch (type.getKind()) {
            case ARRAY: {
                TypeElement iterableTE = elements.getTypeElement("java.lang.Iterable");
                DeclaredType iterable = iterableTE != null ? types.getDeclaredType(iterableTE, new TypeMirror[0]) : null;
                TypeMirror ct = ((ArrayType)type).getComponentType();
                if (ct.getKind() == TypeKind.ARRAY && iterable != null && types.isSubtype(ct, iterable)) {
                    return Utilities.varNamesForType(ct, types, elements, prefix);
                }
                ArrayList<String> vnct = new ArrayList<String>();
                for (String name : Utilities.varNamesForType(ct, types, elements, prefix)) {
                    vnct.add(name.endsWith("s") ? name + "es" : name + "s");
                }
                return vnct;
            }
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case SHORT: {
                String str = type.toString().substring(0, 1);
                return prefix != null && !prefix.equals(str) ? Collections.emptyList() : Collections.singletonList(str);
            }
            case TYPEVAR: {
                return Collections.singletonList(type.toString().toLowerCase(Locale.ENGLISH));
            }
            case ERROR: {
                String tn = ((ErrorType)type).asElement().getSimpleName().toString();
                if (tn.toUpperCase(Locale.ENGLISH).contentEquals(tn)) {
                    return Collections.singletonList(tn.toLowerCase(Locale.ENGLISH));
                }
                StringBuilder sb = new StringBuilder();
                ArrayList<String> al = new ArrayList<String>();
                if ("Iterator".equals(tn)) {
                    al.add("it");
                }
                while ((tn = Utilities.nextName(tn)).length() > 0) {
                    al.add(tn);
                    sb.append(tn.charAt(0));
                }
                if (sb.length() > 0) {
                    String s = sb.toString();
                    if (prefix == null || prefix.length() == 0 || s.startsWith(prefix)) {
                        al.add(s);
                    }
                }
                return al;
            }
            case DECLARED: {
                List<? extends TypeMirror> tas;
                TypeElement iterableTE = elements.getTypeElement("java.lang.Iterable");
                DeclaredType iterable = iterableTE != null ? types.getDeclaredType(iterableTE, new TypeMirror[0]) : null;
                String tn = ((DeclaredType)type).asElement().getSimpleName().toString();
                if (tn.toUpperCase(Locale.ENGLISH).contentEquals(tn)) {
                    return Collections.singletonList(tn.toLowerCase(Locale.ENGLISH));
                }
                StringBuilder sb = new StringBuilder();
                ArrayList<String> al = new ArrayList<String>();
                if ("Iterator".equals(tn)) {
                    al.add("it");
                }
                while ((tn = Utilities.nextName(tn)).length() > 0) {
                    al.add(tn);
                    sb.append(tn.charAt(0));
                }
                if (iterable != null && types.isSubtype(type, iterable) && (tas = ((DeclaredType)type).getTypeArguments()).size() > 0) {
                    TypeMirror et = tas.get(0);
                    if (et.getKind() == TypeKind.ARRAY || et.getKind() != TypeKind.WILDCARD && types.isSubtype(et, iterable)) {
                        al.addAll(Utilities.varNamesForType(et, types, elements, prefix));
                    } else {
                        for (String name : Utilities.varNamesForType(et, types, elements, prefix)) {
                            al.add(name.endsWith("s") ? name + "es" : name + "s");
                        }
                    }
                }
                if (sb.length() > 0) {
                    String s = sb.toString();
                    if (prefix == null || prefix.length() == 0 || s.startsWith(prefix)) {
                        al.add(s);
                    }
                }
                return al;
            }
            case WILDCARD: {
                TypeMirror bound = ((WildcardType)type).getExtendsBound();
                if (bound == null) {
                    bound = ((WildcardType)type).getSuperBound();
                }
                if (bound == null) break;
                return Utilities.varNamesForType(bound, types, elements, prefix);
            }
        }
        return Collections.emptyList();
    }

    private static String getConstName(String s) {
        StringBuilder sb = new StringBuilder();
        boolean prevUpper = true;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isUpperCase(c)) {
                if (!prevUpper) {
                    sb.append('_');
                }
                sb.append(c);
                prevUpper = true;
                continue;
            }
            sb.append(Character.toUpperCase(c));
            prevUpper = false;
        }
        return sb.toString();
    }

    private static String nextName(CharSequence name) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (!Character.isUpperCase(c)) continue;
            char lc = Character.toLowerCase(c);
            sb.append(lc);
            sb.append(name.subSequence(i + 1, name.length()));
            break;
        }
        return sb.toString();
    }

    private static boolean isClashing(String varName, TypeMirror type, Iterable<? extends Element> locals) {
        try {
            if (JavaTokenId.valueOf(varName).primaryCategory().startsWith("keyword")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (type != null && type.getKind() == TypeKind.DECLARED && ((DeclaredType)type).asElement().getSimpleName().contentEquals(varName)) {
            return true;
        }
        for (Element element : locals) {
            if (!element.getKind().isField() && element.getKind() != ElementKind.LOCAL_VARIABLE && element.getKind() != ElementKind.RESOURCE_VARIABLE && element.getKind() != ElementKind.PARAMETER && element.getKind() != ElementKind.EXCEPTION_PARAMETER || !varName.contentEquals(element.getSimpleName())) continue;
            return true;
        }
        return false;
    }

    private static void lazyInit() {
        if (inited.compareAndSet(false, true)) {
            preferences = MimeLookup.getLookup(JavaTokenId.language().mimeType()).lookup(Preferences.class);
            preferences.addPreferenceChangeListener(WeakListeners.create(PreferenceChangeListener.class, preferencesTracker, preferences));
            preferencesTracker.preferenceChange(null);
        }
    }

    private Utilities() {
    }

    static {
        preferencesTracker = new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                String settingName;
                String string = settingName = evt == null ? null : evt.getKey();
                if (settingName == null || Utilities.COMPLETION_CASE_SENSITIVE.equals(settingName)) {
                    caseSensitive = preferences.getBoolean(Utilities.COMPLETION_CASE_SENSITIVE, true);
                }
                if (settingName == null || Utilities.SHOW_DEPRECATED_MEMBERS.equals(settingName)) {
                    showDeprecatedMembers = preferences.getBoolean(Utilities.SHOW_DEPRECATED_MEMBERS, true);
                }
                if (settingName == null || Utilities.JAVA_COMPLETION_BLACKLIST.equals(settingName)) {
                    String blacklist = preferences.get(Utilities.JAVA_COMPLETION_BLACKLIST, "");
                    Utilities.updateExcluder(excludeRef, blacklist);
                }
                if (settingName == null || Utilities.JAVA_COMPLETION_WHITELIST.equals(settingName)) {
                    String whitelist = preferences.get(Utilities.JAVA_COMPLETION_WHITELIST, "");
                    Utilities.updateExcluder(includeRef, whitelist);
                }
                if (settingName == null || Utilities.JAVA_COMPLETION_EXCLUDER_METHODS.equals(settingName)) {
                    javaCompletionExcluderMethods = preferences.getBoolean(Utilities.JAVA_COMPLETION_EXCLUDER_METHODS, false);
                }
                if (settingName == null || Utilities.JAVA_COMPLETION_SUBWORDS.equals(settingName)) {
                    javaCompletionSubwords = preferences.getBoolean(Utilities.JAVA_COMPLETION_SUBWORDS, false);
                }
            }
        };
        cachedPrefix = null;
        cachedCamelCasePattern = null;
        cachedSubwordsPattern = null;
        excludeRef = new AtomicReference();
        includeRef = new AtomicReference();
    }
}

