/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.metadata.model.api.support.annotation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import jpt30.lang.model.element.TypeElement;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.JavaContextListener;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.ObjectProvider;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.PersistentObject;
import org.netbeans.modules.j2ee.metadata.model.support.PersistentObjectList;
import org.openide.util.ChangeSupport;
import org.openide.util.RequestProcessor;

public class PersistentObjectManager<T extends PersistentObject>
implements JavaContextListener {
    private static final Logger LOGGER = Logger.getLogger(PersistentObjectManager.class.getName());
    private static final boolean NO_EVENTS = Boolean.getBoolean("netbeans.metadata.model.noevents");
    private final AnnotationModelHelper helper;
    private final ObjectProvider<T> provider;
    private final PersistentObjectList<T> objectList = new PersistentObjectList();
    private final ChangeSupport changeSupport = new ChangeSupport(this);
    private final RequestProcessor rp = new RequestProcessor("PersistentObjectManager", 1);
    boolean initialized = false;
    boolean temporary = false;

    static <V extends PersistentObject> PersistentObjectManager<V> create(AnnotationModelHelper helper, ObjectProvider<V> provider) {
        PersistentObjectManager<V> pom = new PersistentObjectManager<V>(helper, provider);
        if (NO_EVENTS) {
            LOGGER.log(Level.FINE, "ignoring events");
        }
        helper.addJavaContextListener(pom);
        return pom;
    }

    private PersistentObjectManager(AnnotationModelHelper helper, ObjectProvider<T> provider) {
        this.helper = helper;
        this.provider = provider;
    }

    public Collection<T> getObjects() {
        this.ensureInitialized();
        List<T> result = this.objectList.get();
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "getObjects returning {0} objects: {1}", new Object[]{result.size(), result});
        } else {
            LOGGER.log(Level.FINE, "getObjects returning {0} objects", result.size());
        }
        return result;
    }

    private void ensureInitialized() {
        if (!this.initialized) {
            List<T> objects;
            boolean scanInProgress = SourceUtils.isScanInProgress();
            this.temporary = NO_EVENTS | scanInProgress;
            if (this.temporary) {
                LOGGER.log(Level.FINE, "initalizing temporarily (scanInProgress: {0})", scanInProgress);
            } else {
                LOGGER.log(Level.FINE, "intializing");
            }
            try {
                objects = this.provider.createInitialObjects();
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.FINE, "initializing temporarily (createInitialObjects() throwed InterruptedException)");
                this.temporary = true;
                objects = Collections.emptyList();
            }
            LOGGER.log(Level.FINE, "created initial objects {0}", objects);
            this.objectList.add(objects);
            this.initialized = true;
        }
    }

    private void deinitialize() {
        this.initialized = false;
        this.objectList.clear();
    }

    void typesAdded(Iterable<? extends ElementHandle<TypeElement>> typeHandles) {
        LOGGER.log(Level.FINE, "typesAdded: called with {0}", typeHandles);
        if (!this.initialized) {
            LOGGER.log(Level.FINE, "typesAdded: not initialized, firing change event");
            this.fireChange();
            return;
        }
        for (ElementHandle<TypeElement> elementHandle : typeHandles) {
            TypeElement type = elementHandle.resolve(this.helper.getCompilationController());
            if (type == null) {
                LOGGER.log(Level.WARNING, "typesAdded: type {0} has dissapeared", elementHandle);
                continue;
            }
            List<T> newObjects = this.provider.createObjects(type);
            LOGGER.log(Level.FINE, "typesAdded: new objects {0}", newObjects);
            if (!this.objectList.put(elementHandle, newObjects)) continue;
            this.fireChange();
        }
    }

    void typesRemoved(Iterable<? extends ElementHandle<TypeElement>> typeHandles) {
        LOGGER.log(Level.FINE, "typesRemoved: called with {0}", typeHandles);
        if (!this.initialized) {
            LOGGER.log(Level.FINE, "typesRemoved: not initialized, firing change event");
            this.fireChange();
            return;
        }
        for (ElementHandle<TypeElement> elementHandle : typeHandles) {
            List<T> list = this.objectList.remove(elementHandle);
            if (list == null) continue;
            LOGGER.log(Level.FINE, "typesRemoved: removing objects {0}", list);
            this.fireChange();
        }
    }

    void typesChanged(Iterable<? extends ElementHandle<TypeElement>> typeHandles) {
        LOGGER.log(Level.FINE, "typesChanged: called with {0}", typeHandles);
        if (!this.initialized) {
            LOGGER.log(Level.FINE, "typesChanged: not initialized, firing change event");
            this.fireChange();
            return;
        }
        for (ElementHandle<TypeElement> elementHandle : typeHandles) {
            TypeElement type;
            List<T> list = this.objectList.get(elementHandle);
            if (list != null) {
                type = elementHandle.resolve(this.helper.getCompilationController());
                if (type == null) {
                    LOGGER.log(Level.WARNING, "typesChanged: type {0} has dissapeared", elementHandle);
                    continue;
                }
                ArrayList<T> oldNewObjects = new ArrayList<T>(list);
                boolean modified = this.provider.modifyObjects(type, oldNewObjects);
                if (modified) {
                    LOGGER.log(Level.FINE, "typesChanged: modified objects to {0}", oldNewObjects);
                    if (!this.objectList.put(elementHandle, oldNewObjects)) continue;
                    this.fireChange();
                    continue;
                }
                LOGGER.log(Level.FINE, "typesChanged: not modifying any objects");
                continue;
            }
            type = elementHandle.resolve(this.helper.getCompilationController());
            if (type == null) {
                LOGGER.log(Level.WARNING, "typesChanged: type {0} has dissapeared", elementHandle);
                continue;
            }
            List<T> newObjects = this.provider.createObjects(type);
            LOGGER.log(Level.FINE, "typesChanged: new objects {0}", newObjects);
            if (!this.objectList.put(elementHandle, newObjects)) continue;
            this.fireChange();
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    private void fireChange() {
        LOGGER.log(Level.FINE, "firing change event");
        if (!this.changeSupport.hasListeners()) {
            return;
        }
        this.rp.post(new Runnable(){

            @Override
            public void run() {
                PersistentObjectManager.this.changeSupport.fireChange();
            }
        });
    }

    void rootsChanged() {
        LOGGER.log(Level.FINE, "rootsChanged called");
        this.deinitialize();
        this.fireChange();
    }

    @Override
    public void javaContextLeft() {
        if (this.initialized && this.temporary) {
            LOGGER.log(Level.FINE, "discarding temporary manager");
            this.deinitialize();
        }
    }
}

