/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.transformation.contentlimiter;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.manifoldcf.agents.interfaces.IOutputAddActivity;
import org.apache.manifoldcf.agents.interfaces.IOutputCheckActivity;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.agents.transformation.BaseTransformationConnector;
import org.apache.manifoldcf.agents.transformation.contentlimiter.Messages;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.core.interfaces.VersionContext;

public class ContentLimiter
extends BaseTransformationConnector {
    private static final String EDIT_SPECIFICATION_JS = "editSpecification.js";
    private static final String EDIT_SPECIFICATION_CONTENT_HTML = "editSpecification_Content.html";
    private static final String VIEW_SPECIFICATION_HTML = "viewSpecification.html";
    protected static final String ACTIVITY_LIMIT = "limit";
    protected static final String[] activitiesList = new String[]{"limit"};
    protected static final long inMemoryMaximumFile = 65536L;

    public String[] getActivitiesList() {
        return activitiesList;
    }

    public VersionContext getPipelineDescription(Specification os) throws ManifoldCFException, ServiceInterruption {
        SpecPacker sp = new SpecPacker(os);
        return new VersionContext(sp.toPackedString(), this.params, os);
    }

    public boolean checkMimeTypeIndexable(VersionContext outputDescription, String mimeType, IOutputCheckActivity activities) throws ManifoldCFException, ServiceInterruption {
        return activities.checkMimeTypeIndexable(mimeType);
    }

    public boolean checkLengthIndexable(VersionContext outputDescription, long length, IOutputCheckActivity activities) throws ManifoldCFException, ServiceInterruption {
        SpecPacker sp = new SpecPacker(outputDescription.getSpecification());
        return activities.checkLengthIndexable(Math.min(length, sp.lengthCutoff));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addOrReplaceDocumentWithException(String documentURI, VersionContext outputDescription, RepositoryDocument document, String authorityNameString, IOutputAddActivity activities) throws ManifoldCFException, ServiceInterruption, IOException {
        long length;
        RepositoryDocument finalDocument;
        String description;
        String resultCode;
        long startTime;
        DestinationStorage ds;
        InputStream is;
        block14: {
            SpecPacker sp = new SpecPacker(outputDescription.getSpecification());
            is = null;
            ds = null;
            startTime = System.currentTimeMillis();
            resultCode = "OK";
            description = null;
            if (document.getBinaryLength() > sp.lengthCutoff) {
                ds = document.getBinaryLength() <= 65536L ? new MemoryDestinationStorage((int)document.getBinaryLength()) : new FileDestinationStorage();
                finalDocument = document.duplicate();
                try (InputStream docIs = document.getBinaryStream();){
                    IOUtils.copyLarge((InputStream)docIs, (OutputStream)ds.getOutputStream(), (long)0L, (long)sp.lengthCutoff);
                    length = ds.getBinaryLength();
                    is = ds.getInputStream();
                    finalDocument.setBinary(is, length);
                    resultCode = "TRUNCATEDOK";
                    break block14;
                }
            }
            finalDocument = document;
            length = document.getBinaryLength();
        }
        activities.recordActivity(new Long(startTime), ACTIVITY_LIMIT, Long.valueOf(length), documentURI, resultCode, description);
        int n = activities.sendDocument(documentURI, finalDocument);
        return n;
        finally {
            if (is != null) {
                is.close();
            }
            if (ds != null) {
                ds.close();
            }
        }
    }

    protected static void fillInContentSpecificationMap(Map<String, Object> paramMap, Specification os) {
        String maxContentLength = "500000000";
        for (int i = 0; i < os.getChildCount(); ++i) {
            SpecificationNode sn = os.getChild(i);
            if (!sn.getType().equals("maxlength")) continue;
            maxContentLength = sn.getAttributeValue("value");
        }
        paramMap.put("MAXCONTENTLENGTH", maxContentLength);
    }

    public String getFormCheckJavascriptMethodName(int connectionSequenceNumber) {
        return "s" + connectionSequenceNumber + "_checkSpecification";
    }

    public String getFormPresaveCheckJavascriptMethodName(int connectionSequenceNumber) {
        return "s" + connectionSequenceNumber + "_checkSpecificationForSave";
    }

    public void outputSpecificationHeader(IHTTPOutput out, Locale locale, Specification os, int connectionSequenceNumber, List<String> tabsArray) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("SEQNUM", Integer.toString(connectionSequenceNumber));
        tabsArray.add(Messages.getString(locale, "ContentLimiter.ContentTabName"));
        ContentLimiter.fillInContentSpecificationMap(paramMap, os);
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPECIFICATION_JS, paramMap);
    }

    public void outputSpecificationBody(IHTTPOutput out, Locale locale, Specification os, int connectionSequenceNumber, int actualSequenceNumber, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("TABNAME", tabName);
        paramMap.put("SEQNUM", Integer.toString(connectionSequenceNumber));
        paramMap.put("SELECTEDNUM", Integer.toString(actualSequenceNumber));
        ContentLimiter.fillInContentSpecificationMap(paramMap, os);
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPECIFICATION_CONTENT_HTML, paramMap);
    }

    public String processSpecificationPost(IPostParameters variableContext, Locale locale, Specification os, int connectionSequenceNumber) throws ManifoldCFException {
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        String x = variableContext.getParameter(seqPrefix + "maxcontentlength");
        if (x != null) {
            int i = 0;
            while (i < os.getChildCount()) {
                SpecificationNode node = os.getChild(i);
                if (node.getType().equals("maxlength")) {
                    os.removeChild(i);
                    continue;
                }
                ++i;
            }
            SpecificationNode sn = new SpecificationNode("maxlength");
            sn.setAttribute("value", x);
            os.addChild(os.getChildCount(), (ConfigurationNode)sn);
        }
        return null;
    }

    public void viewSpecification(IHTTPOutput out, Locale locale, Specification os, int connectionSequenceNumber) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("SEQNUM", Integer.toString(connectionSequenceNumber));
        ContentLimiter.fillInContentSpecificationMap(paramMap, os);
        Messages.outputResourceWithVelocity(out, locale, VIEW_SPECIFICATION_HTML, paramMap);
    }

    protected static Set<String> fillSet(String input) {
        HashSet<String> rval = new HashSet<String>();
        try {
            StringReader sr = new StringReader(input);
            BufferedReader br = new BufferedReader(sr);
            String line = null;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).equals("*")) {
                    rval = null;
                    continue;
                }
                if (rval == null || line.length() <= 0) continue;
                rval.add(line.toLowerCase(Locale.ROOT));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("IO exception reading strings: " + e.getMessage(), e);
        }
        return rval;
    }

    protected static int handleIOException(IOException e) throws ManifoldCFException {
        if (e instanceof InterruptedIOException) {
            throw new ManifoldCFException(e.getMessage(), (Throwable)e, 2);
        }
        throw new ManifoldCFException(e.getMessage(), (Throwable)e);
    }

    protected static class SpecPacker {
        private Long lengthCutoff;

        public SpecPacker(Specification os) {
            for (int i = 0; i < os.getChildCount(); ++i) {
                SpecificationNode sn = os.getChild(i);
                if (!sn.getType().equals("maxlength")) continue;
                String value = sn.getAttributeValue("value");
                this.lengthCutoff = new Long(value);
            }
        }

        public String toPackedString() {
            StringBuilder sb = new StringBuilder();
            if (this.lengthCutoff == null) {
                sb.append('-');
            } else {
                sb.append('+');
                ContentLimiter.pack((StringBuilder)sb, (String)this.lengthCutoff.toString(), (char)'+');
            }
            return sb.toString();
        }
    }

    protected static class MemoryDestinationStorage
    implements DestinationStorage {
        protected final ByteArrayOutputStream outputStream;

        public MemoryDestinationStorage(int sizeHint) {
            this.outputStream = new ByteArrayOutputStream(sizeHint);
        }

        @Override
        public OutputStream getOutputStream() throws ManifoldCFException {
            return this.outputStream;
        }

        @Override
        public long getBinaryLength() throws ManifoldCFException {
            return this.outputStream.size();
        }

        @Override
        public InputStream getInputStream() throws ManifoldCFException {
            return new ByteArrayInputStream(this.outputStream.toByteArray());
        }

        @Override
        public void close() throws ManifoldCFException {
        }
    }

    protected static class FileDestinationStorage
    implements DestinationStorage {
        protected final File outputFile;
        protected final OutputStream outputStream;

        public FileDestinationStorage() throws ManifoldCFException {
            FileOutputStream outputStream;
            File outputFile;
            try {
                outputFile = File.createTempFile("mcftika", "tmp");
                outputStream = new FileOutputStream(outputFile);
            }
            catch (IOException e) {
                ContentLimiter.handleIOException(e);
                outputFile = null;
                outputStream = null;
            }
            this.outputFile = outputFile;
            this.outputStream = outputStream;
        }

        @Override
        public OutputStream getOutputStream() throws ManifoldCFException {
            return this.outputStream;
        }

        @Override
        public long getBinaryLength() throws ManifoldCFException {
            return this.outputFile.length();
        }

        @Override
        public InputStream getInputStream() throws ManifoldCFException {
            try {
                return new FileInputStream(this.outputFile);
            }
            catch (IOException e) {
                ContentLimiter.handleIOException(e);
                return null;
            }
        }

        @Override
        public void close() throws ManifoldCFException {
            this.outputFile.delete();
        }
    }

    protected static interface DestinationStorage {
        public OutputStream getOutputStream() throws ManifoldCFException;

        public long getBinaryLength() throws ManifoldCFException;

        public InputStream getInputStream() throws ManifoldCFException;

        public void close() throws ManifoldCFException;
    }
}

