/*
 * Decompiled with CFR 0.152.
 */
package org.castor.jdo.engine;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.util.Base64Decoder;
import org.castor.util.Base64Encoder;
import org.castor.util.Configuration;
import org.exolab.castor.jdo.engine.ClobImpl;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.TypeConvertor;
import org.exolab.castor.types.Duration;

public final class SQLTypeConverters {
    private static final Log LOG = LogFactory.getLog((Class)SQLTypeConverters.class);
    private static final String TIMESTAMP_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final String DECIMAL_PATTERN = "#################0";
    private static final int DEFAULT_LOB_SIZE = 256;
    private static final long THOUSAND = 1000L;
    private static final long MILLION = 1000000L;
    private static final DateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat();
    private static final SimpleDateFormat PARAM_DATE_FORMAT = new SimpleDateFormat();
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#################0");
    private static int _lobBufferSize = -1;
    private static Convertor[] _convertors = new Convertor[]{new Convertor(BigDecimal.class, Boolean.class){

        public Object convert(Object obj, String pm) {
            return new Boolean(((BigDecimal)obj).intValue() != 0);
        }
    }, new Convertor(Integer.class, Boolean.class){

        public Object convert(Object obj, String pm) {
            return new Boolean((Integer)obj != 0);
        }
    }, new Convertor(Short.class, Boolean.class){

        public Object convert(Object obj, String pm) {
            return new Boolean((Short)obj != 0);
        }
    }, new Convertor(String.class, Boolean.class){

        public Object convert(Object obj, String pm) {
            char t = 'T';
            char f = 'F';
            if (pm != null && pm.length() == 2) {
                t = Character.toUpperCase(pm.charAt(1));
                f = Character.toUpperCase(pm.charAt(0));
            }
            if (((String)obj).length() == 1) {
                char c = Character.toUpperCase(((String)obj).charAt(0));
                if (c == t) {
                    return Boolean.TRUE;
                }
                if (c == f) {
                    return Boolean.FALSE;
                }
            }
            throw new ClassCastException("Failed to convert string '" + obj + "' to boolean because it didn't match the expected values '" + t + "'/'" + f + "' (true/false).");
        }
    }, new Convertor(BigDecimal.class, Integer.class){

        public Object convert(Object obj, String pm) {
            return new Integer(((BigDecimal)obj).intValue());
        }
    }, new Convertor(Boolean.class, Integer.class){

        public Object convert(Object obj, String pm) {
            boolean val = (Boolean)obj;
            if (pm == null || pm.length() != 1 || pm.charAt(0) != '-') {
                return new Integer(val ? 1 : 0);
            }
            return new Integer(val ? -1 : 0);
        }
    }, new Convertor(Byte.class, Integer.class){

        public Object convert(Object obj, String pm) {
            return new Integer(((Byte)obj).intValue());
        }
    }, new Convertor(java.util.Date.class, Integer.class){

        public Object convert(Object obj, String pm) {
            SimpleDateFormat paramDateFormat = SQLTypeConverters.getParamDateFormat();
            paramDateFormat.applyPattern(SQLTypeConverters.getFullDatePattern(pm));
            return new Integer(paramDateFormat.format((java.util.Date)obj));
        }
    }, new Convertor(Double.class, Integer.class){

        public Object convert(Object obj, String pm) {
            return new Integer(((Double)obj).intValue());
        }
    }, new Convertor(Float.class, Integer.class){

        public Object convert(Object obj, String pm) {
            return new Integer(((Float)obj).intValue());
        }
    }, new Convertor(Long.class, Integer.class){

        public Object convert(Object obj, String pm) {
            return new Integer(((Long)obj).intValue());
        }
    }, new Convertor(Short.class, Integer.class){

        public Object convert(Object obj, String pm) {
            return new Integer(((Short)obj).intValue());
        }
    }, new Convertor(String.class, Integer.class){

        public Object convert(Object obj, String pm) {
            return Integer.valueOf((String)obj);
        }
    }, new Convertor(BigDecimal.class, Long.class){

        public Object convert(Object obj, String pm) {
            return new Long(((BigDecimal)obj).longValue());
        }
    }, new Convertor(java.util.Date.class, Long.class){

        public Object convert(Object obj, String pm) {
            return new Long(((java.util.Date)obj).getTime());
        }
    }, new Convertor(Double.class, Long.class){

        public Object convert(Object obj, String pm) {
            return new Long(((Double)obj).longValue());
        }
    }, new Convertor(Float.class, Long.class){

        public Object convert(Object obj, String pm) {
            return new Long(((Float)obj).longValue());
        }
    }, new Convertor(Integer.class, Long.class){

        public Object convert(Object obj, String pm) {
            return new Long(((Integer)obj).longValue());
        }
    }, new Convertor(Short.class, Long.class){

        public Object convert(Object obj, String pm) {
            return new Long(((Short)obj).longValue());
        }
    }, new Convertor(String.class, Long.class){

        public Object convert(Object obj, String pm) {
            return Long.valueOf((String)obj);
        }
    }, new Convertor(BigDecimal.class, Short.class){

        public Object convert(Object obj, String pm) {
            return new Short(((BigDecimal)obj).shortValue());
        }
    }, new Convertor(Boolean.class, Short.class){

        public Object convert(Object obj, String pm) {
            boolean val = (Boolean)obj;
            if (pm == null || pm.length() != 1 || pm.charAt(0) != '-') {
                return new Short(val ? (short)1 : 0);
            }
            return new Short(val ? (short)-1 : 0);
        }
    }, new Convertor(Byte.class, Short.class){

        public Object convert(Object obj, String pm) {
            return new Short(((Byte)obj).shortValue());
        }
    }, new Convertor(Integer.class, Short.class){

        public Object convert(Object obj, String pm) {
            return new Short(((Integer)obj).shortValue());
        }
    }, new Convertor(Long.class, Short.class){

        public Object convert(Object obj, String pm) {
            return new Short(((Long)obj).shortValue());
        }
    }, new Convertor(String.class, Short.class){

        public Object convert(Object obj, String pm) {
            return Short.valueOf((String)obj);
        }
    }, new Convertor(BigDecimal.class, Byte.class){

        public Object convert(Object obj, String pm) {
            return new Byte(((BigDecimal)obj).byteValue());
        }
    }, new Convertor(Integer.class, Byte.class){

        public Object convert(Object obj, String pm) {
            return new Byte(((Integer)obj).byteValue());
        }
    }, new Convertor(Short.class, Byte.class){

        public Object convert(Object obj, String pm) {
            return new Byte(((Short)obj).byteValue());
        }
    }, new Convertor(BigDecimal.class, Double.class){

        public Object convert(Object obj, String pm) {
            return new Double(((BigDecimal)obj).doubleValue());
        }
    }, new Convertor(java.util.Date.class, Double.class){

        public Object convert(Object obj, String pm) {
            SimpleDateFormat paramDateFormat = SQLTypeConverters.getParamDateFormat();
            paramDateFormat.applyPattern(SQLTypeConverters.getFullDatePattern(pm));
            return new Double(paramDateFormat.format((java.util.Date)obj));
        }
    }, new Convertor(Float.class, Double.class){

        public Object convert(Object obj, String pm) {
            return new Double(((Float)obj).floatValue());
        }
    }, new Convertor(Integer.class, Double.class){

        public Object convert(Object obj, String pm) {
            return new Double(((Integer)obj).doubleValue());
        }
    }, new Convertor(Long.class, Double.class){

        public Object convert(Object obj, String pm) {
            return new Double(((Long)obj).doubleValue());
        }
    }, new Convertor(String.class, Double.class){

        public Object convert(Object obj, String pm) {
            return Double.valueOf((String)obj);
        }
    }, new Convertor(BigDecimal.class, Float.class){

        public Object convert(Object obj, String pm) {
            return new Float(((BigDecimal)obj).floatValue());
        }
    }, new Convertor(Double.class, Float.class){

        public Object convert(Object obj, String pm) {
            return new Float(((Double)obj).floatValue());
        }
    }, new Convertor(Integer.class, Float.class){

        public Object convert(Object obj, String pm) {
            return new Float(((Integer)obj).floatValue());
        }
    }, new Convertor(Long.class, Float.class){

        public Object convert(Object obj, String pm) {
            return new Float(((Long)obj).floatValue());
        }
    }, new Convertor(String.class, Float.class){

        public Object convert(Object obj, String pm) {
            return Float.valueOf((String)obj);
        }
    }, new Convertor(Boolean.class, BigDecimal.class){

        public Object convert(Object obj, String pm) {
            boolean val = (Boolean)obj;
            if (pm == null || pm.length() != 1 || pm.charAt(0) != '-') {
                return BigDecimal.valueOf(val ? 1L : 0L);
            }
            return BigDecimal.valueOf(val ? -1L : 0L);
        }
    }, new Convertor(Byte.class, BigDecimal.class){

        public Object convert(Object obj, String pm) {
            return BigDecimal.valueOf(((Byte)obj).byteValue());
        }
    }, new Convertor(java.util.Date.class, BigDecimal.class){

        public Object convert(Object obj, String pm) {
            SimpleDateFormat paramDateFormat = SQLTypeConverters.getParamDateFormat();
            paramDateFormat.applyPattern(SQLTypeConverters.getFullDatePattern(pm));
            return new BigDecimal(new BigInteger(paramDateFormat.format((java.util.Date)obj)));
        }
    }, new Convertor(Double.class, BigDecimal.class){

        public Object convert(Object obj, String pm) {
            return new BigDecimal(((Double)obj).toString());
        }
    }, new Convertor(Float.class, BigDecimal.class){

        public Object convert(Object obj, String pm) {
            return new BigDecimal(((Float)obj).toString());
        }
    }, new Convertor(Integer.class, BigDecimal.class){

        public Object convert(Object obj, String pm) {
            return BigDecimal.valueOf(((Integer)obj).intValue());
        }
    }, new Convertor(Long.class, BigDecimal.class){

        public Object convert(Object obj, String pm) {
            return BigDecimal.valueOf((Long)obj);
        }
    }, new Convertor(Short.class, BigDecimal.class){

        public Object convert(Object obj, String pm) {
            return BigDecimal.valueOf(((Short)obj).shortValue());
        }
    }, new Convertor(String.class, BigDecimal.class){

        public Object convert(Object obj, String pm) {
            return new BigDecimal((String)obj);
        }
    }, new Convertor([B.class, String.class){

        public Object convert(Object obj, String pm) {
            return new String(Base64Encoder.encode((byte[])obj));
        }
    }, new Convertor([C.class, String.class){

        public Object convert(Object obj, String pm) {
            return new String((char[])obj);
        }
    }, new Convertor(Boolean.class, String.class){

        public Object convert(Object obj, String pm) {
            boolean val = (Boolean)obj;
            if (pm == null || pm.length() != 2) {
                return val ? "T" : "F";
            }
            return val ? pm.substring(1, 2) : pm.substring(0, 1);
        }
    }, new Convertor(Character.class, String.class){

        public Object convert(Object obj, String pm) {
            return obj.toString();
        }
    }, new Convertor(java.util.Date.class, String.class){

        public Object convert(Object obj, String pm) {
            if (pm == null || pm.length() == 0) {
                return obj.toString();
            }
            SimpleDateFormat paramDateFormat = SQLTypeConverters.getParamDateFormat();
            paramDateFormat.applyPattern(pm);
            return paramDateFormat.format((java.util.Date)obj);
        }
    }, new Convertor(Double.class, String.class){

        public Object convert(Object obj, String pm) {
            return obj.toString();
        }
    }, new Convertor(Float.class, String.class){

        public Object convert(Object obj, String pm) {
            return obj.toString();
        }
    }, new Convertor(Integer.class, String.class){

        public Object convert(Object obj, String pm) {
            return obj.toString();
        }
    }, new Convertor(Long.class, String.class){

        public Object convert(Object obj, String pm) {
            return obj.toString();
        }
    }, new Convertor(Object.class, String.class){

        public Object convert(Object obj, String pm) {
            return obj.toString();
        }
    }, new Convertor(Short.class, String.class){

        public Object convert(Object obj, String pm) {
            return obj.toString();
        }
    }, new Convertor(String.class, [B.class){

        public Object convert(Object obj, String pm) {
            return Base64Decoder.decode((String)obj);
        }
    }, new Convertor(String.class, [C.class){

        public Object convert(Object obj, String pm) {
            return ((String)obj).toCharArray();
        }
    }, new Convertor(String.class, Character.class){

        public Object convert(Object obj, String pm) {
            String str = (String)obj;
            return new Character(str.length() == 0 ? (char)'\u0000' : str.charAt(0));
        }
    }, new Convertor(BigDecimal.class, java.util.Date.class){

        public Object convert(Object obj, String pm) {
            try {
                SimpleDateFormat paramDateFormat = SQLTypeConverters.getParamDateFormat();
                paramDateFormat.applyPattern(SQLTypeConverters.getFullDatePattern(pm));
                return paramDateFormat.parse(obj.toString());
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException(ex.toString());
            }
        }
    }, new Convertor(Double.class, java.util.Date.class){

        public Object convert(Object obj, String pm) {
            try {
                SimpleDateFormat paramDateFormat = SQLTypeConverters.getParamDateFormat();
                paramDateFormat.applyPattern(SQLTypeConverters.getFullDatePattern(pm));
                return paramDateFormat.parse(SQLTypeConverters.getDecimalFormat().format(obj).trim());
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException(ex.toString());
            }
        }
    }, new Convertor(Integer.class, java.util.Date.class){

        public Object convert(Object obj, String pm) {
            try {
                SimpleDateFormat paramDateFormat = SQLTypeConverters.getParamDateFormat();
                paramDateFormat.applyPattern(SQLTypeConverters.getFullDatePattern(pm));
                return paramDateFormat.parse(obj.toString());
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException(ex.toString());
            }
        }
    }, new Convertor(Long.class, java.util.Date.class){

        public Object convert(Object obj, String pm) {
            return new java.util.Date((Long)obj);
        }
    }, new Convertor(String.class, java.util.Date.class){

        public Object convert(Object obj, String pm) {
            try {
                if (pm == null || pm.length() == 0) {
                    return SQLTypeConverters.getDefaultDateFormat().parse((String)obj);
                }
                SimpleDateFormat paramDateFormat = SQLTypeConverters.getParamDateFormat();
                paramDateFormat.applyPattern(pm);
                return paramDateFormat.parse((String)obj);
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException(ex.toString());
            }
        }
    }, new Convertor(java.util.Date.class, Date.class){

        public Object convert(Object obj, String pm) {
            return new Date(((java.util.Date)obj).getTime());
        }
    }, new Convertor(Date.class, java.util.Date.class){

        public Object convert(Object obj, String pm) {
            return obj;
        }
    }, new Convertor(java.util.Date.class, Time.class){

        public Object convert(Object obj, String pm) {
            return new Time(((java.util.Date)obj).getTime());
        }
    }, new Convertor(Time.class, java.util.Date.class){

        public Object convert(Object obj, String pm) {
            return obj;
        }
    }, new Convertor(java.util.Date.class, Timestamp.class){

        public Object convert(Object obj, String pm) {
            long time = ((java.util.Date)obj).getTime();
            Timestamp timestamp = new Timestamp(time);
            timestamp.setNanos((int)(time % 1000L * 1000000L));
            return timestamp;
        }
    }, new Convertor(Timestamp.class, java.util.Date.class){

        public Object convert(Object obj, String pm) {
            Timestamp timestamp = (Timestamp)obj;
            return new java.util.Date(timestamp.getTime());
        }
    }, new Convertor(String.class, Timestamp.class){

        public Object convert(Object obj, String pm) {
            long time;
            SimpleDateFormat paramDateFormat = SQLTypeConverters.getParamDateFormat();
            if (pm == null || pm.length() == 0) {
                paramDateFormat.applyPattern(SQLTypeConverters.TIMESTAMP_PATTERN);
            } else {
                paramDateFormat.applyPattern(pm);
            }
            try {
                time = paramDateFormat.parse((String)obj).getTime();
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException(ex.toString());
            }
            Timestamp timestamp = new Timestamp(time);
            timestamp.setNanos((int)(time % 1000L * 1000000L));
            return timestamp;
        }
    }, new Convertor(Timestamp.class, String.class){

        public Object convert(Object obj, String pm) {
            SimpleDateFormat paramDateFormat = SQLTypeConverters.getParamDateFormat();
            if (pm == null || pm.length() == 0) {
                paramDateFormat.applyPattern(SQLTypeConverters.TIMESTAMP_PATTERN);
            } else {
                paramDateFormat.applyPattern(pm);
            }
            Timestamp timestamp = (Timestamp)obj;
            return paramDateFormat.format(new java.util.Date(timestamp.getTime() + (long)timestamp.getNanos() / 1000000L));
        }
    }, new Convertor([B.class, InputStream.class){

        public Object convert(Object obj, String pm) {
            return new ByteArrayInputStream((byte[])obj);
        }
    }, new Convertor(InputStream.class, [B.class){

        public Object convert(Object obj, String pm) {
            try {
                InputStream is = (InputStream)obj;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] buffer = new byte[SQLTypeConverters.getLobBufferSize()];
                int len = 0;
                while ((len = is.read(buffer)) > 0) {
                    bos.write(buffer, 0, len);
                }
                return bos.toByteArray();
            }
            catch (IOException ex) {
                throw new IllegalArgumentException(ex.toString());
            }
        }
    }, new Convertor([C.class, Clob.class){

        public Object convert(Object obj, String pm) {
            char[] chars = (char[])obj;
            return new ClobImpl(new CharArrayReader(chars), chars.length);
        }
    }, new Convertor(Clob.class, [C.class){

        public Object convert(Object obj, String pm) {
            try {
                Reader reader = ((Clob)obj).getCharacterStream();
                CharArrayWriter writer = new CharArrayWriter();
                char[] buffer = new char[SQLTypeConverters.getLobBufferSize()];
                int len = 0;
                while ((len = reader.read(buffer)) > 0) {
                    writer.write(buffer, 0, len);
                }
                return writer.toCharArray();
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(ex.toString());
            }
        }
    }, new Convertor(String.class, Clob.class){

        public Object convert(Object obj, String pm) {
            String str = (String)obj;
            return new ClobImpl(new StringReader(str), str.length());
        }
    }, new Convertor(Clob.class, String.class){

        public Object convert(Object obj, String pm) {
            try {
                Reader reader = ((Clob)obj).getCharacterStream();
                CharArrayWriter writer = new CharArrayWriter();
                char[] buffer = new char[SQLTypeConverters.getLobBufferSize()];
                int len = 0;
                while ((len = reader.read(buffer)) > 0) {
                    writer.write(buffer, 0, len);
                }
                return writer.toString();
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(ex.toString());
            }
        }
    }, new Convertor(java.util.Date.class, org.exolab.castor.types.Date.class){

        public Object convert(Object obj, String pm) {
            return new org.exolab.castor.types.Date((java.util.Date)obj);
        }
    }, new Convertor(org.exolab.castor.types.Date.class, java.util.Date.class){

        public Object convert(Object obj, String pm) {
            return ((org.exolab.castor.types.Date)obj).toDate();
        }
    }, new Convertor(Date.class, org.exolab.castor.types.Date.class){

        public Object convert(Object obj, String pm) {
            return new org.exolab.castor.types.Date((java.util.Date)obj);
        }
    }, new Convertor(org.exolab.castor.types.Date.class, Date.class){

        public Object convert(Object obj, String pm) {
            long time = ((org.exolab.castor.types.Date)obj).toDate().getTime();
            return new Date(time);
        }
    }, new Convertor(Long.class, Duration.class){

        public Object convert(Object obj, String pm) {
            return new Duration((Long)obj);
        }
    }, new Convertor(Duration.class, Long.class){

        public Object convert(Object obj, String pm) {
            return new Long(((Duration)obj).toLong());
        }
    }, new Convertor([B.class, Serializable.class){

        public Object convert(Object obj, String pm) {
            return obj;
        }
    }, new Convertor(Serializable.class, [B.class){

        public Object convert(Object obj, String pm) {
            return obj;
        }
    }, new Convertor(InputStream.class, Serializable.class){

        public Object convert(Object obj, String pm) {
            try {
                InputStream is = (InputStream)obj;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] buffer = new byte[SQLTypeConverters.getLobBufferSize()];
                int len = 0;
                while ((len = is.read(buffer)) > 0) {
                    bos.write(buffer, 0, len);
                }
                return bos.toByteArray();
            }
            catch (IOException ex) {
                throw new IllegalArgumentException(ex.toString());
            }
        }
    }, new Convertor(Serializable.class, InputStream.class){

        public Object convert(Object obj, String pm) {
            return new ByteArrayInputStream((byte[])obj);
        }
    }};

    private static SimpleDateFormat getDefaultDateFormat() {
        return (SimpleDateFormat)DEFAULT_DATE_FORMAT.clone();
    }

    private static SimpleDateFormat getParamDateFormat() {
        return (SimpleDateFormat)PARAM_DATE_FORMAT.clone();
    }

    private static DecimalFormat getDecimalFormat() {
        return (DecimalFormat)DECIMAL_FORMAT.clone();
    }

    private static int getLobBufferSize() {
        if (_lobBufferSize == -1) {
            Configuration config = Configuration.getInstance();
            _lobBufferSize = config.getProperty("org.exolab.castor.jdo.lobBufferSize", 256);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Using lobSize: " + _lobBufferSize));
            }
        }
        return _lobBufferSize;
    }

    public static String getFullDatePattern(String pattern) {
        int len = pattern.length();
        if (pattern == null || len == 0) {
            return "yyyyMMdd";
        }
        StringBuffer sb = new StringBuffer();
        block9: for (int i = 0; i < len; ++i) {
            switch (pattern.charAt(i)) {
                case 'Y': 
                case 'y': {
                    sb.append("yyyy");
                    continue block9;
                }
                case 'M': {
                    sb.append("MM");
                    continue block9;
                }
                case 'D': 
                case 'd': {
                    sb.append("dd");
                    continue block9;
                }
                case 'H': 
                case 'h': {
                    sb.append("HH");
                    continue block9;
                }
                case 'm': {
                    sb.append("mm");
                    continue block9;
                }
                case 's': {
                    sb.append("ss");
                    continue block9;
                }
                case 'S': {
                    sb.append("SSS");
                    continue block9;
                }
            }
        }
        return sb.toString();
    }

    public static TypeConvertor getConvertor(Class fromType, Class toType) throws MappingException {
        Convertor conv;
        int i;
        int len = _convertors.length;
        for (i = 0; i < len; ++i) {
            conv = _convertors[i];
            if (!conv._fromType.equals(fromType) || !toType.equals(conv._toType)) continue;
            return conv;
        }
        for (i = 0; i < len; ++i) {
            conv = _convertors[i];
            if (!conv._fromType.isAssignableFrom(fromType) || !toType.isAssignableFrom(conv._toType)) continue;
            return conv;
        }
        throw new MappingException("mapping.noConvertor", fromType.getName(), toType.getName());
    }

    private SQLTypeConverters() {
    }

    public static abstract class Convertor
    implements TypeConvertor {
        private final Class _fromType;
        private final Class _toType;

        public Convertor(Class fromType, Class toType) {
            this._fromType = fromType;
            this._toType = toType;
        }

        public final Class fromType() {
            return this._fromType;
        }

        public final Class toType() {
            return this._toType;
        }

        public abstract Object convert(Object var1, String var2);

        public final String toString() {
            return this._fromType.getName() + "-->" + this._toType.getName();
        }
    }
}

