/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.ha.dispatch;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.AsyncContext;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.nio.client.methods.HttpAsyncMethods;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.knox.gateway.config.Configure;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.ha.config.CommonHaConfigurations;
import org.apache.knox.gateway.ha.config.HaConfigurations;
import org.apache.knox.gateway.ha.dispatch.CommonHaDispatch;
import org.apache.knox.gateway.ha.dispatch.SSEHaCallback;
import org.apache.knox.gateway.ha.dispatch.i18n.HaDispatchMessages;
import org.apache.knox.gateway.ha.provider.HaProvider;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.sse.SSEDispatch;

public class SSEHaDispatch
extends SSEDispatch
implements CommonHaDispatch {
    protected static final HaDispatchMessages LOG = (HaDispatchMessages)MessagesFactory.get(HaDispatchMessages.class);
    private final boolean sslEnabled;
    private final HaConfigurations haConfigurations = new CommonHaConfigurations();
    private final AtomicReference<String> activeURL = new AtomicReference();

    public SSEHaDispatch(FilterConfig filterConfig) {
        super(filterConfig);
        GatewayConfig gatewayConfig = (GatewayConfig)filterConfig.getServletContext().getAttribute("org.apache.knox.gateway.config");
        this.sslEnabled = gatewayConfig.isSSLEnabled();
    }

    public void init() {
        super.init();
        LOG.initializingForResourceRole(this.getServiceRole());
        if (this.haConfigurations.getHaProvider() != null) {
            this.initializeCommonHaDispatch(this.haConfigurations.getHaProvider().getHaDescriptor().getServiceConfig(this.getServiceRole()));
        }
    }

    @Configure
    public void setHaProvider(HaProvider haProvider) {
        this.getHaConfigurations().setHaProvider(haProvider);
    }

    @Override
    public HaConfigurations getHaConfigurations() {
        return this.haConfigurations;
    }

    @Override
    public AtomicReference<String> getActiveURL() {
        return this.activeURL;
    }

    @Override
    public void setActiveURL(String url) {
        this.activeURL.set(url);
    }

    protected void executeAsyncRequest(HttpUriRequest outboundRequest, HttpServletResponse outboundResponse, AsyncContext asyncContext, HttpServletRequest inboundRequest) {
        HttpAsyncRequestProducer producer = HttpAsyncMethods.create((HttpUriRequest)outboundRequest);
        SSEDispatch.SSECharConsumer consumer = new SSEDispatch.SSECharConsumer((SSEDispatch)this, outboundResponse, outboundRequest.getURI(), asyncContext, inboundRequest, outboundRequest);
        LOG.dispatchRequest(outboundRequest.getMethod(), outboundRequest.getURI());
        auditor.audit("dispatch", outboundRequest.getURI().toString(), "uri", "unavailable", RES.requestMethod(outboundRequest.getMethod()));
        this.asyncClient.execute(producer, (HttpAsyncResponseConsumer)consumer, (FutureCallback)new SSEHaCallback(outboundResponse, asyncContext, producer, this, outboundRequest, inboundRequest));
    }

    protected void failoverRequest(HttpUriRequest outboundRequest, HttpServletResponse outboundResponse, HttpServletRequest inboundRequest, AsyncContext asyncContext) {
        try {
            if (this.disabledFailoverHandled(inboundRequest, outboundResponse)) {
                asyncContext.complete();
                return;
            }
            AtomicInteger counter = this.markEndpointFailed(outboundRequest, inboundRequest);
            inboundRequest.setAttribute("dispatch.ha.failover.counter", (Object)counter);
            if (counter.get() <= this.haConfigurations.getMaxFailoverAttempts()) {
                inboundRequest = this.prepareForFailover(outboundRequest, inboundRequest);
                this.executeAsyncRequest(outboundRequest, outboundResponse, asyncContext, inboundRequest);
            } else {
                LOG.maxFailoverAttemptsReached(this.haConfigurations.getMaxFailoverAttempts(), this.getServiceRole());
                outboundResponse.sendError(502, "Service connection error, max failover attempts reached");
                asyncContext.complete();
            }
        }
        catch (IOException e) {
            asyncContext.complete();
        }
    }

    protected void executeRequestWrapper(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse) {
        boolean userAgentDisabled = this.isUserAgentDisabled(inboundRequest);
        this.setBackendUri(outboundRequest, inboundRequest, userAgentDisabled);
        this.executeRequest(outboundRequest, inboundRequest, outboundResponse);
    }

    protected void outboundResponseWrapper(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse) {
        this.setKnoxHaCookie(outboundRequest, inboundRequest, outboundResponse, this.sslEnabled);
    }

    protected void shiftCallback(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest) {
        boolean userAgentDisabled;
        this.shiftActiveURL(userAgentDisabled, (userAgentDisabled = this.isUserAgentDisabled(inboundRequest)) ? Optional.empty() : this.getBackendFromHaCookie(outboundRequest, inboundRequest));
    }
}

