/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.make.metatype;

import aQute.bnd.annotation.metatype.Meta;
import aQute.bnd.header.Parameters;
import aQute.bnd.make.metatype.MetaTypeReader;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Jar;
import aQute.bnd.service.AnalyzerPlugin;
import java.util.Collection;

public class MetatypePlugin
implements AnalyzerPlugin {
    public boolean analyzeJar(Analyzer analyzer) throws Exception {
        Parameters map = analyzer.parseHeader(analyzer.getProperty("-metatype"));
        Jar jar = analyzer.getJar();
        for (String name : map.keySet()) {
            Collection<Clazz> metatypes = analyzer.getClasses("", ((Object)((Object)Clazz.QUERY.ANNOTATED)).toString(), Meta.OCD.class.getName(), ((Object)((Object)Clazz.QUERY.NAMED)).toString(), name);
            for (Clazz c : metatypes) {
                jar.putResource("OSGI-INF/metatype/" + c.getFQN() + ".xml", new MetaTypeReader(c, analyzer));
            }
        }
        return false;
    }

    public String toString() {
        return "MetatypePlugin";
    }
}

