/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.log.metrics;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.kafka.server.log.remote.storage.RemoteStorageMetrics;
import org.apache.kafka.storage.log.metrics.BrokerTopicMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerTopicStats
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(BrokerTopicStats.class);
    private final boolean remoteStorageEnabled;
    private final BrokerTopicMetrics allTopicsStats;
    private final ConcurrentMap<String, BrokerTopicMetrics> stats;

    public BrokerTopicStats() {
        this(false);
    }

    public BrokerTopicStats(boolean remoteStorageEnabled) {
        this.remoteStorageEnabled = remoteStorageEnabled;
        this.allTopicsStats = new BrokerTopicMetrics(remoteStorageEnabled);
        this.stats = new ConcurrentHashMap<String, BrokerTopicMetrics>();
    }

    public boolean isTopicStatsExisted(String topic) {
        return this.stats.containsKey(topic);
    }

    public BrokerTopicMetrics topicStats(String topic) {
        return this.stats.computeIfAbsent(topic, k -> new BrokerTopicMetrics((String)k, this.remoteStorageEnabled));
    }

    public void updateReplicationBytesIn(long value) {
        this.allTopicsStats.replicationBytesInRate().ifPresent(metric -> metric.mark(value));
    }

    private void updateReplicationBytesOut(long value) {
        this.allTopicsStats.replicationBytesOutRate().ifPresent(metric -> metric.mark(value));
    }

    public void updateReassignmentBytesIn(long value) {
        this.allTopicsStats.reassignmentBytesInPerSec().ifPresent(metric -> metric.mark(value));
    }

    private void updateReassignmentBytesOut(long value) {
        this.allTopicsStats.reassignmentBytesOutPerSec().ifPresent(metric -> metric.mark(value));
    }

    public void removeOldLeaderMetrics(String topic) {
        BrokerTopicMetrics topicMetrics = this.topicStats(topic);
        if (topicMetrics != null) {
            topicMetrics.closeMetric("MessagesInPerSec");
            topicMetrics.closeMetric("BytesInPerSec");
            topicMetrics.closeMetric("BytesRejectedPerSec");
            topicMetrics.closeMetric("FailedProduceRequestsPerSec");
            topicMetrics.closeMetric("TotalProduceRequestsPerSec");
            topicMetrics.closeMetric("ProduceMessageConversionsPerSec");
            topicMetrics.closeMetric("ReplicationBytesOutPerSec");
            topicMetrics.closeMetric("ReassignmentBytesOutPerSec");
            topicMetrics.closeMetric(RemoteStorageMetrics.REMOTE_COPY_BYTES_PER_SEC_METRIC.getName());
            topicMetrics.closeMetric(RemoteStorageMetrics.REMOTE_FETCH_BYTES_PER_SEC_METRIC.getName());
            topicMetrics.closeMetric(RemoteStorageMetrics.REMOTE_FETCH_REQUESTS_PER_SEC_METRIC.getName());
            topicMetrics.closeMetric(RemoteStorageMetrics.REMOTE_COPY_REQUESTS_PER_SEC_METRIC.getName());
            topicMetrics.closeMetric(RemoteStorageMetrics.REMOTE_DELETE_REQUESTS_PER_SEC_METRIC.getName());
            topicMetrics.closeMetric(RemoteStorageMetrics.BUILD_REMOTE_LOG_AUX_STATE_REQUESTS_PER_SEC_METRIC.getName());
            topicMetrics.closeMetric(RemoteStorageMetrics.FAILED_REMOTE_FETCH_PER_SEC_METRIC.getName());
            topicMetrics.closeMetric(RemoteStorageMetrics.FAILED_REMOTE_COPY_PER_SEC_METRIC.getName());
            topicMetrics.closeMetric(RemoteStorageMetrics.REMOTE_COPY_LAG_BYTES_METRIC.getName());
            topicMetrics.closeMetric(RemoteStorageMetrics.REMOTE_LOG_METADATA_COUNT_METRIC.getName());
            topicMetrics.closeMetric(RemoteStorageMetrics.REMOTE_LOG_SIZE_COMPUTATION_TIME_METRIC.getName());
            topicMetrics.closeMetric(RemoteStorageMetrics.REMOTE_LOG_SIZE_BYTES_METRIC.getName());
            topicMetrics.closeMetric(RemoteStorageMetrics.FAILED_REMOTE_DELETE_PER_SEC_METRIC.getName());
            topicMetrics.closeMetric(RemoteStorageMetrics.FAILED_BUILD_REMOTE_LOG_AUX_STATE_PER_SEC_METRIC.getName());
            topicMetrics.closeMetric(RemoteStorageMetrics.REMOTE_COPY_LAG_BYTES_METRIC.getName());
            topicMetrics.closeMetric(RemoteStorageMetrics.REMOTE_COPY_LAG_SEGMENTS_METRIC.getName());
            topicMetrics.closeMetric(RemoteStorageMetrics.REMOTE_DELETE_LAG_BYTES_METRIC.getName());
            topicMetrics.closeMetric(RemoteStorageMetrics.REMOTE_DELETE_LAG_SEGMENTS_METRIC.getName());
        }
    }

    public void removeOldFollowerMetrics(String topic) {
        BrokerTopicMetrics topicMetrics = this.topicStats(topic);
        if (topicMetrics != null) {
            topicMetrics.closeMetric("ReplicationBytesInPerSec");
            topicMetrics.closeMetric("ReassignmentBytesInPerSec");
        }
    }

    public void removeMetrics(String topic) {
        BrokerTopicMetrics metrics = (BrokerTopicMetrics)this.stats.remove(topic);
        if (metrics != null) {
            metrics.close();
        }
    }

    public void updateBytesOut(String topic, boolean isFollower, boolean isReassignment, long value) {
        if (isFollower) {
            if (isReassignment) {
                this.updateReassignmentBytesOut(value);
            }
            this.updateReplicationBytesOut(value);
        } else {
            this.topicStats(topic).bytesOutRate().mark(value);
            this.allTopicsStats.bytesOutRate().mark(value);
        }
    }

    public void recordRemoteCopyLagBytes(String topic, int partition, long value) {
        BrokerTopicMetrics topicMetric = this.topicStats(topic);
        topicMetric.remoteCopyLagBytesAggrMetric().setValue(String.valueOf(partition), value);
        this.allTopicsStats.remoteCopyLagBytesAggrMetric().setValue(topic, topicMetric.remoteCopyLagBytes());
    }

    public void removeRemoteCopyLagBytes(String topic, int partition) {
        BrokerTopicMetrics topicMetric = this.topicStats(topic);
        topicMetric.remoteCopyLagBytesAggrMetric().removeKey(String.valueOf(partition));
        this.allTopicsStats.remoteCopyLagBytesAggrMetric().setValue(topic, topicMetric.remoteCopyLagBytes());
    }

    public void removeBrokerLevelRemoteCopyLagBytes(String topic) {
        this.allTopicsStats.remoteCopyLagBytesAggrMetric().removeKey(topic);
    }

    public void recordRemoteCopyLagSegments(String topic, int partition, long value) {
        BrokerTopicMetrics topicMetric = this.topicStats(topic);
        topicMetric.remoteCopyLagSegmentsAggrMetric().setValue(String.valueOf(partition), value);
        this.allTopicsStats.remoteCopyLagSegmentsAggrMetric().setValue(topic, topicMetric.remoteCopyLagSegments());
    }

    public void removeRemoteCopyLagSegments(String topic, int partition) {
        BrokerTopicMetrics topicMetric = this.topicStats(topic);
        topicMetric.remoteCopyLagSegmentsAggrMetric().removeKey(String.valueOf(partition));
        this.allTopicsStats.remoteCopyLagSegmentsAggrMetric().setValue(topic, topicMetric.remoteCopyLagSegments());
    }

    public void removeBrokerLevelRemoteCopyLagSegments(String topic) {
        this.allTopicsStats.remoteCopyLagSegmentsAggrMetric().removeKey(topic);
    }

    public void recordRemoteDeleteLagBytes(String topic, int partition, long value) {
        BrokerTopicMetrics topicMetric = this.topicStats(topic);
        topicMetric.remoteDeleteLagBytesAggrMetric().setValue(String.valueOf(partition), value);
        this.allTopicsStats.remoteDeleteLagBytesAggrMetric().setValue(topic, topicMetric.remoteDeleteLagBytes());
    }

    public void removeRemoteDeleteLagBytes(String topic, int partition) {
        BrokerTopicMetrics topicMetric = this.topicStats(topic);
        topicMetric.remoteDeleteLagBytesAggrMetric().removeKey(String.valueOf(partition));
        this.allTopicsStats.remoteDeleteLagBytesAggrMetric().setValue(topic, topicMetric.remoteDeleteLagBytes());
    }

    public void removeBrokerLevelRemoteDeleteLagBytes(String topic) {
        this.allTopicsStats.remoteDeleteLagBytesAggrMetric().removeKey(topic);
    }

    public void recordRemoteDeleteLagSegments(String topic, int partition, long value) {
        BrokerTopicMetrics topicMetric = this.topicStats(topic);
        topicMetric.remoteDeleteLagSegmentsAggrMetric().setValue(String.valueOf(partition), value);
        this.allTopicsStats.remoteDeleteLagSegmentsAggrMetric().setValue(topic, topicMetric.remoteDeleteLagSegments());
    }

    public void removeRemoteDeleteLagSegments(String topic, int partition) {
        BrokerTopicMetrics topicMetric = this.topicStats(topic);
        topicMetric.remoteDeleteLagSegmentsAggrMetric().removeKey(String.valueOf(partition));
        this.allTopicsStats.remoteDeleteLagSegmentsAggrMetric().setValue(topic, topicMetric.remoteDeleteLagSegments());
    }

    public void removeBrokerLevelRemoteDeleteLagSegments(String topic) {
        this.allTopicsStats.remoteDeleteLagSegmentsAggrMetric().removeKey(topic);
    }

    public void recordRemoteLogMetadataCount(String topic, int partition, long value) {
        BrokerTopicMetrics topicMetric = this.topicStats(topic);
        topicMetric.remoteLogMetadataCountAggrMetric().setValue(String.valueOf(partition), value);
        this.allTopicsStats.remoteLogMetadataCountAggrMetric().setValue(topic, topicMetric.remoteLogMetadataCount());
    }

    public void removeRemoteLogMetadataCount(String topic, int partition) {
        BrokerTopicMetrics topicMetric = this.topicStats(topic);
        topicMetric.remoteLogMetadataCountAggrMetric().removeKey(String.valueOf(partition));
        this.allTopicsStats.remoteLogMetadataCountAggrMetric().setValue(topic, topicMetric.remoteLogMetadataCount());
    }

    public void removeBrokerLevelRemoteLogMetadataCount(String topic) {
        this.allTopicsStats.remoteLogMetadataCountAggrMetric().removeKey(topic);
    }

    public void recordRemoteLogSizeComputationTime(String topic, int partition, long value) {
        BrokerTopicMetrics topicMetric = this.topicStats(topic);
        topicMetric.remoteLogSizeComputationTimeAggrMetric().setValue(String.valueOf(partition), value);
        this.allTopicsStats.remoteLogSizeComputationTimeAggrMetric().setValue(topic, topicMetric.remoteLogSizeComputationTime());
    }

    public void removeRemoteLogSizeComputationTime(String topic, int partition) {
        BrokerTopicMetrics topicMetric = this.topicStats(topic);
        topicMetric.remoteLogSizeComputationTimeAggrMetric().removeKey(String.valueOf(partition));
        this.allTopicsStats.remoteLogSizeComputationTimeAggrMetric().setValue(topic, topicMetric.remoteLogSizeComputationTime());
    }

    public void removeBrokerLevelRemoteLogSizeComputationTime(String topic) {
        this.allTopicsStats.remoteLogSizeComputationTimeAggrMetric().removeKey(topic);
    }

    public void recordRemoteLogSizeBytes(String topic, int partition, long value) {
        BrokerTopicMetrics topicMetric = this.topicStats(topic);
        topicMetric.remoteLogSizeBytesAggrMetric().setValue(String.valueOf(partition), value);
        this.allTopicsStats.remoteLogSizeBytesAggrMetric().setValue(topic, topicMetric.remoteLogSizeBytes());
    }

    public void removeRemoteLogSizeBytes(String topic, int partition) {
        BrokerTopicMetrics topicMetric = this.topicStats(topic);
        topicMetric.remoteLogSizeBytesAggrMetric().removeKey(String.valueOf(partition));
        this.allTopicsStats.remoteLogSizeBytesAggrMetric().setValue(topic, topicMetric.remoteLogSizeBytes());
    }

    public void removeBrokerLevelRemoteLogSizeBytes(String topic) {
        this.allTopicsStats.remoteLogSizeBytesAggrMetric().removeKey(topic);
    }

    @Override
    public void close() {
        this.allTopicsStats.close();
        this.stats.values().forEach(BrokerTopicMetrics::close);
        LOG.info("Broker and topic stats closed");
    }

    public BrokerTopicMetrics allTopicsStats() {
        return this.allTopicsStats;
    }
}

