/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.network.RequestChannel;
import kafka.network.RequestChannel$ShutdownRequest$;
import kafka.network.RequestChannel$WakeupRequest$;
import kafka.server.ApiRequestHandler;
import kafka.server.KafkaRequestHandler$;
import kafka.utils.Logging;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.RequestLocal;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t\u0005q!\u0002\u0014(\u0011\u0003ac!\u0002\u0018(\u0011\u0003y\u0003\"\u0002\u001c\u0002\t\u00039\u0004b\u0002\u001d\u0002\u0005\u0004%I!\u000f\u0005\u0007\u0011\u0006\u0001\u000b\u0011\u0002\u001e\t\u000f%\u000b!\u0019!C\u0005\u0015\"11+\u0001Q\u0001\n-Cq\u0001V\u0001A\u0002\u0013%Q\u000bC\u0004Z\u0003\u0001\u0007I\u0011\u0002.\t\r\u0001\f\u0001\u0015)\u0003W\u0011\u0015)\u0017\u0001\"\u0001g\u0011\u0015I\u0017\u0001\"\u0001k\u0011%\tY\"AI\u0001\n\u0003\tiBB\u0003/O\u0001\tI\u0005\u0003\u0006\u0002d5\u0011\t\u0011)A\u0005\u0003KB!\"a\u001b\u000e\u0005\u0003\u0005\u000b\u0011BA3\u0011)\ti'\u0004BC\u0002\u0013\u0005\u0011q\u000e\u0005\u000b\u0003\u0013k!\u0011!Q\u0001\n\u0005E\u0004BCAF\u001b\t\u0015\r\u0011\"\u0001\u0002\u000e\"Q\u00111U\u0007\u0003\u0002\u0003\u0006I!a$\t\u0015\u0005\u0015VB!b\u0001\n\u0003\t9\u000bC\u0005\u0002*6\u0011\t\u0011)A\u0005\u0005\"Q\u00111V\u0007\u0003\u0002\u0003\u0006I!!,\t\u0015\u0005MVB!A!\u0002\u0013\t)\f\u0003\u0006\u0002B6\u0011\t\u0011)A\u0005\u0003CAaAN\u0007\u0005\u0002\u0005\r\u0007\"CAl\u001b\t\u0007I\u0011BAm\u0011!\t\u0019/\u0004Q\u0001\n\u0005m\u0007\"CA\r\u001b\t\u0007I\u0011BAs\u0011\u001d\t9/\u0004Q\u0001\n}D\u0001\"!;\u000e\u0001\u0004%I!\u0016\u0005\n\u0003Wl\u0001\u0019!C\u0005\u0003[Dq!!=\u000eA\u0003&a\u000bC\u0004\u0002v6!\t!a>\t\u000f\u0005eX\u0002\"\u0003\u0002x\"9\u00111`\u0007\u0005\u0002\u0005]\bbBA\u007f\u001b\u0011\u0005\u0011q\u001f\u0005\b\u0003\u007flA\u0011AA|\u0003MY\u0015MZ6b%\u0016\fX/Z:u\u0011\u0006tG\r\\3s\u0015\tA\u0013&\u0001\u0004tKJ4XM\u001d\u0006\u0002U\u0005)1.\u00194lC\u000e\u0001\u0001CA\u0017\u0002\u001b\u00059#aE&bM.\f'+Z9vKN$\b*\u00198eY\u0016\u00148CA\u00011!\t\tD'D\u00013\u0015\u0005\u0019\u0014!B:dC2\f\u0017BA\u001b3\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001L\u0001\u0015i\"\u0014X-\u00193SKF,Xm\u001d;DQ\u0006tg.\u001a7\u0016\u0003i\u00022a\u000f!C\u001b\u0005a$BA\u001f?\u0003\u0011a\u0017M\\4\u000b\u0003}\nAA[1wC&\u0011\u0011\t\u0010\u0002\f)\"\u0014X-\u00193M_\u000e\fG\u000e\u0005\u0002D\r6\tAI\u0003\u0002FS\u00059a.\u001a;x_J\\\u0017BA$E\u00059\u0011V-];fgR\u001c\u0005.\u00198oK2\fQ\u0003\u001e5sK\u0006$'+Z9vKN$8\t[1o]\u0016d\u0007%\u0001\u000buQJ,\u0017\rZ\"veJ,g\u000e\u001e*fcV,7\u000f^\u000b\u0002\u0017B\u00191\b\u0011'\u0011\u00055\u0003fBA\"O\u0013\tyE)\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\n\u0005E\u0013&a\u0002*fcV,7\u000f\u001e\u0006\u0003\u001f\u0012\u000bQ\u0003\u001e5sK\u0006$7)\u001e:sK:$(+Z9vKN$\b%A\tcsB\f7o\u001d+ie\u0016\fGm\u00115fG.,\u0012A\u0016\t\u0003c]K!\u0001\u0017\u001a\u0003\u000f\t{w\u000e\\3b]\u0006)\"-\u001f9bgN$\u0006N]3bI\u000eCWmY6`I\u0015\fHCA._!\t\tD,\u0003\u0002^e\t!QK\\5u\u0011\u001dy\u0006\"!AA\u0002Y\u000b1\u0001\u001f\u00132\u0003I\u0011\u0017\u0010]1tgRC'/Z1e\u0007\",7m\u001b\u0011)\u0005%\u0011\u0007CA\u0019d\u0013\t!'G\u0001\u0005w_2\fG/\u001b7f\u0003Q\u0019X\r\u001e\"za\u0006\u001c8\u000f\u00165sK\u0006$7\t[3dWR\u00111l\u001a\u0005\u0006Q*\u0001\rAV\u0001\fEf\u0004\u0018m]:DQ\u0016\u001c7.A\txe\u0006\u0004\u0018i]=oG\u000e\u000bG\u000e\u001c2bG.,\"a[9\u0015\t1T\u0018q\u0003\t\u0005c5|7,\u0003\u0002oe\tIa)\u001e8di&|g.\r\t\u0003aFd\u0001\u0001B\u0003s\u0017\t\u00071OA\u0001U#\t!x\u000f\u0005\u00022k&\u0011aO\r\u0002\b\u001d>$\b.\u001b8h!\t\t\u00040\u0003\u0002ze\t\u0019\u0011I\\=\t\u000bm\\\u0001\u0019\u0001?\u0002/\u0005\u001c\u0018P\\2D_6\u0004H.\u001a;j_:\u001c\u0015\r\u001c7cC\u000e\\\u0007#B\u0019~\u007f>\\\u0016B\u0001@3\u0005%1UO\\2uS>t'\u0007\u0005\u0003\u0002\u0002\u0005MQBAA\u0002\u0015\u0011\t)!a\u0002\u0002\r\r|W.\\8o\u0015\rA\u0013\u0011\u0002\u0006\u0004U\u0005-!\u0002BA\u0007\u0003\u001f\ta!\u00199bG\",'BAA\t\u0003\ry'oZ\u0005\u0005\u0003+\t\u0019A\u0001\u0007SKF,Xm\u001d;M_\u000e\fG\u000e\u0003\u0004\u0002\u001a-\u0001\ra`\u0001\re\u0016\fX/Z:u\u0019>\u001c\u0017\r\\\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001d\u0016\u0005\u0005}!\u0006BA\u0011\u0003o\u0001B!a\t\u000229!\u0011QEA\u0017!\r\t9CM\u0007\u0003\u0003SQ1!a\u000b,\u0003\u0019a$o\\8u}%\u0019\u0011q\u0006\u001a\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019$!\u000e\u0003\rM#(/\u001b8h\u0015\r\tyCM\u0016\u0003\u0003s\u0001B!a\u000f\u0002F5\u0011\u0011Q\b\u0006\u0005\u0003\u007f\t\t%A\u0005v]\u000eDWmY6fI*\u0019\u00111\t\u001a\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002H\u0005u\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dKN9Q\"a\u0013\u0002R\u0005]\u0003cA\u001e\u0002N%\u0019\u0011q\n\u001f\u0003\r=\u0013'.Z2u!\rY\u00141K\u0005\u0004\u0003+b$\u0001\u0003*v]:\f'\r\\3\u0011\t\u0005e\u0013qL\u0007\u0003\u00037R1!!\u0018*\u0003\u0015)H/\u001b7t\u0013\u0011\t\t'a\u0017\u0003\u000f1{wmZ5oO\u0006\u0011\u0011\u000e\u001a\t\u0004c\u0005\u001d\u0014bAA5e\t\u0019\u0011J\u001c;\u0002\u0011\t\u0014xn[3s\u0013\u0012\f!#Y4he\u0016<\u0017\r^3JI2,W*\u001a;feV\u0011\u0011\u0011\u000f\t\u0005\u0003g\n))\u0004\u0002\u0002v)!\u0011qOA=\u0003\u0011\u0019wN]3\u000b\t\u0005m\u0014QP\u0001\b[\u0016$(/[2t\u0015\u0011\ty(!!\u0002\re\fW.\\3s\u0015\t\t\u0019)A\u0002d_6LA!a\"\u0002v\t)Q*\u001a;fe\u0006\u0019\u0012mZ4sK\u001e\fG/Z%eY\u0016lU\r^3sA\u0005\u0019Bo\u001c;bY\"\u000bg\u000e\u001a7feRC'/Z1egV\u0011\u0011q\u0012\t\u0005\u0003#\u000by*\u0004\u0002\u0002\u0014*!\u0011QSAL\u0003\u0019\tGo\\7jG*!\u0011\u0011TAN\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0004\u0003;s\u0014\u0001B;uS2LA!!)\u0002\u0014\ni\u0011\t^8nS\u000eLe\u000e^3hKJ\fA\u0003^8uC2D\u0015M\u001c3mKJ$\u0006N]3bIN\u0004\u0013A\u0004:fcV,7\u000f^\"iC:tW\r\\\u000b\u0002\u0005\u0006y!/Z9vKN$8\t[1o]\u0016d\u0007%\u0001\u0003ba&\u001c\bcA\u0017\u00020&\u0019\u0011\u0011W\u0014\u0003#\u0005\u0003\u0018NU3rk\u0016\u001cH\u000fS1oI2,'/\u0001\u0003uS6,\u0007\u0003BA\\\u0003{k!!!/\u000b\t\u0005u\u00131\u0018\u0006\u0005\u0003\u000b\tI!\u0003\u0003\u0002@\u0006e&\u0001\u0002+j[\u0016\f\u0001B\\8eK:\u000bW.\u001a\u000b\u0013\u0003\u000b\f9-!3\u0002L\u00065\u0017qZAi\u0003'\f)\u000e\u0005\u0002.\u001b!9\u00111M\rA\u0002\u0005\u0015\u0004bBA63\u0001\u0007\u0011Q\r\u0005\b\u0003[J\u0002\u0019AA9\u0011\u001d\tY)\u0007a\u0001\u0003\u001fCa!!*\u001a\u0001\u0004\u0011\u0005bBAV3\u0001\u0007\u0011Q\u0016\u0005\b\u0003gK\u0002\u0019AA[\u0011%\t\t-\u0007I\u0001\u0002\u0004\t\t#\u0001\ttQV$Hm\\<o\u0007>l\u0007\u000f\\3uKV\u0011\u00111\u001c\t\u0005\u0003;\fy.\u0004\u0002\u0002\u0018&!\u0011\u0011]AL\u00059\u0019u.\u001e8u\t><h\u000eT1uG\"\f\u0011c\u001d5vi\u0012|wO\\\"p[BdW\r^3!+\u0005y\u0018!\u0004:fcV,7\u000f\u001e'pG\u0006d\u0007%A\u0004ti>\u0004\b/\u001a3\u0002\u0017M$x\u000e\u001d9fI~#S-\u001d\u000b\u00047\u0006=\bbB0 \u0003\u0003\u0005\rAV\u0001\tgR|\u0007\u000f]3eA!\u0012\u0001EY\u0001\u0004eVtG#A.\u0002!\r|W\u000e\u001d7fi\u0016\u001c\u0006.\u001e;e_^t\u0017\u0001B:u_B\f\u0001#\u001b8ji&\fG/Z*ikR$wn\u001e8\u0002\u001b\u0005<\u0018-\u001b;TQV$Hm\\<o\u0001")
public class KafkaRequestHandler
implements Runnable,
Logging {
    private final int id;
    private final int brokerId;
    private final Meter aggregateIdleMeter;
    private final AtomicInteger totalHandlerThreads;
    private final RequestChannel requestChannel;
    private final ApiRequestHandler apis;
    private final Time time;
    private final CountDownLatch shutdownComplete;
    private final RequestLocal requestLocal;
    private volatile boolean stopped;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String $lessinit$greater$default$8() {
        return "broker";
    }

    public static <T> Function1<T, BoxedUnit> wrapAsyncCallback(Function2<RequestLocal, T, BoxedUnit> asyncCompletionCallback, RequestLocal requestLocal) {
        return KafkaRequestHandler$.MODULE$.wrapAsyncCallback(asyncCompletionCallback, requestLocal);
    }

    public static void setBypassThreadCheck(boolean bypassCheck) {
        KafkaRequestHandler$.MODULE$.setBypassThreadCheck(bypassCheck);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Meter aggregateIdleMeter() {
        return this.aggregateIdleMeter;
    }

    public AtomicInteger totalHandlerThreads() {
        return this.totalHandlerThreads;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    private CountDownLatch shutdownComplete() {
        return this.shutdownComplete;
    }

    private RequestLocal requestLocal() {
        return this.requestLocal;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    @Override
    public void run() {
        KafkaRequestHandler$.MODULE$.kafka$server$KafkaRequestHandler$$threadRequestChannel().set(this.requestChannel());
        while (!this.stopped()) {
            long startSelectTime = this.time.nanoseconds();
            RequestChannel.BaseRequest req = this.requestChannel().receiveRequest(300L);
            long endTime = this.time.nanoseconds();
            long idleTime = endTime - startSelectTime;
            this.aggregateIdleMeter().mark(idleTime / (long)this.totalHandlerThreads().get());
            if (RequestChannel$ShutdownRequest$.MODULE$.equals(req)) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> "Kafka request handler " + $this.id + " on broker " + $this.brokerId + " received shut down command");
                this.completeShutdown();
                return;
            }
            if (req instanceof RequestChannel.CallbackRequest) {
                RequestChannel.CallbackRequest callbackRequest = (RequestChannel.CallbackRequest)req;
                RequestChannel.Request originalRequest = callbackRequest.originalRequest();
                try {
                    try {
                        if (originalRequest.callbackRequestDequeueTimeNanos().isDefined()) {
                            long prevCallbacksTimeNanos = BoxesRunTime.unboxToLong((Object)originalRequest.callbackRequestCompleteTimeNanos().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)) - BoxesRunTime.unboxToLong((Object)originalRequest.callbackRequestDequeueTimeNanos().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
                            originalRequest.callbackRequestCompleteTimeNanos_$eq((Option<Object>)None$.MODULE$);
                            originalRequest.callbackRequestDequeueTimeNanos_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)(this.time.nanoseconds() - prevCallbacksTimeNanos))));
                        } else {
                            originalRequest.callbackRequestDequeueTimeNanos_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.time.nanoseconds())));
                        }
                        KafkaRequestHandler$.MODULE$.kafka$server$KafkaRequestHandler$$threadCurrentRequest().set(originalRequest);
                        BoxedUnit cfr_ignored_0 = (BoxedUnit)callbackRequest.fun().apply((Object)this.requestLocal());
                    }
                    catch (FatalExitError e) {
                        this.completeShutdown();
                        Exit.exit((int)e.statusCode(), null);
                    }
                    catch (Throwable e) {
                        this.error((Function0<String>)(Function0 & Serializable)() -> "Exception when handling request", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    }
                    continue;
                }
                finally {
                    this.apis.tryCompleteActions();
                    if (originalRequest.callbackRequestCompleteTimeNanos().isEmpty()) {
                        originalRequest.callbackRequestCompleteTimeNanos_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.time.nanoseconds())));
                    }
                    KafkaRequestHandler$.MODULE$.kafka$server$KafkaRequestHandler$$threadCurrentRequest().remove();
                    continue;
                }
            }
            if (req instanceof RequestChannel.Request) {
                RequestChannel.Request request = (RequestChannel.Request)req;
                try {
                    try {
                        request.requestDequeueTimeNanos_$eq(endTime);
                        this.trace((Function0<String>)(Function0 & Serializable)() -> "Kafka request handler " + $this.id + " on broker " + $this.brokerId + " handling request " + request);
                        KafkaRequestHandler$.MODULE$.kafka$server$KafkaRequestHandler$$threadCurrentRequest().set(request);
                        this.apis.handle(request, this.requestLocal());
                    }
                    catch (FatalExitError e) {
                        this.completeShutdown();
                        Exit.exit((int)e.statusCode(), null);
                    }
                    catch (Throwable e) {
                        this.error((Function0<String>)(Function0 & Serializable)() -> "Exception when handling request", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    }
                    continue;
                }
                finally {
                    KafkaRequestHandler$.MODULE$.kafka$server$KafkaRequestHandler$$threadCurrentRequest().remove();
                    request.releaseBuffer();
                    continue;
                }
            }
            if (RequestChannel$WakeupRequest$.MODULE$.equals(req)) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> "Received a wakeup request outside of typical usage.");
                continue;
            }
            if (req == null) continue;
            throw new MatchError((Object)req);
        }
        this.completeShutdown();
    }

    private void completeShutdown() {
        this.requestLocal().close();
        KafkaRequestHandler$.MODULE$.kafka$server$KafkaRequestHandler$$threadRequestChannel().remove();
        this.shutdownComplete().countDown();
    }

    public void stop() {
        this.stopped_$eq(true);
    }

    public void initiateShutdown() {
        this.requestChannel().sendShutdownRequest();
    }

    public void awaitShutdown() {
        this.shutdownComplete().await();
    }

    public KafkaRequestHandler(int id, int brokerId, Meter aggregateIdleMeter, AtomicInteger totalHandlerThreads, RequestChannel requestChannel, ApiRequestHandler apis, Time time, String nodeName) {
        this.id = id;
        this.brokerId = brokerId;
        this.aggregateIdleMeter = aggregateIdleMeter;
        this.totalHandlerThreads = totalHandlerThreads;
        this.requestChannel = requestChannel;
        this.apis = apis;
        this.time = time;
        this.logIdent_$eq("[Kafka Request Handler " + id + " on " + StringOps$.MODULE$.capitalize$extension(Predef$.MODULE$.augmentString(nodeName)) + " " + brokerId + "], ");
        this.shutdownComplete = new CountDownLatch(1);
        this.requestLocal = RequestLocal.withThreadConfinedCaching();
        this.stopped = false;
    }
}

