/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.util;

import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.metadata.UserScramCredentialRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.metadata.KafkaConfigSchema;

public final class RecordRedactor {
    private final KafkaConfigSchema configSchema;

    public RecordRedactor(KafkaConfigSchema configSchema) {
        this.configSchema = configSchema;
    }

    public String toLoggableString(ApiMessage message) {
        MetadataRecordType type = MetadataRecordType.fromId(message.apiKey());
        switch (type) {
            case CONFIG_RECORD: {
                if (!this.configSchema.isSensitive((ConfigRecord)message)) {
                    return message.toString();
                }
                ConfigRecord duplicate = ((ConfigRecord)message).duplicate();
                duplicate.setValue("(redacted)");
                return duplicate.toString();
            }
            case USER_SCRAM_CREDENTIAL_RECORD: {
                UserScramCredentialRecord record = (UserScramCredentialRecord)message;
                return "UserScramCredentialRecord(name=" + (record.name() == null ? "null" : "'" + record.name() + "'") + ", mechanism=" + record.mechanism() + ", salt=(redacted), storedKey=(redacted), serverKey=(redacted), iterations=" + record.iterations() + ")";
            }
        }
        return message.toString();
    }
}

