/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.common.LogCleaningAbortedException;
import kafka.common.ThreadShutdownException;
import kafka.log.Cleaner;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.LogCleaner$;
import kafka.log.LogCleanerManager;
import kafka.log.LogCleaningException;
import kafka.log.LogToClean;
import kafka.log.PreCleanStats;
import kafka.log.UnifiedLog;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import kafka.utils.Pool;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.util.ShutdownableThread;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.OffsetMap;
import org.apache.kafka.storage.internals.log.SkimpyOffsetMap;
import org.apache.kafka.storage.internals.utils.Throttler;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0001\r\u0015e\u0001\u0002)R\u0001YC\u0001\"\u001b\u0001\u0003\u0002\u0003\u0006IA\u001b\u0005\tq\u0002\u0011)\u0019!C\u0001s\"I\u0011\u0011\u0003\u0001\u0003\u0002\u0003\u0006IA\u001f\u0005\u000b\u0003'\u0001!Q1A\u0005\u0002\u0005U\u0001BCA\u0019\u0001\t\u0005\t\u0015!\u0003\u0002\u0018!Q\u00111\u0007\u0001\u0003\u0006\u0004%\t!!\u000e\t\u0015\u0005u\u0002A!A!\u0002\u0013\t9\u0004\u0003\u0006\u0002@\u0001\u0011\t\u0011)A\u0005\u0003\u0003Bq!a\u0013\u0001\t\u0003\ti\u0005\u0003\u0006\u0002\\\u0001\u0011\r\u0011\"\u0001R\u0003;B\u0001\"!\u001c\u0001A\u0003%\u0011q\f\u0005\n\u0003_\u0002\u0001\u0019!C\u0005\u0003cB\u0011\"a\u001d\u0001\u0001\u0004%I!!\u001e\t\u000f\u0005\u0005\u0005\u0001)Q\u0005U\"Q\u00111\u0012\u0001C\u0002\u0013\u0005\u0011+!$\t\u0011\u0005U\u0005\u0001)A\u0005\u0003\u001fC!\"a&\u0001\u0005\u0004%\t!UAM\u0011!\t)\u000b\u0001Q\u0001\n\u0005m\u0005BCAT\u0001\t\u0007I\u0011A)\u0002*\"A!\u0011\u0010\u0001!\u0002\u0013\tY\u000b\u0003\u0005\u0003|\u0001!\t!\u0015B?\u0011!\u0011y\t\u0001C\u0001#\nE\u0005b\u0002BJ\u0001\u0011\u0005!q\u0006\u0005\t\u0005+\u0003\u0001\u0015\"\u0003\u00030!9!q\u0013\u0001\u0005\u0002\t=\u0002b\u0002BM\u0001\u0011\u0005!q\u0006\u0005\b\u00057\u0003A\u0011\tBO\u0011\u001d\u0011)\u000b\u0001C!\u0005OCqAa-\u0001\t\u0003\u0012)\fC\u0004\u0003>\u0002!\tAa0\t\u000f\t\r\u0007\u0001\"\u0001\u0003F\"I!Q\u001b\u0001\u0012\u0002\u0013\u0005!q\u001b\u0005\b\u0005[\u0004A\u0011\u0001Bx\u0011\u001d\u0011Y\u0010\u0001C\u0001\u0005{Dqaa\u0001\u0001\t\u0003\u0019)\u0001C\u0004\u0004\u0010\u0001!\ta!\u0005\t\u000f\rU\u0001\u0001\"\u0001\u0004\u0018!911\u0005\u0001\u0005\u0002\r\u0015\u0002\"CB\u0018\u0001E\u0005I\u0011AB\u0019\u0011\u001d\u0019)\u0004\u0001C\u0001\u0007oA\u0001b!\u0011\u0001\t\u0003\u0019\u0016\u0011\u000f\u0005\t\u0007\u0007\u0002A\u0011A)\u0003\u0012\u001a9\u00111\u0018\u0001\u0001#\u0006u\u0006BCAfW\t\u0005\t\u0015!\u0003\u0002N\"9\u00111J\u0016\u0005\u0002\u0005M\u0007bBAlW\u0011E\u0013\u0011\u001c\u0005\n\u0003c\\#\u0019!C\u0001\u0003gD\u0001\"a?,A\u0003%\u0011Q\u001f\u0005\n\u0003{\\\u0003\u0019!C\u0001\u0003\u007fD\u0011Ba\u0002,\u0001\u0004%\tA!\u0003\t\u0011\t51\u0006)Q\u0005\u0005\u0003A\u0011B!\u0005,\u0001\u0004%\tAa\u0005\t\u0013\tm1\u00061A\u0005\u0002\tu\u0001\u0002\u0003B\u0011W\u0001\u0006KA!\u0006\t\u000f\t\u00152\u0006\"\u0003\u0003(!9!QF\u0016\u0005B\t=\u0002b\u0002B\u0019W\u0011%!1\u0007\u0005\b\u0005wYC\u0011\u0002B\u001a\u0011\u001d\u0011ie\u000bC\u0005\u0005\u001fBqAa\u0017,\t\u0013\u0011ifB\u0004\u0004FEC\taa\u0012\u0007\rA\u000b\u0006\u0012AB%\u0011\u001d\tYE\u0010C\u0001\u0007\u0017B\u0011b!\u0014?\u0005\u0004%\tA!(\t\u0011\r=c\b)A\u0005\u0005?Cqa!\u0015?\t\u0003\u0019\u0019\u0006\u0003\u0006\u0004Xy\u0012\r\u0011\"\u0001R\u00073B\u0001b!\u001a?A\u0003%11\f\u0005\n\u0007Or$\u0019!C\u0005\u00073B\u0001b!\u001b?A\u0003%11\f\u0005\u000b\u0007Wr$\u0019!C\u0001#\u000ee\u0003\u0002CB7}\u0001\u0006Iaa\u0017\t\u0015\r=dH1A\u0005\u0002E\u001bI\u0006\u0003\u0005\u0004ry\u0002\u000b\u0011BB.\u0011%\u0019\u0019H\u0010b\u0001\n\u0013\u0019I\u0006\u0003\u0005\u0004vy\u0002\u000b\u0011BB.\u0011)\u00199H\u0010b\u0001\n\u0003\t6\u0011\u0010\u0005\t\u0007{r\u0004\u0015!\u0003\u0004|!I1q\u0010 \u0012\u0002\u0013\u00051\u0011\u0011\u0002\u000b\u0019><7\t\\3b]\u0016\u0014(B\u0001*T\u0003\rawn\u001a\u0006\u0002)\u0006)1.\u00194lC\u000e\u00011\u0003\u0002\u0001X;\u000e\u0004\"\u0001W.\u000e\u0003eS\u0011AW\u0001\u0006g\u000e\fG.Y\u0005\u00039f\u0013a!\u00118z%\u00164\u0007C\u00010b\u001b\u0005y&B\u00011T\u0003\u0015)H/\u001b7t\u0013\t\u0011wLA\u0004M_\u001e<\u0017N\\4\u0011\u0005\u0011<W\"A3\u000b\u0005\u0019\u001c\u0016AB:feZ,'/\u0003\u0002iK\n!\"I]8lKJ\u0014VmY8oM&<WO]1cY\u0016\fQ\"\u001b8ji&\fGnQ8oM&<\u0007CA6w\u001b\u0005a'B\u0001*n\u0015\tqw.A\u0005j]R,'O\\1mg*\u0011\u0001/]\u0001\bgR|'/Y4f\u0015\t!&O\u0003\u0002ti\u00061\u0011\r]1dQ\u0016T\u0011!^\u0001\u0004_J<\u0017BA<m\u00055\u0019E.Z1oKJ\u001cuN\u001c4jO\u00069An\\4ESJ\u001cX#\u0001>\u0011\tmt\u0018\u0011A\u0007\u0002y*\u0011Q0W\u0001\u000bG>dG.Z2uS>t\u0017BA@}\u0005\r\u0019V-\u001d\t\u0005\u0003\u0007\ti!\u0004\u0002\u0002\u0006)!\u0011qAA\u0005\u0003\tIwN\u0003\u0002\u0002\f\u0005!!.\u0019<b\u0013\u0011\ty!!\u0002\u0003\t\u0019KG.Z\u0001\tY><G)\u001b:tA\u0005!An\\4t+\t\t9\u0002E\u0004_\u00033\ti\"!\u000b\n\u0007\u0005mqL\u0001\u0003Q_>d\u0007\u0003BA\u0010\u0003Ki!!!\t\u000b\u0007\u0005\r\u0012/\u0001\u0004d_6lwN\\\u0005\u0005\u0003O\t\tC\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0011\t\u0005-\u0012QF\u0007\u0002#&\u0019\u0011qF)\u0003\u0015Us\u0017NZ5fI2{w-A\u0003m_\u001e\u001c\b%\u0001\u000bm_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\\\u000b\u0003\u0003o\u00012a[A\u001d\u0013\r\tY\u0004\u001c\u0002\u0015\u0019><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\u0002+1|w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3mA\u0005!A/[7f!\u0011\t\u0019%a\u0012\u000e\u0005\u0005\u0015#b\u00011\u0002\"%!\u0011\u0011JA#\u0005\u0011!\u0016.\\3\u0002\rqJg.\u001b;?)1\ty%!\u0015\u0002T\u0005U\u0013qKA-!\r\tY\u0003\u0001\u0005\u0006S&\u0001\rA\u001b\u0005\u0006q&\u0001\rA\u001f\u0005\b\u0003'I\u0001\u0019AA\f\u0011\u001d\t\u0019$\u0003a\u0001\u0003oA\u0011\"a\u0010\n!\u0003\u0005\r!!\u0011\u0002\u00195,GO]5dg\u001e\u0013x.\u001e9\u0016\u0005\u0005}\u0003\u0003BA1\u0003Sj!!a\u0019\u000b\t\u0005\u0015\u0014qM\u0001\b[\u0016$(/[2t\u0015\t1\u0017/\u0003\u0003\u0002l\u0005\r$!E&bM.\fW*\u001a;sS\u000e\u001cxI]8va\u0006iQ.\u001a;sS\u000e\u001cxI]8va\u0002\naaY8oM&<W#\u00016\u0002\u0015\r|gNZ5h?\u0012*\u0017\u000f\u0006\u0003\u0002x\u0005u\u0004c\u0001-\u0002z%\u0019\u00111P-\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003\u007fj\u0011\u0011!a\u0001U\u0006\u0019\u0001\u0010J\u0019\u0002\u000f\r|gNZ5hA!\u001aa\"!\"\u0011\u0007a\u000b9)C\u0002\u0002\nf\u0013\u0001B^8mCRLG.Z\u0001\u000fG2,\u0017M\\3s\u001b\u0006t\u0017mZ3s+\t\ty\t\u0005\u0003\u0002,\u0005E\u0015bAAJ#\n\tBj\\4DY\u0016\fg.\u001a:NC:\fw-\u001a:\u0002\u001f\rdW-\u00198fe6\u000bg.Y4fe\u0002\n\u0011\u0002\u001e5s_R$H.\u001a:\u0016\u0005\u0005m\u0005\u0003BAO\u0003Ck!!a(\u000b\u0005\u0001l\u0017\u0002BAR\u0003?\u0013\u0011\u0002\u00165s_R$H.\u001a:\u0002\u0015QD'o\u001c;uY\u0016\u0014\b%\u0001\u0005dY\u0016\fg.\u001a:t+\t\tY\u000b\u0005\u0004\u0002.\u0006M\u0016qW\u0007\u0003\u0003_S1!!-}\u0003\u001diW\u000f^1cY\u0016LA!!.\u00020\nY\u0011I\u001d:bs\n+hMZ3s!\r\tIlK\u0007\u0002\u0001\ti1\t\\3b]\u0016\u0014H\u000b\u001b:fC\u0012\u001cBaKA`;B!\u0011\u0011YAd\u001b\t\t\u0019M\u0003\u0003\u0002F\u0006\u001d\u0014\u0001B;uS2LA!!3\u0002D\n\u00112\u000b[;uI><h.\u00192mKRC'/Z1e\u0003!!\bN]3bI&#\u0007c\u0001-\u0002P&\u0019\u0011\u0011[-\u0003\u0007%sG\u000f\u0006\u0003\u00028\u0006U\u0007bBAf[\u0001\u0007\u0011QZ\u0001\u000bY><w-\u001a:OC6,WCAAn!\u0011\ti.a;\u000f\t\u0005}\u0017q\u001d\t\u0004\u0003CLVBAAr\u0015\r\t)/V\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005%\u0018,\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003[\fyO\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003SL\u0016aB2mK\u0006tWM]\u000b\u0003\u0003k\u0004B!a\u000b\u0002x&\u0019\u0011\u0011`)\u0003\u000f\rcW-\u00198fe\u0006A1\r\\3b]\u0016\u0014\b%A\u0005mCN$8\u000b^1ugV\u0011!\u0011\u0001\t\u0005\u0003W\u0011\u0019!C\u0002\u0003\u0006E\u0013Ab\u00117fC:,'o\u0015;biN\fQ\u0002\\1tiN#\u0018\r^:`I\u0015\fH\u0003BA<\u0005\u0017A\u0011\"a 3\u0003\u0003\u0005\rA!\u0001\u0002\u00151\f7\u000f^*uCR\u001c\b\u0005K\u00024\u0003\u000b\u000b\u0011\u0003\\1tiB\u0013Xm\u00117fC:\u001cF/\u0019;t+\t\u0011)\u0002\u0005\u0003\u0002,\t]\u0011b\u0001B\r#\ni\u0001K]3DY\u0016\fgn\u0015;biN\fQ\u0003\\1tiB\u0013Xm\u00117fC:\u001cF/\u0019;t?\u0012*\u0017\u000f\u0006\u0003\u0002x\t}\u0001\"CA@k\u0005\u0005\t\u0019\u0001B\u000b\u0003Ia\u0017m\u001d;Qe\u0016\u001cE.Z1o'R\fGo\u001d\u0011)\u0007Y\n))A\u0005dQ\u0016\u001c7\u000eR8oKR!\u0011q\u000fB\u0015\u0011\u001d\u0011Yc\u000ea\u0001\u0003;\ta\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\u0004e_^{'o\u001b\u000b\u0003\u0003o\nA\u0003\u001e:z\u00072,\u0017M\u001c$jYRD\u0017.Z:u\u0019><GC\u0001B\u001b!\rA&qG\u0005\u0004\u0005sI&a\u0002\"p_2,\u0017M\\\u0001\u0012G2,\u0017M\u001c$jYRD\u0017.Z:u\u0019><\u0007&\u0002\u001e\u0003@\t-\u0003#\u0002-\u0003B\t\u0015\u0013b\u0001B\"3\n1A\u000f\u001b:poN\u0004B!a\u000b\u0003H%\u0019!\u0011J)\u0003)1{wm\u00117fC:LgnZ#yG\u0016\u0004H/[8oG\t\u0011)%\u0001\u0005dY\u0016\fg\u000eT8h)\u0011\t9H!\u0015\t\u000f\tM3\b1\u0001\u0003V\u0005I1\r\\3b]\u0006\u0014G.\u001a\t\u0005\u0003W\u00119&C\u0002\u0003ZE\u0013!\u0002T8h)>\u001cE.Z1o\u0003-\u0011XmY8sIN#\u0018\r^:\u0015\u0019\u0005]$q\fB2\u0005O\u0012\tH!\u001e\t\u000f\t\u0005D\b1\u0001\u0002N\u0006\u0011\u0011\u000e\u001a\u0005\b\u0005Kb\u0004\u0019AAn\u0003\u0011q\u0017-\\3\t\u000f\t%D\b1\u0001\u0003l\u0005!aM]8n!\rA&QN\u0005\u0004\u0005_J&\u0001\u0002'p]\u001eDqAa\u001d=\u0001\u0004\u0011Y'\u0001\u0002u_\"9!q\u000f\u001fA\u0002\t\u0005\u0011!B:uCR\u001c\u0018!C2mK\u0006tWM]:!\u0003Ui\u0017\r_(wKJ\u001cE.Z1oKJ$\u0006N]3bIN$BAa \u0003\u0006B\u0019\u0001L!!\n\u0007\t\r\u0015L\u0001\u0004E_V\u0014G.\u001a\u0005\b\u0005\u000f+\u0002\u0019\u0001BE\u0003\u00051\u0007c\u0002-\u0003\f\u0006]&qP\u0005\u0004\u0005\u001bK&!\u0003$v]\u000e$\u0018n\u001c82\u0003=!W-\u00193UQJ,\u0017\rZ\"pk:$XCAAg\u0003\u001d\u0019H/\u0019:ukB\f\u0001c\u001d5vi\u0012|wO\\\"mK\u0006tWM]:\u0002\u0011MDW\u000f\u001e3po:\fQB]3n_Z,W*\u001a;sS\u000e\u001c\u0018!\u0006:fG>tg-[4ve\u0006\u0014G.Z\"p]\u001aLwm]\u000b\u0003\u0005?\u0003Ra\u001fBQ\u00037L1Aa)}\u0005\r\u0019V\r^\u0001\u0018m\u0006d\u0017\u000eZ1uKJ+7m\u001c8gS\u001e,(/\u0019;j_:$B!a\u001e\u0003*\"9!1\u0016\u000fA\u0002\t5\u0016!\u00038fo\u000e{gNZ5h!\r!'qV\u0005\u0004\u0005c+'aC&bM.\f7i\u001c8gS\u001e\f1B]3d_:4\u0017nZ;sKR1\u0011q\u000fB\\\u0005wCqA!/\u001e\u0001\u0004\u0011i+A\u0005pY\u0012\u001cuN\u001c4jO\"9!1V\u000fA\u0002\t5\u0016!D1c_J$8\t\\3b]&tw\r\u0006\u0003\u0002x\t\u0005\u0007b\u0002B\u0016=\u0001\u0007\u0011QD\u0001\u0012kB$\u0017\r^3DQ\u0016\u001c7\u000e]8j]R\u001cHCBA<\u0005\u000f\u0014Y\rC\u0004\u0003J~\u0001\r!!\u0001\u0002\u000f\u0011\fG/\u0019#je\"I!QZ\u0010\u0011\u0002\u0003\u0007!qZ\u0001\u0012a\u0006\u0014H/\u001b;j_:$vNU3n_Z,\u0007#\u0002-\u0003R\u0006u\u0011b\u0001Bj3\n1q\n\u001d;j_:\f1$\u001e9eCR,7\t[3dWB|\u0017N\u001c;tI\u0011,g-Y;mi\u0012\u0012TC\u0001BmU\u0011\u0011yMa7,\u0005\tu\u0007\u0003\u0002Bp\u0005Sl!A!9\u000b\t\t\r(Q]\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa:Z\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005W\u0014\tOA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f!#\u00197uKJ\u001c\u0005.Z2la>Lg\u000e\u001e#jeRA\u0011q\u000fBy\u0005g\u00149\u0010C\u0004\u0003,\u0005\u0002\r!!\b\t\u000f\tU\u0018\u00051\u0001\u0002\u0002\u0005a1o\\;sG\u0016dun\u001a#je\"9!\u0011`\u0011A\u0002\u0005\u0005\u0011A\u00033fgRdun\u001a#je\u0006\u0019\u0002.\u00198eY\u0016dun\u001a#je\u001a\u000b\u0017\u000e\\;sKR!\u0011q\u000fB\u0000\u0011\u001d\u0019\tA\ta\u0001\u00037\f1\u0001Z5s\u0003]i\u0017-\u001f2f)J,hnY1uK\u000eCWmY6q_&tG\u000f\u0006\u0005\u0002x\r\u001d1\u0011BB\u0006\u0011\u001d\u0011Im\ta\u0001\u0003\u0003AqAa\u000b$\u0001\u0004\ti\u0002C\u0004\u0004\u000e\r\u0002\rAa\u001b\u0002\r=4gm]3u\u0003U\t'm\u001c:u\u0003:$\u0007+Y;tK\u000ecW-\u00198j]\u001e$B!a\u001e\u0004\u0014!9!1\u0006\u0013A\u0002\u0005u\u0011A\u0004:fgVlWm\u00117fC:Lgn\u001a\u000b\u0005\u0003o\u001aI\u0002C\u0004\u0004\u001c\u0015\u0002\ra!\b\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]N\u0004Ra_B\u0010\u0003;I1a!\t}\u0005!IE/\u001a:bE2,\u0017\u0001D1xC&$8\t\\3b]\u0016$G\u0003\u0003B\u001b\u0007O\u0019Ica\u000b\t\u000f\t-b\u00051\u0001\u0002\u001e!91Q\u0002\u0014A\u0002\t-\u0004\"CB\u0017MA\u0005\t\u0019\u0001B6\u0003%i\u0017\r_,bSRl5/\u0001\fbo\u0006LGo\u00117fC:,G\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019\u0019D\u000b\u0003\u0003l\tm\u0017A\n9bkN,7\t\\3b]&twMR8s\u001d>t7i\\7qC\u000e$X\r\u001a)beRLG/[8ogR\u00111\u0011\b\t\u0006w\u000e}11\b\t\b1\u000eu\u0012QDA\u0015\u0013\r\u0019y$\u0017\u0002\u0007)V\u0004H.\u001a\u001a\u0002\u001b\r,(O]3oi\u000e{gNZ5h\u00031\u0019G.Z1oKJ\u001cu.\u001e8u\u0003)aunZ\"mK\u0006tWM\u001d\t\u0004\u0003Wq4C\u0001 X)\t\u00199%A\u000bSK\u000e|gNZ5hkJ\f'\r\\3D_:4\u0017nZ:\u0002-I+7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hg\u0002\nQb\u00197fC:,'oQ8oM&<Gc\u00016\u0004V!9\u0011q\u000e\"A\u0002\t5\u0016!J'bq\n+hMZ3s+RLG.\u001b>bi&|g\u000eU3sG\u0016tG/T3ue&\u001cg*Y7f+\t\u0019Y\u0006\u0005\u0003\u0004^\r\rTBAB0\u0015\u0011\u0019\t'!\u0003\u0002\t1\fgnZ\u0005\u0005\u0003[\u001cy&\u0001\u0014NCb\u0014UO\u001a4feV#\u0018\u000e\\5{CRLwN\u001c)fe\u000e,g\u000e^'fiJL7MT1nK\u0002\nad\u00117fC:,'OU3d_BL\b+\u001a:dK:$X*\u001a;sS\u000et\u0015-\\3\u0002?\rcW-\u00198feJ+7m\u001c9z!\u0016\u00148-\u001a8u\u001b\u0016$(/[2OC6,\u0007%\u0001\fNCb\u001cE.Z1o)&lW-T3ue&\u001cg*Y7f\u0003]i\u0015\r_\"mK\u0006tG+[7f\u001b\u0016$(/[2OC6,\u0007%A\u000fNCb\u001cu.\u001c9bGRLwN\u001c#fY\u0006LX*\u001a;sS\u000e\u001ch*Y7f\u0003yi\u0015\r_\"p[B\f7\r^5p]\u0012+G.Y=NKR\u0014\u0018nY:OC6,\u0007%A\rEK\u0006$G\u000b\u001b:fC\u0012\u001cu.\u001e8u\u001b\u0016$(/[2OC6,\u0017A\u0007#fC\u0012$\u0006N]3bI\u000e{WO\u001c;NKR\u0014\u0018n\u0019(b[\u0016\u0004\u0013aC'fiJL7MT1nKN,\"aa\u001f\u0011\u000bm\u0014\tka\u0017\u0002\u00195+GO]5d\u001d\u0006lWm\u001d\u0011\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\u0019\u0019I\u000b\u0003\u0002B\tm\u0007")
public class LogCleaner
implements Logging,
BrokerReconfigurable {
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, UnifiedLog> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    public final Time kafka$log$LogCleaner$$time;
    private final KafkaMetricsGroup metricsGroup;
    private volatile CleanerConfig kafka$log$LogCleaner$$config;
    private final LogCleanerManager cleanerManager;
    private final Throttler throttler;
    private final ArrayBuffer<CleanerThread> cleaners;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$5() {
        return LogCleaner$.MODULE$.$lessinit$greater$default$5();
    }

    public static CleanerConfig cleanerConfig(KafkaConfig kafkaConfig) {
        return LogCleaner$.MODULE$.cleanerConfig(kafkaConfig);
    }

    public static Set<String> ReconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, UnifiedLog> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    public CleanerConfig kafka$log$LogCleaner$$config() {
        return this.kafka$log$LogCleaner$$config;
    }

    private void kafka$log$LogCleaner$$config_$eq(CleanerConfig x$1) {
        this.kafka$log$LogCleaner$$config = x$1;
    }

    public LogCleanerManager cleanerManager() {
        return this.cleanerManager;
    }

    public Throttler throttler() {
        return this.throttler;
    }

    public ArrayBuffer<CleanerThread> cleaners() {
        return this.cleaners;
    }

    public double maxOverCleanerThreads(Function1<CleanerThread, Object> f) {
        return BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable & scala.Serializable)(max, thread) -> {
            double $anonfun$maxOverCleanerThreads$1_max = BoxesRunTime.unboxToDouble((Object)max);
            return BoxesRunTime.boxToDouble((double)package$.MODULE$.max($anonfun$maxOverCleanerThreads$1_max, BoxesRunTime.unboxToDouble((Object)f.apply(thread))));
        }));
    }

    public int deadThreadCount() {
        return this.cleaners().count((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isThreadFailed()));
    }

    public void startup() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting the log cleaner");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$log$LogCleaner$$config().numThreads).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            CleanerThread cleaner = new CleanerThread(i);
            this.cleaners().$plus$eq((Object)cleaner);
            cleaner.start();
        });
    }

    private void shutdownCleaners() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down the log cleaner.");
        this.cleaners().foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
            x$8.shutdown();
            return BoxedUnit.UNIT;
        });
        this.cleaners().clear();
    }

    public void shutdown() {
        try {
            this.shutdownCleaners();
        }
        finally {
            this.removeMetrics();
        }
    }

    public void removeMetrics() {
        LogCleaner$.MODULE$.MetricNames().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            LogCleaner.$anonfun$removeMetrics$1(this, x$1);
            return BoxedUnit.UNIT;
        });
        this.cleanerManager().removeMetrics();
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        int numThreads = LogCleaner$.MODULE$.cleanerConfig((KafkaConfig)newConfig).numThreads;
        int currentThreads = this.kafka$log$LogCleaner$$config().numThreads;
        if (numThreads < 1) {
            throw new ConfigException("Log cleaner threads should be at least 1");
        }
        if (numThreads < currentThreads / 2) {
            throw new ConfigException(new StringBuilder(74).append("Log cleaner threads cannot be reduced to less than half the current value ").append(currentThreads).toString());
        }
        if (numThreads > currentThreads * 2) {
            throw new ConfigException(new StringBuilder(78).append("Log cleaner threads cannot be increased to more than double the current value ").append(currentThreads).toString());
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        this.kafka$log$LogCleaner$$config_$eq(LogCleaner$.MODULE$.cleanerConfig(newConfig));
        double maxIoBytesPerSecond = this.kafka$log$LogCleaner$$config().maxIoBytesPerSecond;
        if (!BoxesRunTime.equals((Object)BoxesRunTime.boxToDouble((double)maxIoBytesPerSecond), (Object)oldConfig.logCleanerIoMaxBytesPerSecond())) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Updating logCleanerIoMaxBytesPerSecond: ").append(maxIoBytesPerSecond).toString());
            this.throttler().updateDesiredRatePerSec(maxIoBytesPerSecond);
        }
        this.shutdownCleaners();
        this.startup();
    }

    public void abortCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortCleaning(topicPartition);
    }

    public void updateCheckpoints(File dataDir, Option<TopicPartition> partitionToRemove) {
        Option<Tuple2<TopicPartition, Object>> x$3 = this.cleanerManager().updateCheckpoints$default$2();
        this.cleanerManager().updateCheckpoints(dataDir, x$3, partitionToRemove);
    }

    public Option<TopicPartition> updateCheckpoints$default$2() {
        return None$.MODULE$;
    }

    public void alterCheckpointDir(TopicPartition topicPartition, File sourceLogDir, File destLogDir) {
        this.cleanerManager().alterCheckpointDir(topicPartition, sourceLogDir, destLogDir);
    }

    public void handleLogDirFailure(String dir) {
        this.cleanerManager().handleLogDirFailure(dir);
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset) {
        this.cleanerManager().maybeTruncateCheckpoint(dataDir, topicPartition, offset);
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortAndPauseCleaning(topicPartition);
    }

    public void resumeCleaning(Iterable<TopicPartition> topicPartitions) {
        this.cleanerManager().resumeCleaning(topicPartitions);
    }

    public boolean awaitCleaned(TopicPartition topicPartition, long offset, long maxWaitMs) {
        long sleepTime;
        for (long remainingWaitMs = maxWaitMs; !this.isCleaned$1(topicPartition, offset) && remainingWaitMs > 0L; remainingWaitMs -= sleepTime) {
            sleepTime = package$.MODULE$.min(100L, remainingWaitMs);
            Thread.sleep(sleepTime);
        }
        return this.isCleaned$1(topicPartition, offset);
    }

    public long awaitCleaned$default$3() {
        return 60000L;
    }

    public Iterable<Tuple2<TopicPartition, UnifiedLog>> pauseCleaningForNonCompactedPartitions() {
        return this.cleanerManager().pauseCleaningForNonCompactedPartitions();
    }

    public CleanerConfig currentConfig() {
        return this.kafka$log$LogCleaner$$config();
    }

    public int cleanerCount() {
        return this.cleaners().size();
    }

    public static final /* synthetic */ double $anonfun$maxOverCleanerThreads$1(Function1 f$1, double max, CleanerThread thread) {
        return package$.MODULE$.max(max, BoxesRunTime.unboxToDouble((Object)f$1.apply((Object)thread)));
    }

    public static final /* synthetic */ double $anonfun$new$2(CleanerThread x$1) {
        return x$1.lastStats().bufferUtilization();
    }

    public static final /* synthetic */ int $anonfun$new$1(LogCleaner $this) {
        return (int)($this.maxOverCleanerThreads((Function1<CleanerThread, Object>)(Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$2(x$1))) * (double)100);
    }

    public static final /* synthetic */ int $anonfun$new$3(LogCleaner $this) {
        ArrayBuffer stats = (ArrayBuffer)$this.cleaners().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.lastStats(), ArrayBuffer$.MODULE$.canBuildFrom());
        double recopyRate = (double)BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.bytesWritten())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (double)package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.bytesRead())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), 1L);
        return (int)((double)100 * recopyRate);
    }

    public static final /* synthetic */ double $anonfun$new$8(CleanerThread x$5) {
        return x$5.lastStats().elapsedSecs();
    }

    public static final /* synthetic */ int $anonfun$new$7(LogCleaner $this) {
        return (int)$this.maxOverCleanerThreads((Function1<CleanerThread, Object>)(Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$8(x$5)));
    }

    public static final /* synthetic */ double $anonfun$new$10(CleanerThread x$6) {
        return x$6.lastPreCleanStats().maxCompactionDelayMs();
    }

    public static final /* synthetic */ int $anonfun$new$9(LogCleaner $this) {
        return (int)($this.maxOverCleanerThreads((Function1<CleanerThread, Object>)(Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$10(x$6))) / (double)1000);
    }

    public static final /* synthetic */ void $anonfun$removeMetrics$1(LogCleaner $this, String x$1) {
        $this.metricsGroup().removeMetric(x$1);
    }

    private final boolean isCleaned$1(TopicPartition topicPartition$1, long offset$1) {
        return BoxesRunTime.unboxToBoolean((Object)this.cleanerManager().allCleanerCheckpoints().get((Object)topicPartition$1).fold((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, (Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$9 -> x$9 >= offset$1));
    }

    public LogCleaner(CleanerConfig initialConfig, Seq<File> logDirs, Pool<TopicPartition, UnifiedLog> logs, LogDirFailureChannel logDirFailureChannel, Time time) {
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        this.kafka$log$LogCleaner$$time = time;
        Logging.$init$(this);
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.kafka$log$LogCleaner$$config = initialConfig;
        this.cleanerManager = new LogCleanerManager(logDirs, logs, logDirFailureChannel);
        this.throttler = new Throttler(this.kafka$log$LogCleaner$$config().maxIoBytesPerSecond, 300L, "cleaner-io", "bytes", time);
        this.cleaners = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.MaxBufferUtilizationPercentMetricName(), () -> BoxesRunTime.boxToInteger((int)LogCleaner.$anonfun$new$1(this)));
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.kafka$log$LogCleaner$$CleanerRecopyPercentMetricName(), () -> BoxesRunTime.boxToInteger((int)LogCleaner.$anonfun$new$3(this)));
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.MaxCleanTimeMetricName(), () -> BoxesRunTime.boxToInteger((int)LogCleaner.$anonfun$new$7(this)));
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.MaxCompactionDelayMetricsName(), () -> BoxesRunTime.boxToInteger((int)LogCleaner.$anonfun$new$9(this)));
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.kafka$log$LogCleaner$$DeadThreadCountMetricName(), () -> BoxesRunTime.boxToInteger((int)this.deadThreadCount()));
    }

    public class CleanerThread
    extends ShutdownableThread
    implements Logging {
        private final Cleaner cleaner;
        private volatile CleanerStats lastStats;
        private volatile PreCleanStats lastPreCleanStats;
        private Logger logger;
        private String logIdent;
        private volatile boolean bitmap$0;

        @Override
        public String msgWithLogIdent(String msg) {
            return Logging.msgWithLogIdent$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging.trace$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$(this, msg, e);
        }

        @Override
        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$(this);
        }

        @Override
        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$(this);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging.debug$(this, msg);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$(this, msg, e);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging.info$(this, msg);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$(this, msg, e);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging.warn$(this, msg);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$(this, msg, e);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging.error$(this, msg);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$(this, msg, e);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging.fatal$(this, msg);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$(this, msg, e);
        }

        private Logger logger$lzycompute() {
            synchronized (this) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        @Override
        public Logger logger() {
            if (!this.bitmap$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        @Override
        public String loggerName() {
            return LogCleaner.class.getName();
        }

        public Cleaner cleaner() {
            return this.cleaner;
        }

        public CleanerStats lastStats() {
            return this.lastStats;
        }

        public void lastStats_$eq(CleanerStats x$1) {
            this.lastStats = x$1;
        }

        public PreCleanStats lastPreCleanStats() {
            return this.lastPreCleanStats;
        }

        public void lastPreCleanStats_$eq(PreCleanStats x$1) {
            this.lastPreCleanStats = x$1;
        }

        private void checkDone(TopicPartition topicPartition) {
            if (!this.isRunning()) {
                throw new ThreadShutdownException();
            }
            this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().checkCleaningAborted(topicPartition);
        }

        public void doWork() {
            if (!this.tryCleanFilthiestLog()) {
                this.pause(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().backoffMs, TimeUnit.MILLISECONDS);
            }
            this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().maintainUncleanablePartitions();
        }

        private boolean tryCleanFilthiestLog() {
            try {
                return this.cleanFilthiestLog();
            }
            catch (LogCleaningException e) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Unexpected exception thrown when cleaning log ").append(e.log()).append(". Marking its partition (").append(e.log().topicPartition()).append(") as uncleanable").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().markPartitionUncleanable(e.log().parentDir(), e.log().topicPartition());
                return false;
            }
        }

        private boolean cleanFilthiestLog() throws LogCleaningException {
            boolean bl;
            PreCleanStats preCleanStats = new PreCleanStats();
            Option<LogToClean> ltc = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().grabFilthiestCompactedLog(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$time, preCleanStats);
            if (None$.MODULE$.equals(ltc)) {
                bl = false;
            } else if (ltc instanceof Some) {
                LogToClean cleanable = (LogToClean)((Some)ltc).value();
                this.lastPreCleanStats_$eq(preCleanStats);
                try {
                    this.cleanLog(cleanable);
                    bl = true;
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadShutdownException ? true : throwable instanceof ControlThrowable) {
                        throw throwable;
                    }
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        throw new LogCleaningException(cleanable.log(), exception.getMessage(), exception);
                    }
                    throw throwable;
                }
            } else {
                throw new MatchError(ltc);
            }
            boolean cleaned = bl;
            Iterable<Tuple2<TopicPartition, UnifiedLog>> deletable = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().deletableLogs();
            try {
                deletable.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)CleanerThread.$anonfun$cleanFilthiestLog$1(x0$1)));
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneDeleting((Iterable<TopicPartition>)((Iterable)deletable.map((Function1 & Serializable & scala.Serializable)x$10 -> (TopicPartition)x$10._1(), Iterable$.MODULE$.canBuildFrom())));
            }
            return cleaned;
        }

        /*
         * WARNING - void declaration
         */
        private void cleanLog(LogToClean cleanable) {
            long startOffset;
            long endOffset = startOffset = cleanable.firstDirtyOffset();
            try {
                try {
                    void var9_6;
                    void var7_5;
                    Tuple2<Object, CleanerStats> tuple2 = this.cleaner().clean(cleanable);
                    if (tuple2 == null) {
                        throw new MatchError(null);
                    }
                    long nextDirtyOffset = tuple2._1$mcJ$sp();
                    CleanerStats cleanerStats = (CleanerStats)tuple2._2();
                    endOffset = var7_5;
                    this.recordStats(this.cleaner().id(), cleanable.log().name(), startOffset, (long)var7_5, (CleanerStats)var9_6);
                }
                catch (LogCleaningAbortedException logCleaningAbortedException) {
                }
                catch (KafkaStorageException kafkaStorageException) {
                }
                catch (IOException e) {
                    String logDirectory = cleanable.log().parentDir();
                    String msg = new StringBuilder(54).append("Failed to clean up log for ").append(cleanable.topicPartition()).append(" in dir ").append(logDirectory).append(" due to IOException").toString();
                    this.kafka$log$LogCleaner$CleanerThread$$$outer().logDirFailureChannel().maybeAddOfflineLogDir(logDirectory, msg, e);
                }
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().parentDirFile(), endOffset);
            }
        }

        private void recordStats(int id, String name, long from, long to, CleanerStats stats) {
            this.lastStats_$eq(stats);
            String message = new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString("%n\tLog cleaner thread %d cleaned log %s (dirty section = [%d, %d])%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id), name, BoxesRunTime.boxToLong((long)from), BoxesRunTime.boxToLong((long)to)}))).append(new StringOps(Predef$.MODULE$.augmentString("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedSecs()), BoxesRunTime.boxToDouble((double)CleanerThread.mb$1((double)stats.bytesRead() / stats.elapsedSecs()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.mapBytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)(CleanerThread.mb$1(stats.mapBytesRead()) / stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tBuffer utilization: %.1f%%%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)100 * stats.bufferUtilization()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)(stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)(CleanerThread.mb$1(stats.bytesRead()) / (stats.elapsedSecs() - stats.elapsedIndexSecs()))), BoxesRunTime.boxToDouble((double)((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tStart size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToLong((long)stats.messagesRead())}))).append(new StringOps(Predef$.MODULE$.augmentString("\tEnd size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesWritten())), BoxesRunTime.boxToLong((long)stats.messagesWritten())}))).append(new StringOps(Predef$.MODULE$.augmentString("\t%.1f%% size reduction (%.1f%% fewer messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead()))), BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead())))}))).toString();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
            if (this.lastPreCleanStats().delayedPartitions() > 0) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("\tCleanable partitions: %d, Delayed partitions: %d, max delay: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.lastPreCleanStats().cleanablePartitions()), BoxesRunTime.boxToInteger((int)this.lastPreCleanStats().delayedPartitions()), BoxesRunTime.boxToLong((long)this.lastPreCleanStats().maxCompactionDelayMs())})));
            }
            if (stats.invalidMessagesRead() > 0L) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("\tFound %d invalid messages during compaction.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)stats.invalidMessagesRead())})));
                return;
            }
        }

        public /* synthetic */ LogCleaner kafka$log$LogCleaner$CleanerThread$$$outer() {
            return LogCleaner.this;
        }

        public static final /* synthetic */ int $anonfun$cleanFilthiestLog$1(Tuple2 x0$1) {
            if (x0$1 != null) {
                UnifiedLog log = (UnifiedLog)x0$1._2();
                try {
                    return log.deleteOldSegments();
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadShutdownException ? true : throwable instanceof ControlThrowable) {
                        throw throwable;
                    }
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        throw new LogCleaningException(log, exception.getMessage(), exception);
                    }
                    throw throwable;
                }
            }
            throw new MatchError(null);
        }

        private static final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public CleanerThread(int threadId) {
            if (LogCleaner.this == null) {
                throw null;
            }
            super(new StringBuilder(25).append("kafka-log-cleaner-thread-").append(threadId).toString(), false);
            Logging.$init$(this);
            this.logIdent_$eq(this.logPrefix);
            if (LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads > Integer.MAX_VALUE) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Cannot use more than 2G of cleaner buffer space per cleaner thread, ignoring excess buffer space...");
            }
            this.cleaner = new Cleaner(threadId, (OffsetMap)new SkimpyOffsetMap((int)package$.MODULE$.min(LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads, Integer.MAX_VALUE), LogCleaner.this.kafka$log$LogCleaner$$config().hashAlgorithm()), LogCleaner.this.kafka$log$LogCleaner$$config().ioBufferSize / LogCleaner.this.kafka$log$LogCleaner$$config().numThreads / 2, LogCleaner.this.kafka$log$LogCleaner$$config().maxMessageSize, LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferLoadFactor, LogCleaner.this.throttler(), LogCleaner.this.kafka$log$LogCleaner$$time, (Function1<TopicPartition, BoxedUnit>)(Function1 & Serializable & scala.Serializable)topicPartition -> {
                this.checkDone(topicPartition);
                return BoxedUnit.UNIT;
            });
            this.lastStats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
            this.lastPreCleanStats = new PreCleanStats();
        }
    }
}

