/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.ldap.sdk.schema.AttributeSyntaxDefinition;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldap.sdk.schema.MatchingRuleDefinition;
import com.unboundid.ldap.sdk.schema.NameFormDefinition;
import com.unboundid.ldap.sdk.schema.ObjectClassDefinition;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.OID;
import com.unboundid.util.OIDRegistryItem;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONObjectReader;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class OIDRegistry
implements Serializable {
    @NotNull
    private static final AtomicReference<OIDRegistry> DEFAULT_INSTANCE = new AtomicReference();
    @NotNull
    private static final String OID_REGISTRY_JSON_RESOURCE_NAME = "com/unboundid/util/oid-registry.json";
    @NotNull
    private static final String X_ORIGIN_EXTENSION_NAME = "X-ORIGIN";
    private static final long serialVersionUID = 867525903925430865L;
    @NotNull
    private final Map<OID, OIDRegistryItem> items;

    private OIDRegistry(@NotNull Map<OID, OIDRegistryItem> items) {
        this.items = items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static OIDRegistry getDefault() {
        OIDRegistry oidRegistry = DEFAULT_INSTANCE.get();
        if (oidRegistry == null) {
            AtomicReference<OIDRegistry> atomicReference = DEFAULT_INSTANCE;
            synchronized (atomicReference) {
                oidRegistry = DEFAULT_INSTANCE.get();
                if (oidRegistry == null) {
                    TreeMap<OID, OIDRegistryItem> items;
                    block36: {
                        items = new TreeMap<OID, OIDRegistryItem>();
                        try (InputStream inputStream = OIDRegistry.class.getClassLoader().getResourceAsStream(OID_REGISTRY_JSON_RESOURCE_NAME);){
                            JSONObjectReader jsonObjectReader = new JSONObjectReader(inputStream);
                            Throwable throwable = null;
                            block25: while (true) {
                                try {
                                    while (true) {
                                        JSONObject o;
                                        if ((o = jsonObjectReader.readObject()) == null) {
                                            break block36;
                                        }
                                        try {
                                            OIDRegistryItem item = new OIDRegistryItem(o);
                                            items.put(new OID(item.getOID()), item);
                                            continue block25;
                                        }
                                        catch (Exception e) {
                                            Debug.debugException(e);
                                            continue;
                                        }
                                        break;
                                    }
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                            }
                            finally {
                                if (jsonObjectReader != null) {
                                    if (throwable != null) {
                                        try {
                                            jsonObjectReader.close();
                                        }
                                        catch (Throwable throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                    } else {
                                        jsonObjectReader.close();
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            Debug.debugException(e);
                        }
                    }
                    oidRegistry = new OIDRegistry(Collections.unmodifiableMap(items));
                    DEFAULT_INSTANCE.set(oidRegistry);
                }
            }
        }
        return oidRegistry;
    }

    @NotNull
    public OIDRegistry withSchema(@NotNull Schema schema) {
        OID oid;
        String oidString;
        TreeMap<OID, OIDRegistryItem> newItems = new TreeMap<OID, OIDRegistryItem>(this.items);
        for (AttributeSyntaxDefinition syntax : schema.getAttributeSyntaxes()) {
            oidString = syntax.getOID();
            oid = new OID(syntax.getOID());
            if (newItems.containsKey(oid)) continue;
            String name = syntax.getDescription();
            if (name == null) {
                name = oidString;
            }
            newItems.put(oid, new OIDRegistryItem(syntax.getOID(), name, "Attribute Syntax", OIDRegistry.getOrigin(syntax.getExtensions()), null));
        }
        for (MatchingRuleDefinition matchingRule : schema.getMatchingRules()) {
            oidString = matchingRule.getOID();
            oid = new OID(matchingRule.getOID());
            if (newItems.containsKey(oid)) continue;
            newItems.put(oid, new OIDRegistryItem(matchingRule.getOID(), matchingRule.getNameOrOID(), "Matching Rule", OIDRegistry.getOrigin(matchingRule.getExtensions()), null));
        }
        for (AttributeTypeDefinition attributeType : schema.getAttributeTypes()) {
            oidString = attributeType.getOID();
            oid = new OID(attributeType.getOID());
            if (newItems.containsKey(oid)) continue;
            newItems.put(oid, new OIDRegistryItem(attributeType.getOID(), attributeType.getNameOrOID(), "Attribute Type", OIDRegistry.getOrigin(attributeType.getExtensions()), null));
        }
        for (ObjectClassDefinition objectClass : schema.getObjectClasses()) {
            oidString = objectClass.getOID();
            oid = new OID(objectClass.getOID());
            if (newItems.containsKey(oid)) continue;
            newItems.put(oid, new OIDRegistryItem(objectClass.getOID(), objectClass.getNameOrOID(), "Object Class", OIDRegistry.getOrigin(objectClass.getExtensions()), null));
        }
        for (NameFormDefinition nameForm : schema.getNameForms()) {
            oidString = nameForm.getOID();
            oid = new OID(nameForm.getOID());
            if (newItems.containsKey(oid)) continue;
            newItems.put(oid, new OIDRegistryItem(nameForm.getOID(), nameForm.getNameOrOID(), "Name Form", OIDRegistry.getOrigin(nameForm.getExtensions()), null));
        }
        return new OIDRegistry(Collections.unmodifiableMap(newItems));
    }

    @Nullable
    private static String getOrigin(@NotNull Map<String, String[]> extensions) {
        String[] values = extensions.get(X_ORIGIN_EXTENSION_NAME);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    @NotNull
    public Map<OID, OIDRegistryItem> getItems() {
        return this.items;
    }

    @Nullable
    public OIDRegistryItem get(@NotNull String oid) {
        return this.get(new OID(oid));
    }

    @Nullable
    public OIDRegistryItem get(@NotNull OID oid) {
        return this.items.get(oid);
    }
}

