/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.ldap.sdk.unboundidds.extensions.PasswordPolicyStateExtendedResult;
import com.unboundid.ldap.sdk.unboundidds.extensions.PasswordPolicyStateOperation;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class PasswordPolicyStateExtendedRequest
extends ExtendedRequest {
    @NotNull
    public static final String PASSWORD_POLICY_STATE_REQUEST_OID = "1.3.6.1.4.1.30221.1.6.1";
    private static final long serialVersionUID = -1644137695182620213L;
    @NotNull
    private final PasswordPolicyStateOperation[] operations;
    @NotNull
    private final String userDN;

    public PasswordPolicyStateExtendedRequest(@NotNull String userDN, PasswordPolicyStateOperation ... operations) {
        this(userDN, (Control[])null, operations);
    }

    public PasswordPolicyStateExtendedRequest(@NotNull String userDN, @Nullable Control[] controls, PasswordPolicyStateOperation ... operations) {
        super(PASSWORD_POLICY_STATE_REQUEST_OID, PasswordPolicyStateExtendedRequest.encodeValue(userDN, operations), controls);
        this.userDN = userDN;
        this.operations = operations;
    }

    public PasswordPolicyStateExtendedRequest(@NotNull ExtendedRequest extendedRequest) throws LDAPException {
        super(extendedRequest);
        ASN1Element[] elements;
        ASN1OctetString value = extendedRequest.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_PWP_STATE_REQUEST_NO_VALUE.get());
        }
        try {
            ASN1Element valueElement = ASN1Element.decode(value.getValue());
            elements = ASN1Sequence.decodeAsSequence(valueElement).elements();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_PWP_STATE_REQUEST_VALUE_NOT_SEQUENCE.get(e), e);
        }
        if (elements.length < 1 || elements.length > 2) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_PWP_STATE_REQUEST_INVALID_ELEMENT_COUNT.get(elements.length));
        }
        this.userDN = ASN1OctetString.decodeAsOctetString(elements[0]).stringValue();
        if (elements.length == 1) {
            this.operations = new PasswordPolicyStateOperation[0];
        } else {
            try {
                ASN1Element[] opElements = ASN1Sequence.decodeAsSequence(elements[1]).elements();
                this.operations = new PasswordPolicyStateOperation[opElements.length];
                for (int i = 0; i < opElements.length; ++i) {
                    this.operations[i] = PasswordPolicyStateOperation.decode(opElements[i]);
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_PWP_STATE_REQUEST_CANNOT_DECODE_OPS.get(e), e);
            }
        }
    }

    @NotNull
    private static ASN1OctetString encodeValue(@NotNull String userDN, @Nullable PasswordPolicyStateOperation[] operations) {
        ASN1Element[] elements;
        if (operations == null || operations.length == 0) {
            elements = new ASN1Element[]{new ASN1OctetString(userDN)};
        } else {
            ASN1Element[] opElements = new ASN1Element[operations.length];
            for (int i = 0; i < operations.length; ++i) {
                opElements[i] = operations[i].encode();
            }
            elements = new ASN1Element[]{new ASN1OctetString(userDN), new ASN1Sequence(opElements)};
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    @NotNull
    public String getUserDN() {
        return this.userDN;
    }

    @NotNull
    public PasswordPolicyStateOperation[] getOperations() {
        return this.operations;
    }

    @Override
    @NotNull
    public PasswordPolicyStateExtendedResult process(@NotNull LDAPConnection connection, int depth) throws LDAPException {
        ExtendedResult extendedResponse = super.process(connection, depth);
        return new PasswordPolicyStateExtendedResult(extendedResponse);
    }

    @Override
    @NotNull
    public PasswordPolicyStateExtendedRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    @NotNull
    public PasswordPolicyStateExtendedRequest duplicate(@Nullable Control[] controls) {
        PasswordPolicyStateExtendedRequest r = new PasswordPolicyStateExtendedRequest(this.userDN, controls, this.operations);
        r.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        r.setIntermediateResponseListener(this.getIntermediateResponseListener());
        r.setReferralDepth(this.getReferralDepth());
        r.setReferralConnector(this.getReferralConnectorInternal());
        return r;
    }

    @Override
    @NotNull
    public String getExtendedRequestName() {
        return ExtOpMessages.INFO_EXTENDED_REQUEST_NAME_PW_POLICY_STATE.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        Control[] controls;
        buffer.append("PasswordPolicyStateExtendedRequest(userDN='");
        buffer.append(this.userDN);
        if (this.operations.length > 0) {
            buffer.append("', operations={");
            for (int i = 0; i < this.operations.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                this.operations[i].toString(buffer);
            }
            buffer.append('}');
        }
        if ((controls = this.getControls()).length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

