/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.mailbox;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import org.apache.james.adapter.mailbox.ACLUsernameChangeTaskStep;
import org.apache.james.adapter.mailbox.DelegationStoreAuthorizator;
import org.apache.james.adapter.mailbox.MailboxUserDeletionTaskStep;
import org.apache.james.adapter.mailbox.MailboxUsernameChangeTaskStep;
import org.apache.james.adapter.mailbox.QuotaUsernameChangeTaskStep;
import org.apache.james.adapter.mailbox.UserRepositoryAuthenticator;
import org.apache.james.adapter.mailbox.UserRepositoryAuthorizator;
import org.apache.james.backends.postgres.PostgresDataDefinition;
import org.apache.james.blob.api.BlobReferenceSource;
import org.apache.james.events.EventListener;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.eventstore.dto.EventDTO;
import org.apache.james.eventsourcing.eventstore.dto.EventDTOModule;
import org.apache.james.mailbox.AttachmentContentLoader;
import org.apache.james.mailbox.AttachmentIdFactory;
import org.apache.james.mailbox.AttachmentManager;
import org.apache.james.mailbox.Authenticator;
import org.apache.james.mailbox.Authorizator;
import org.apache.james.mailbox.MailboxCounterCorrector;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.RightManager;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.StringBackedAttachmentIdFactory;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.acl.MailboxACLResolver;
import org.apache.james.mailbox.acl.UnionMailboxACLResolver;
import org.apache.james.mailbox.indexer.MessageIdReIndexer;
import org.apache.james.mailbox.indexer.ReIndexer;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.postgres.DeleteMessageListener;
import org.apache.james.mailbox.postgres.PostgresMailboxAggregateDataDefinition;
import org.apache.james.mailbox.postgres.PostgresMailboxId;
import org.apache.james.mailbox.postgres.PostgresMailboxManager;
import org.apache.james.mailbox.postgres.PostgresMailboxSessionMapperFactory;
import org.apache.james.mailbox.postgres.PostgresMessageId;
import org.apache.james.mailbox.postgres.PostgresThreadIdGuessingAlgorithm;
import org.apache.james.mailbox.postgres.mail.PostgresAttachmentBlobReferenceSource;
import org.apache.james.mailbox.postgres.mail.PostgresMessageBlobReferenceSource;
import org.apache.james.mailbox.postgres.mail.dao.PostgresMessageDAO;
import org.apache.james.mailbox.postgres.mail.eventsourcing.acl.ACLModule;
import org.apache.james.mailbox.store.MailboxManagerConfiguration;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.NoMailboxPathLocker;
import org.apache.james.mailbox.store.SessionProviderImpl;
import org.apache.james.mailbox.store.StoreAttachmentManager;
import org.apache.james.mailbox.store.StoreMailboxManager;
import org.apache.james.mailbox.store.StoreMessageIdManager;
import org.apache.james.mailbox.store.StoreRightManager;
import org.apache.james.mailbox.store.StoreSubscriptionManager;
import org.apache.james.mailbox.store.event.MailboxAnnotationListener;
import org.apache.james.mailbox.store.event.MailboxSubscriptionListener;
import org.apache.james.mailbox.store.mail.AttachmentIdAssignationStrategy;
import org.apache.james.mailbox.store.mail.AttachmentMapperFactory;
import org.apache.james.mailbox.store.mail.MailboxMapperFactory;
import org.apache.james.mailbox.store.mail.MessageMapperFactory;
import org.apache.james.mailbox.store.mail.ThreadIdGuessingAlgorithm;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;
import org.apache.james.mailbox.store.mail.model.impl.MessageParserImpl;
import org.apache.james.mailbox.store.user.SubscriptionMapperFactory;
import org.apache.james.modules.data.PostgresCommonModule;
import org.apache.james.modules.data.PostgresQuotaGuiceModule;
import org.apache.james.modules.mailbox.PostgresMailboxQuotaModule;
import org.apache.james.user.api.DeleteUserDataTaskStep;
import org.apache.james.user.api.UsernameChangeTaskStep;
import org.apache.james.utils.MailboxManagerDefinition;
import org.apache.mailbox.tools.indexer.MessageIdReIndexerImpl;
import org.apache.mailbox.tools.indexer.ReIndexerImpl;

public class PostgresMailboxModule
extends AbstractModule {
    protected void configure() {
        this.install((Module)new PostgresCommonModule());
        Multibinder postgresDataDefinitions = Multibinder.newSetBinder((Binder)this.binder(), PostgresDataDefinition.class);
        postgresDataDefinitions.addBinding().toInstance((Object)PostgresMailboxAggregateDataDefinition.MODULE);
        this.install((Module)new PostgresQuotaGuiceModule());
        this.install((Module)new PostgresMailboxQuotaModule());
        this.bind(PostgresMailboxSessionMapperFactory.class).in(Scopes.SINGLETON);
        this.bind(PostgresMailboxManager.class).in(Scopes.SINGLETON);
        this.bind(NoMailboxPathLocker.class).in(Scopes.SINGLETON);
        this.bind(StoreSubscriptionManager.class).in(Scopes.SINGLETON);
        this.bind(UserRepositoryAuthenticator.class).in(Scopes.SINGLETON);
        this.bind(UserRepositoryAuthorizator.class).in(Scopes.SINGLETON);
        this.bind(UnionMailboxACLResolver.class).in(Scopes.SINGLETON);
        this.bind(PostgresMessageId.Factory.class).in(Scopes.SINGLETON);
        this.bind(PostgresThreadIdGuessingAlgorithm.class).in(Scopes.SINGLETON);
        this.bind(ReIndexerImpl.class).in(Scopes.SINGLETON);
        this.bind(SessionProviderImpl.class).in(Scopes.SINGLETON);
        this.bind(StoreMessageIdManager.class).in(Scopes.SINGLETON);
        this.bind(StoreRightManager.class).in(Scopes.SINGLETON);
        this.bind(SubscriptionMapperFactory.class).to(PostgresMailboxSessionMapperFactory.class);
        this.bind(MessageMapperFactory.class).to(PostgresMailboxSessionMapperFactory.class);
        this.bind(MailboxMapperFactory.class).to(PostgresMailboxSessionMapperFactory.class);
        this.bind(MailboxSessionMapperFactory.class).to(PostgresMailboxSessionMapperFactory.class);
        this.bind(MessageId.Factory.class).to(PostgresMessageId.Factory.class);
        this.bind(ThreadIdGuessingAlgorithm.class).to(PostgresThreadIdGuessingAlgorithm.class);
        this.bind(SubscriptionManager.class).to(StoreSubscriptionManager.class);
        this.bind(MailboxPathLocker.class).to(NoMailboxPathLocker.class);
        this.bind(Authenticator.class).to(UserRepositoryAuthenticator.class);
        this.bind(MailboxManager.class).to(PostgresMailboxManager.class);
        this.bind(StoreMailboxManager.class).to(PostgresMailboxManager.class);
        this.bind(SessionProvider.class).to(SessionProviderImpl.class);
        this.bind(Authorizator.class).to(DelegationStoreAuthorizator.class);
        this.bind(MailboxId.Factory.class).to(PostgresMailboxId.Factory.class);
        this.bind(MailboxACLResolver.class).to(UnionMailboxACLResolver.class);
        this.bind(MessageIdManager.class).to(StoreMessageIdManager.class);
        this.bind(RightManager.class).to(StoreRightManager.class);
        this.bind(AttachmentIdFactory.class).to(StringBackedAttachmentIdFactory.class);
        this.bind(AttachmentManager.class).to(StoreAttachmentManager.class);
        this.bind(AttachmentContentLoader.class).to(AttachmentManager.class);
        this.bind(AttachmentMapperFactory.class).to(PostgresMailboxSessionMapperFactory.class);
        this.bind(MailboxCounterCorrector.class).toInstance((Object)MailboxCounterCorrector.DEFAULT);
        this.bind(MessageParser.class).toInstance((Object)new MessageParserImpl());
        this.bind(AttachmentIdAssignationStrategy.class).to(AttachmentIdAssignationStrategy.Default.class);
        this.bind(ReIndexer.class).to(ReIndexerImpl.class);
        this.bind(MessageIdReIndexer.class).to(MessageIdReIndexerImpl.class);
        this.bind(PostgresMessageDAO.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)this.binder(), MailboxManagerDefinition.class).addBinding().to(PostgresMailboxManagerDefinition.class);
        Multibinder.newSetBinder((Binder)this.binder(), EventListener.GroupEventListener.class).addBinding().to(MailboxAnnotationListener.class);
        Multibinder.newSetBinder((Binder)this.binder(), EventListener.GroupEventListener.class).addBinding().to(MailboxSubscriptionListener.class);
        Multibinder.newSetBinder((Binder)this.binder(), EventListener.ReactiveGroupEventListener.class).addBinding().to(DeleteMessageListener.class);
        Multibinder.newSetBinder((Binder)this.binder(), DeleteMessageListener.DeletionCallback.class);
        this.bind(MailboxManager.class).annotatedWith((Annotation)Names.named((String)"mailboxmanager")).to(MailboxManager.class);
        this.bind(MailboxManagerConfiguration.class).toInstance((Object)MailboxManagerConfiguration.DEFAULT);
        Multibinder usernameChangeTaskStepMultibinder = Multibinder.newSetBinder((Binder)this.binder(), UsernameChangeTaskStep.class);
        usernameChangeTaskStepMultibinder.addBinding().to(MailboxUsernameChangeTaskStep.class);
        usernameChangeTaskStepMultibinder.addBinding().to(ACLUsernameChangeTaskStep.class);
        usernameChangeTaskStepMultibinder.addBinding().to(QuotaUsernameChangeTaskStep.class);
        Multibinder deleteUserDataTaskStepMultibinder = Multibinder.newSetBinder((Binder)this.binder(), DeleteUserDataTaskStep.class);
        deleteUserDataTaskStepMultibinder.addBinding().to(MailboxUserDeletionTaskStep.class);
        Multibinder blobReferenceSourceMultibinder = Multibinder.newSetBinder((Binder)this.binder(), BlobReferenceSource.class);
        blobReferenceSourceMultibinder.addBinding().to(PostgresMessageBlobReferenceSource.class);
        blobReferenceSourceMultibinder.addBinding().to(PostgresAttachmentBlobReferenceSource.class);
        Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<EventDTOModule<? extends Event, ? extends EventDTO>>(this){}).addBinding().toInstance((Object)ACLModule.ACL_UPDATE);
    }

    @Singleton
    private static class PostgresMailboxManagerDefinition
    extends MailboxManagerDefinition {
        @Inject
        private PostgresMailboxManagerDefinition(PostgresMailboxManager manager) {
            super("postgres-mailboxmanager", (MailboxManager)manager);
        }
    }
}

