/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.misc.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterCodecReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NoMergePolicy;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.NamedThreadFactory;

public class IndexRearranger {
    protected final Directory input;
    protected final Directory output;
    protected final IndexWriterConfig config;
    protected final List<DocumentSelector> segmentSelectors;
    protected final DocumentSelector deletedDocsSelector;

    public IndexRearranger(Directory input, Directory output, IndexWriterConfig config, List<DocumentSelector> segmentSelectors, DocumentSelector deletedDocsSelector) {
        this.input = input;
        this.output = output;
        this.config = config;
        this.segmentSelectors = segmentSelectors;
        this.deletedDocsSelector = deletedDocsSelector;
    }

    public IndexRearranger(Directory input, Directory output, IndexWriterConfig config, List<DocumentSelector> segmentSelectors) {
        this(input, output, config, segmentSelectors, null);
    }

    public void execute() throws Exception {
        DirectoryReader reader;
        ExecutorService executor = Executors.newFixedThreadPool(Math.min(Runtime.getRuntime().availableProcessors(), this.segmentSelectors.size()), (ThreadFactory)new NamedThreadFactory("rearranger"));
        IndexWriterConfig createSegmentsConfig = new IndexWriterConfig(this.config.getAnalyzer());
        IndexWriterConfig applyDeletesConfig = new IndexWriterConfig(this.config.getAnalyzer());
        createSegmentsConfig.setMergePolicy(NoMergePolicy.INSTANCE);
        applyDeletesConfig.setMergePolicy(NoMergePolicy.INSTANCE);
        try (IndexWriter writer = new IndexWriter(this.output, createSegmentsConfig);){
            reader = DirectoryReader.open((Directory)this.input);
            try {
                IndexRearranger.createRearrangedIndex(writer, (IndexReader)reader, this.segmentSelectors, executor);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        IndexRearranger.finalizeRearrange(this.output, this.segmentSelectors);
        writer = new IndexWriter(this.output, applyDeletesConfig);
        try {
            reader = DirectoryReader.open((IndexWriter)writer);
            try {
                IndexRearranger.applyDeletes(writer, (IndexReader)reader, this.deletedDocsSelector, executor);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        finally {
            writer.close();
        }
        executor.shutdown();
    }

    private static void finalizeRearrange(Directory output, List<DocumentSelector> segmentSelectors) throws IOException {
        ArrayList<SegmentCommitInfo> ordered = new ArrayList<SegmentCommitInfo>();
        try (DirectoryReader reader = DirectoryReader.open((Directory)output);){
            for (DocumentSelector ds : segmentSelectors) {
                int foundLeaf = -1;
                for (LeafReaderContext context : reader.leaves()) {
                    SegmentReader sr = (SegmentReader)context.reader();
                    int docFound = ds.getFilteredDocs((CodecReader)sr).nextSetBit(0);
                    if (docFound == Integer.MAX_VALUE) continue;
                    if (foundLeaf != -1) {
                        throw new IllegalStateException("Document selector " + String.valueOf(ds) + " has matched more than 1 segments. Matched segments order: " + foundLeaf + ", " + context.ord);
                    }
                    foundLeaf = context.ord;
                    ordered.add(sr.getSegmentInfo());
                }
                assert (foundLeaf != -1);
            }
        }
        SegmentInfos sis = SegmentInfos.readLatestCommit((Directory)output);
        sis.clear();
        sis.addAll(ordered);
        sis.commit(output);
    }

    private static void createRearrangedIndex(IndexWriter writer, IndexReader reader, List<DocumentSelector> selectors, ExecutorService executor) throws ExecutionException, InterruptedException {
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        for (DocumentSelector documentSelector : selectors) {
            Callable<Void> addSegment = () -> {
                IndexRearranger.addOneSegment(writer, reader, selector);
                return null;
            };
            futures.add(executor.submit(addSegment));
        }
        for (Future future : futures) {
            future.get();
        }
    }

    private static void addOneSegment(IndexWriter writer, IndexReader reader, DocumentSelector selector) throws IOException {
        CodecReader[] readers = new CodecReader[reader.leaves().size()];
        for (LeafReaderContext context : reader.leaves()) {
            readers[context.ord] = new DocSelectorFilteredCodecReader((CodecReader)context.reader(), selector);
        }
        writer.addIndexes(readers);
    }

    private static void applyDeletes(IndexWriter writer, IndexReader reader, DocumentSelector selector, ExecutorService executor) throws ExecutionException, InterruptedException {
        if (selector == null) {
            return;
        }
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        for (LeafReaderContext leafReaderContext : reader.leaves()) {
            Callable<Void> applyDeletesToSegment = () -> {
                IndexRearranger.applyDeletesToOneSegment(writer, (CodecReader)context.reader(), selector);
                return null;
            };
            futures.add(executor.submit(applyDeletesToSegment));
        }
        for (Future future : futures) {
            future.get();
        }
    }

    private static void applyDeletesToOneSegment(IndexWriter writer, CodecReader segmentReader, DocumentSelector selector) throws IOException {
        BitSet deletedDocs = selector.getFilteredDocs(segmentReader);
        for (int docid = 0; docid < segmentReader.maxDoc(); ++docid) {
            if (!deletedDocs.get(docid) || writer.tryDeleteDocument((IndexReader)segmentReader, docid) != -1L) continue;
            throw new IllegalStateException("tryDeleteDocument has failed. This should never happen, since merging is disabled.");
        }
    }

    public static interface DocumentSelector {
        public BitSet getFilteredDocs(CodecReader var1) throws IOException;
    }

    private static class DocSelectorFilteredCodecReader
    extends FilterCodecReader {
        BitSet filteredLiveDocs;
        int numDocs;

        public DocSelectorFilteredCodecReader(CodecReader in, DocumentSelector selector) throws IOException {
            super(in);
            this.filteredLiveDocs = selector.getFilteredDocs(in);
            this.numDocs = this.filteredLiveDocs.cardinality();
        }

        public int numDocs() {
            return this.numDocs;
        }

        public Bits getLiveDocs() {
            return this.filteredLiveDocs;
        }

        public IndexReader.CacheHelper getCoreCacheHelper() {
            return this.in.getCoreCacheHelper();
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return null;
        }
    }
}

