/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault.metadata;

import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import com.datastax.oss.driver.api.querybuilder.schema.CreateTableWithOptions;
import org.apache.james.backends.cassandra.components.CassandraDataDefinition;

public interface DeletedMessageMetadataDataDefinition {
    public static final CassandraDataDefinition MODULE = CassandraDataDefinition.builder().table("storageInformation").comment("Holds storage information for deleted messages in the BlobStore based DeletedMessages vault").options(options -> (CreateTableWithOptions)options.withCaching(true, SchemaBuilder.RowsPerPartition.NONE)).statement(statement -> types -> statement.withPartitionKey("owner", DataTypes.TEXT).withPartitionKey("messageId", DataTypes.TEXT).withColumn("bucketName", DataTypes.TEXT).withColumn("blobId", DataTypes.TEXT)).table("userPerBucket").comment("Holds user list having deletedMessages stored in a given bucket in the BlobStore based DeletedMessages vault").options(options -> (CreateTableWithOptions)options.withCaching(true, SchemaBuilder.RowsPerPartition.NONE)).statement(statement -> types -> statement.withPartitionKey("bucketName", DataTypes.TEXT).withClusteringColumn("user", DataTypes.TEXT)).table("deletedMessageMetadata").comment("Holds storage information for deleted messages in the BlobStore based DeletedMessages vault").options(options -> (CreateTableWithOptions)options.withCaching(true, SchemaBuilder.RowsPerPartition.NONE)).statement(statement -> types -> statement.withPartitionKey("bucketName", DataTypes.TEXT).withPartitionKey("owner", DataTypes.TEXT).withClusteringColumn("messageId", DataTypes.TEXT).withColumn("payload", DataTypes.TEXT)).build();

    public static interface DeletedMessageMetadataTable {
        public static final String TABLE = "deletedMessageMetadata";
        public static final String BUCKET_NAME = "bucketName";
        public static final String OWNER = "owner";
        public static final String MESSAGE_ID = "messageId";
        public static final String PAYLOAD = "payload";
    }

    public static interface UserPerBucketTable {
        public static final String TABLE = "userPerBucket";
        public static final String BUCKET_NAME = "bucketName";
        public static final String USER = "user";
    }

    public static interface StorageInformationTable {
        public static final String TABLE = "storageInformation";
        public static final String OWNER = "owner";
        public static final String MESSAGE_ID = "messageId";
        public static final String BUCKET_NAME = "bucketName";
        public static final String BLOB_ID = "blobId";
    }
}

