/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.rrt.api.LoopDetectedException;
import org.apache.james.rrt.api.MappingAlreadyExistsException;
import org.apache.james.rrt.api.MappingConflictException;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.api.SourceDomainIsNotInDomainListException;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.rrt.lib.Mappings;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.routes.MailAddressParser;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import spark.HaltException;
import spark.Request;
import spark.Response;
import spark.ResponseTransformer;
import spark.Service;
import spark.Spark;

public class GroupsRoutes
implements Routes {
    public static final String ROOT_PATH = "address/groups";
    private static final String GROUP_ADDRESS = "groupAddress";
    private static final String GROUP_ADDRESS_PATH = "address/groups/:groupAddress";
    private static final String USER_ADDRESS = "userAddress";
    private static final String USER_IN_GROUP_ADDRESS_PATH = "address/groups/:groupAddress/:userAddress";
    private static final String GROUP_ADDRESS_TYPE = "group";
    private static final String USER_ADDRESS_TYPE = "group member";
    private final JsonTransformer jsonTransformer;
    private final RecipientRewriteTable recipientRewriteTable;

    @Inject
    @VisibleForTesting
    GroupsRoutes(RecipientRewriteTable recipientRewriteTable, JsonTransformer jsonTransformer) {
        this.jsonTransformer = jsonTransformer;
        this.recipientRewriteTable = recipientRewriteTable;
    }

    public String getBasePath() {
        return ROOT_PATH;
    }

    public void define(Service service) {
        service.get(ROOT_PATH, this::listGroups, (ResponseTransformer)this.jsonTransformer);
        service.delete(ROOT_PATH, this::deleteGroups, (ResponseTransformer)this.jsonTransformer);
        service.get(GROUP_ADDRESS_PATH, this::listGroupMembers, (ResponseTransformer)this.jsonTransformer);
        service.put(GROUP_ADDRESS_PATH, (request, response) -> Spark.halt((int)400));
        service.put(USER_IN_GROUP_ADDRESS_PATH, this::addToGroup);
        service.delete(GROUP_ADDRESS_PATH, (request, response) -> Spark.halt((int)400));
        service.delete(USER_IN_GROUP_ADDRESS_PATH, this::removeFromGroup);
    }

    public List<MappingSource> listGroups(Request request, Response response) throws RecipientRewriteTableException {
        return (List)this.recipientRewriteTable.getSourcesForType(Mapping.Type.Group).collect(ImmutableList.toImmutableList());
    }

    public HaltException deleteGroups(Request request, Response response) throws RecipientRewriteTableException {
        this.recipientRewriteTable.getSourcesForType(Mapping.Type.Group).flatMap(Throwing.function(source -> this.recipientRewriteTable.getStoredMappings(source).select(Mapping.Type.Group).asStream().map(mapping -> Pair.of((Object)source, (Object)mapping)))).forEach(Throwing.consumer(pair -> this.recipientRewriteTable.removeMapping((MappingSource)pair.getLeft(), (Mapping)pair.getRight())));
        return Spark.halt((int)204);
    }

    public HaltException addToGroup(Request request, Response response) {
        MailAddress groupAddress = MailAddressParser.parseMailAddress(request.params(GROUP_ADDRESS), GROUP_ADDRESS_TYPE);
        Domain domain = groupAddress.getDomain();
        MailAddress userAddress = MailAddressParser.parseMailAddress(request.params(USER_ADDRESS), USER_ADDRESS_TYPE);
        MappingSource source = MappingSource.fromUser((Username)Username.fromLocalPartWithDomain((String)groupAddress.getLocalPart(), (Domain)domain));
        this.addGroupMember(source, userAddress);
        return Spark.halt((int)204);
    }

    private void addGroupMember(MappingSource source, MailAddress userAddress) {
        try {
            this.recipientRewriteTable.addGroupMapping(source, userAddress.asString());
        }
        catch (MappingAlreadyExistsException mappingAlreadyExistsException) {
        }
        catch (LoopDetectedException | MappingConflictException e) {
            throw ErrorResponder.builder().statusCode(409).type(ErrorResponder.ErrorType.WRONG_STATE).message(e.getMessage()).haltError();
        }
        catch (SourceDomainIsNotInDomainListException e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message(e.getMessage()).haltError();
        }
        catch (RecipientRewriteTableException e) {
            throw ErrorResponder.builder().statusCode(500).type(ErrorResponder.ErrorType.SERVER_ERROR).message(e.getMessage()).haltError();
        }
    }

    public HaltException removeFromGroup(Request request, Response response) throws RecipientRewriteTableException {
        MailAddress groupAddress = MailAddressParser.parseMailAddress(request.params(GROUP_ADDRESS), GROUP_ADDRESS_TYPE);
        MailAddress userAddress = MailAddressParser.parseMailAddress(request.params(USER_ADDRESS), USER_ADDRESS_TYPE);
        MappingSource source = MappingSource.fromUser((Username)Username.fromLocalPartWithDomain((String)groupAddress.getLocalPart(), (Domain)groupAddress.getDomain()));
        this.recipientRewriteTable.removeGroupMapping(source, userAddress.asString());
        return Spark.halt((int)204);
    }

    public ImmutableSortedSet<String> listGroupMembers(Request request, Response response) throws RecipientRewriteTableException {
        MailAddress groupAddress = MailAddressParser.parseMailAddress(request.params(GROUP_ADDRESS), GROUP_ADDRESS_TYPE);
        Mappings mappings = this.recipientRewriteTable.getStoredMappings(MappingSource.fromMailAddress((MailAddress)groupAddress)).select(Mapping.Type.Group);
        this.ensureNonEmptyMappings(mappings);
        return (ImmutableSortedSet)mappings.asStream().map(Mapping::asMailAddress).flatMap(Optional::stream).map(MailAddress::asString).collect(ImmutableSortedSet.toImmutableSortedSet(String::compareTo));
    }

    private void ensureNonEmptyMappings(Mappings mappings) {
        if (mappings == null || mappings.isEmpty()) {
            throw ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("The group does not exist").haltError();
        }
    }
}

