/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PropertyManager {
    private PropertyManager() {
    }

    @Nullable
    public static String get(@NotNull String propertyName) {
        return PropertyManager.get(propertyName, null);
    }

    @Nullable
    public static String get(@NotNull String propertyName, @Nullable String defaultValue) {
        String alternativeEnvironmentVariableValue;
        String systemPropertyValue = StaticUtils.getSystemProperty(propertyName);
        if (systemPropertyValue != null) {
            return systemPropertyValue;
        }
        String environmentVariableValue = StaticUtils.getEnvironmentVariable(propertyName);
        if (environmentVariableValue != null) {
            return environmentVariableValue;
        }
        String alternativeEnvironmentVariableName = PropertyManager.generateEnvironmentVariableNameFromPropertyName(propertyName);
        if (!alternativeEnvironmentVariableName.equals(propertyName) && (alternativeEnvironmentVariableValue = StaticUtils.getEnvironmentVariable(alternativeEnvironmentVariableName)) != null) {
            return alternativeEnvironmentVariableValue;
        }
        return defaultValue;
    }

    @Nullable
    public static Boolean getBoolean(@NotNull String propertyName) {
        return PropertyManager.getBoolean(propertyName, null);
    }

    @Nullable
    public static Boolean getBoolean(@NotNull String propertyName, @Nullable Boolean defaultValue) {
        return PropertyManager.getBoolean(propertyName, defaultValue, false);
    }

    @Nullable
    public static Boolean getBoolean(@NotNull String propertyName, @Nullable Boolean defaultValue, boolean throwOnInvalidValue) throws IllegalArgumentException {
        String lowerValue;
        String stringValue = PropertyManager.get(propertyName);
        if (stringValue == null) {
            return defaultValue;
        }
        switch (lowerValue = StaticUtils.toLowerCase(stringValue.trim())) {
            case "true": 
            case "t": 
            case "yes": 
            case "y": 
            case "on": 
            case "1": {
                return Boolean.TRUE;
            }
            case "false": 
            case "f": 
            case "no": 
            case "n": 
            case "off": 
            case "0": {
                return Boolean.FALSE;
            }
        }
        if (throwOnInvalidValue) {
            throw new IllegalArgumentException(UtilityMessages.ERR_PROPERTY_MANAGER_NOT_BOOLEAN.get(PropertyManager.getIdentifierString(propertyName), stringValue));
        }
        return defaultValue;
    }

    @Nullable
    public static Integer getInt(@NotNull String propertyName) {
        return PropertyManager.getInt(propertyName, null);
    }

    @Nullable
    public static Integer getInt(@NotNull String propertyName, @Nullable Integer defaultValue) {
        return PropertyManager.getInt(propertyName, defaultValue, false);
    }

    @Nullable
    public static Integer getInt(@NotNull String propertyName, @Nullable Integer defaultValue, boolean throwOnInvalidValue) throws IllegalArgumentException {
        String stringValue = PropertyManager.get(propertyName);
        if (stringValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(stringValue.trim());
        }
        catch (Exception e) {
            Debug.debugException(e);
            if (throwOnInvalidValue) {
                throw new IllegalArgumentException(UtilityMessages.ERR_PROPERTY_MANAGER_NOT_INT.get(PropertyManager.getIdentifierString(propertyName), stringValue), e);
            }
            return defaultValue;
        }
    }

    @Nullable
    public static Long getLong(@NotNull String propertyName) {
        return PropertyManager.getLong(propertyName, null);
    }

    @Nullable
    public static Long getLong(@NotNull String propertyName, @Nullable Long defaultValue) {
        return PropertyManager.getLong(propertyName, defaultValue, false);
    }

    @Nullable
    public static Long getLong(@NotNull String propertyName, @Nullable Long defaultValue, boolean throwOnInvalidValue) throws IllegalArgumentException {
        String stringValue = PropertyManager.get(propertyName);
        if (stringValue == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(stringValue.trim());
        }
        catch (Exception e) {
            Debug.debugException(e);
            if (throwOnInvalidValue) {
                throw new IllegalArgumentException(UtilityMessages.ERR_PROPERTY_MANAGER_NOT_LONG.get(PropertyManager.getIdentifierString(propertyName), stringValue), e);
            }
            return defaultValue;
        }
    }

    @NotNull
    public static List<String> getCommaDelimitedList(@NotNull String propertyName) {
        return PropertyManager.getCommaDelimitedList(propertyName, true);
    }

    @NotNull
    public static List<String> getCommaDelimitedList(@NotNull String propertyName, boolean trimItems) {
        ArrayList<String> items = new ArrayList<String>();
        String stringValue = PropertyManager.get(propertyName);
        if (stringValue != null) {
            int startPos = 0;
            while (true) {
                String substring;
                int commaPos;
                if ((commaPos = stringValue.indexOf(44, startPos)) < 0) {
                    substring = stringValue.substring(startPos);
                    if (trimItems) {
                        substring = substring.trim();
                    }
                    items.add(substring);
                    break;
                }
                substring = stringValue.substring(startPos, commaPos);
                if (trimItems) {
                    substring = substring.trim();
                }
                items.add(substring);
                startPos = commaPos + 1;
            }
        }
        return Collections.unmodifiableList(items);
    }

    @NotNull
    public static Properties getProperties(String ... propertyNames) {
        Properties properties = new Properties();
        for (String propertyName : propertyNames) {
            String propertyValue = PropertyManager.get(propertyName);
            if (propertyValue == null) continue;
            properties.setProperty(propertyName, propertyValue);
        }
        return properties;
    }

    @NotNull
    public static String generateEnvironmentVariableNameFromPropertyName(@NotNull String propertyName) {
        String upperPropertyName = StaticUtils.toUpperCase(propertyName.trim());
        int length = upperPropertyName.length();
        StringBuilder buffer = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = upperPropertyName.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                buffer.append(c);
                continue;
            }
            buffer.append('_');
        }
        return buffer.toString();
    }

    @Nullable
    static String getIdentifierString(@NotNull String propertyName) {
        if (StaticUtils.getSystemProperty(propertyName) != null) {
            return UtilityMessages.INFO_PROPERTY_MANAGER_SYSTEM_PROPERY_IDENTIFIER.get(propertyName);
        }
        if (StaticUtils.getEnvironmentVariable(propertyName) != null) {
            return UtilityMessages.INFO_PROPERTY_MANAGER_ENVIRONMENT_VARIABLE_IDENTIFIER.get(propertyName);
        }
        String alternativeName = PropertyManager.generateEnvironmentVariableNameFromPropertyName(propertyName);
        if (StaticUtils.getEnvironmentVariable(alternativeName) != null) {
            return UtilityMessages.INFO_PROPERTY_MANAGER_ENVIRONMENT_VARIABLE_IDENTIFIER.get(alternativeName);
        }
        return null;
    }
}

