/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeMessage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.UUID;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.server.core.MailImpl;
import org.apache.james.webadmin.Routes;
import org.apache.mailet.Mail;
import spark.Service;

public class TransferEmailRoutes
implements Routes {
    public static final String BASE_URL = "/mail-transfer-service";
    private MailQueue queue;

    public String getBasePath() {
        return BASE_URL;
    }

    @Inject
    public TransferEmailRoutes(MailQueueFactory<?> queueFactory) {
        this.queue = queueFactory.createQueue(MailQueueFactory.SPOOL);
    }

    @PreDestroy
    void tearDown() {
        try {
            this.queue.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void define(Service service) {
        this.defineReceiveMailFromWebService(service);
    }

    public void defineReceiveMailFromWebService(Service service) {
        service.post(BASE_URL, (request, response) -> {
            MimeMessage mimeMessage = new MimeMessage(Session.getDefaultInstance((Properties)System.getProperties()), (InputStream)new ByteArrayInputStream(request.bodyAsBytes()));
            MailImpl mail = MailImpl.fromMimeMessage((String)UUID.randomUUID().toString(), (MimeMessage)mimeMessage);
            this.queue.enQueue((Mail)mail);
            response.body("");
            response.status(201);
            return response.body();
        });
    }
}

