/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.agent.task.subtask.sink;

import org.apache.iotdb.commons.pipe.agent.task.connection.UnboundedBlockingPendingQueue;
import org.apache.iotdb.commons.pipe.agent.task.subtask.PipeSubtask;
import org.apache.iotdb.db.pipe.agent.task.execution.PipeSinkSubtaskExecutor;
import org.apache.iotdb.db.pipe.agent.task.subtask.sink.PipeSinkSubtask;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.pipe.api.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeSinkSubtaskLifeCycle
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeSinkSubtaskLifeCycle.class);
    protected final PipeSinkSubtaskExecutor executor;
    protected final PipeSinkSubtask subtask;
    private final UnboundedBlockingPendingQueue<Event> pendingQueue;
    protected int runningTaskCount;
    protected int registeredTaskCount;

    public PipeSinkSubtaskLifeCycle(PipeSinkSubtaskExecutor executor, PipeSinkSubtask subtask, UnboundedBlockingPendingQueue<Event> pendingQueue) {
        this.executor = executor;
        this.subtask = subtask;
        this.pendingQueue = pendingQueue;
        this.runningTaskCount = 0;
        this.registeredTaskCount = 0;
    }

    public PipeSinkSubtask getSubtask() {
        return this.subtask;
    }

    public UnboundedBlockingPendingQueue<Event> getPendingQueue() {
        return this.pendingQueue;
    }

    public synchronized void register() {
        if (this.registeredTaskCount < 0) {
            throw new IllegalStateException("registeredTaskCount < 0");
        }
        if (this.registeredTaskCount == 0) {
            this.executor.register((PipeSubtask)this.subtask);
            this.runningTaskCount = 0;
            PipeDataNodeResourceManager.compaction().registerPipeConnectorSubtaskLifeCycle(this);
        }
        ++this.registeredTaskCount;
        LOGGER.info("Register subtask {}. runningTaskCount: {}, registeredTaskCount: {}", new Object[]{this.subtask, this.runningTaskCount, this.registeredTaskCount});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean deregister(String pipeNameToDeregister, int regionId) {
        block4: {
            boolean bl;
            if (this.registeredTaskCount <= 0) {
                throw new IllegalStateException("registeredTaskCount <= 0");
            }
            this.subtask.discardEventsOfPipe(pipeNameToDeregister, regionId);
            try {
                if (this.registeredTaskCount <= 1) break block4;
                bl = false;
                --this.registeredTaskCount;
            }
            catch (Throwable throwable) {
                --this.registeredTaskCount;
                LOGGER.info("Deregister subtask {}. runningTaskCount: {}, registeredTaskCount: {}", new Object[]{this.subtask, this.runningTaskCount, this.registeredTaskCount});
                throw throwable;
            }
            LOGGER.info("Deregister subtask {}. runningTaskCount: {}, registeredTaskCount: {}", new Object[]{this.subtask, this.runningTaskCount, this.registeredTaskCount});
            return bl;
        }
        this.close();
        boolean bl = true;
        --this.registeredTaskCount;
        LOGGER.info("Deregister subtask {}. runningTaskCount: {}, registeredTaskCount: {}", new Object[]{this.subtask, this.runningTaskCount, this.registeredTaskCount});
        return bl;
    }

    public synchronized void start() {
        if (this.runningTaskCount < 0) {
            throw new IllegalStateException("runningTaskCount < 0");
        }
        if (this.runningTaskCount == 0) {
            try {
                this.subtask.increaseHighPriorityTaskCount();
                this.executor.start(this.subtask.getTaskID());
            }
            finally {
                this.subtask.decreaseHighPriorityTaskCount();
            }
        }
        ++this.runningTaskCount;
        LOGGER.info("Start subtask {}. runningTaskCount: {}, registeredTaskCount: {}", new Object[]{this.subtask, this.runningTaskCount, this.registeredTaskCount});
    }

    public synchronized void stop() {
        if (this.runningTaskCount <= 0) {
            throw new IllegalStateException("runningTaskCount <= 0");
        }
        if (this.runningTaskCount == 1) {
            this.executor.stop(this.subtask.getTaskID());
        }
        --this.runningTaskCount;
        LOGGER.info("Stop subtask {}. runningTaskCount: {}, registeredTaskCount: {}", new Object[]{this.subtask, this.runningTaskCount, this.registeredTaskCount});
    }

    @Override
    public synchronized void close() {
        this.executor.deregister(this.subtask.getTaskID());
        PipeDataNodeResourceManager.compaction().deregisterPipeConnectorSubtaskLifeCycle(this);
    }
}

