/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DataType;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TableExpressionType;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public final class Cast
extends Expression {
    private final Expression expression;
    private final DataType type;
    private final boolean safe;
    private final boolean typeOnly;

    public Cast(Expression expression, DataType type) {
        this(expression, type, false, false);
    }

    public Cast(Expression expression, DataType type, boolean safe) {
        this(expression, type, safe, false);
    }

    public Cast(Expression expression, DataType type, boolean safe, boolean typeOnly) {
        super(null);
        Objects.requireNonNull(expression, "expression is null");
        this.expression = expression;
        this.type = type;
        this.safe = safe;
        this.typeOnly = typeOnly;
    }

    public Cast(@Nonnull NodeLocation location, Expression expression, DataType type) {
        this(Objects.requireNonNull(location, "location is null"), expression, type, false, false);
    }

    public Cast(@Nonnull NodeLocation location, Expression expression, DataType type, boolean safe) {
        this(Objects.requireNonNull(location, "location is null"), expression, type, safe, false);
    }

    private Cast(@Nonnull NodeLocation location, Expression expression, DataType type, boolean safe, boolean typeOnly) {
        super(location);
        Objects.requireNonNull(expression, "expression is null");
        this.expression = expression;
        this.type = type;
        this.safe = safe;
        this.typeOnly = typeOnly;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public DataType getType() {
        return this.type;
    }

    public boolean isSafe() {
        return this.safe;
    }

    public boolean isTypeOnly() {
        return this.typeOnly;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCast(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.expression, (Object)this.type);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cast cast = (Cast)o;
        return this.safe == cast.safe && this.typeOnly == cast.typeOnly && this.expression.equals(cast.expression) && this.type.equals(cast.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.expression, this.type, this.safe, this.typeOnly);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!Cast.sameClass(this, other)) {
            return false;
        }
        Cast otherCast = (Cast)other;
        return this.safe == otherCast.safe && this.typeOnly == otherCast.typeOnly;
    }

    @Override
    public TableExpressionType getExpressionType() {
        return TableExpressionType.CAST;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        Expression.serialize(this.expression, stream);
        Cast.serialize((Expression)this.type, stream);
        ReadWriteIOUtils.write((Boolean)this.safe, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.typeOnly, (OutputStream)stream);
    }

    public Cast(ByteBuffer byteBuffer) {
        super(null);
        this.expression = Expression.deserialize(byteBuffer);
        this.type = (DataType)Expression.deserialize(byteBuffer);
        this.safe = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        this.typeOnly = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
    }
}

