/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.node.common;

import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.node.IMNode;
import org.apache.iotdb.commons.schema.node.MNodeType;
import org.apache.iotdb.commons.schema.node.info.IDatabaseInfo;
import org.apache.iotdb.commons.schema.node.role.IDatabaseMNode;
import org.apache.iotdb.commons.schema.node.role.IMeasurementMNode;
import org.apache.iotdb.commons.schema.node.utils.IMNodeContainer;
import org.apache.iotdb.commons.schema.node.visitor.MNodeVisitor;

public abstract class AbstractDatabaseMNode<N extends IMNode<N>, BasicNode extends IMNode<N>>
implements IDatabaseMNode<N> {
    private static final long serialVersionUID = 7999036474525817732L;
    private final IDatabaseInfo<N> databaseInfo;
    protected final BasicNode basicMNode;

    public AbstractDatabaseMNode(BasicNode basicMNode, IDatabaseInfo<N> databaseInfo) {
        this.basicMNode = basicMNode;
        this.databaseInfo = databaseInfo;
    }

    public BasicNode getBasicMNode() {
        return this.basicMNode;
    }

    @Override
    public String getName() {
        return this.basicMNode.getName();
    }

    @Override
    public void setName(String name) {
        this.basicMNode.setName(name);
    }

    @Override
    public N getParent() {
        return this.basicMNode.getParent();
    }

    @Override
    public void setParent(N parent) {
        this.basicMNode.setParent(parent);
    }

    @Override
    public String getFullPath() {
        return this.basicMNode.getFullPath();
    }

    @Override
    public void setFullPath(String fullPath) {
        this.basicMNode.setFullPath(fullPath);
    }

    @Override
    public PartialPath getPartialPath() {
        return this.basicMNode.getPartialPath();
    }

    @Override
    public boolean hasChild(String name) {
        return this.basicMNode.hasChild(name);
    }

    @Override
    public N getChild(String name) {
        return this.basicMNode.getChild(name);
    }

    @Override
    public N addChild(String name, N child) {
        N res = this.basicMNode.addChild(name, child);
        if (res == child) {
            child.setParent(this.getAsMNode());
        }
        return res;
    }

    @Override
    public N addChild(N child) {
        N res = this.basicMNode.addChild(child);
        if (res == child) {
            child.setParent(this.getAsMNode());
        }
        return res;
    }

    @Override
    public N deleteChild(String name) {
        return this.basicMNode.deleteChild(name);
    }

    @Override
    public IMNodeContainer<N> getChildren() {
        return this.basicMNode.getChildren();
    }

    @Override
    public void setChildren(IMNodeContainer<N> children) {
        this.basicMNode.setChildren(children);
    }

    @Override
    public boolean isAboveDatabase() {
        return false;
    }

    @Override
    public boolean isDatabase() {
        return true;
    }

    @Override
    public boolean isMeasurement() {
        return false;
    }

    @Override
    public MNodeType getMNodeType() {
        return MNodeType.STORAGE_GROUP;
    }

    @Override
    public IDatabaseMNode<N> getAsDatabaseMNode() {
        return this;
    }

    @Override
    public IMeasurementMNode<N> getAsMeasurementMNode() {
        throw new UnsupportedOperationException("Wrong MNode Type");
    }

    @Override
    public <R, C> R accept(MNodeVisitor<R, C> visitor, C context) {
        return visitor.visitDatabaseMNode(this, context);
    }

    @Override
    public int estimateSize() {
        return 16 + this.databaseInfo.estimateSize() + this.basicMNode.estimateSize();
    }

    protected IDatabaseInfo<N> getDatabaseInfo() {
        return this.databaseInfo;
    }
}

