/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.tsfile.container;

import java.io.IOException;
import org.apache.iotdb.commons.path.PatternTreeMap;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.datastructure.pattern.PipePattern;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.metric.overview.PipeTsFileToTabletsMetrics;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryBlock;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryWeightUtil;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.utils.datastructure.PatternTreeMapFactory;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.read.expression.impl.GlobalTimeExpression;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.filter.factory.TimeFilterApi;
import org.apache.tsfile.write.record.Tablet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TsFileInsertionDataContainer
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TsFileInsertionDataContainer.class);
    protected final String pipeName;
    protected final long creationTime;
    protected final PipePattern pattern;
    protected final GlobalTimeExpression timeFilterExpression;
    protected final PipeTaskMeta pipeTaskMeta;
    protected final EnrichedEvent sourceEvent;
    protected PipeMemoryBlock allocatedMemoryBlockForModifications;
    protected PatternTreeMap<Modification, PatternTreeMapFactory.ModsSerializer> currentModifications;
    protected long parseStartTimeNano = -1L;
    protected boolean parseStartTimeRecorded = false;
    protected boolean parseEndTimeRecorded = false;
    protected final PipeMemoryBlock allocatedMemoryBlockForTablet;
    protected TsFileSequenceReader tsFileSequenceReader;
    protected Iterable<TabletInsertionEvent> tabletInsertionIterable;

    protected TsFileInsertionDataContainer(String pipeName, long creationTime, PipePattern pattern, long startTime, long endTime, PipeTaskMeta pipeTaskMeta, EnrichedEvent sourceEvent) {
        this.pipeName = pipeName;
        this.creationTime = creationTime;
        this.pattern = pattern;
        this.timeFilterExpression = startTime == Long.MIN_VALUE && endTime == Long.MAX_VALUE ? null : new GlobalTimeExpression((Filter)TimeFilterApi.between((long)startTime, (long)endTime));
        this.pipeTaskMeta = pipeTaskMeta;
        this.sourceEvent = sourceEvent;
        this.allocatedMemoryBlockForTablet = PipeDataNodeResourceManager.memory().forceAllocateForTabletWithRetry(PipeConfig.getInstance().getPipeDataStructureTabletSizeInBytes());
    }

    public abstract Iterable<TabletInsertionEvent> toTabletInsertionEvents();

    protected void recordParseStartTime() {
        if (this.pipeName == null || this.parseStartTimeRecorded) {
            return;
        }
        this.parseStartTimeNano = System.nanoTime();
        this.parseStartTimeRecorded = true;
    }

    protected void recordParseEndTime() {
        if (this.pipeName == null || !this.parseStartTimeRecorded || this.parseEndTimeRecorded) {
            return;
        }
        try {
            long parseEndTimeNano = System.nanoTime();
            long totalTimeNanos = parseEndTimeNano - this.parseStartTimeNano;
            String taskID = this.pipeName + "_" + this.creationTime;
            PipeTsFileToTabletsMetrics.getInstance().recordTsFileToTabletTime(taskID, totalTimeNanos);
            this.parseEndTimeRecorded = true;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to record parse end time for pipe {}", (Object)this.pipeName, (Object)e);
        }
    }

    protected void recordTabletMetrics(Tablet tablet) {
        if (this.pipeName == null || tablet == null) {
            return;
        }
        try {
            String taskID = this.pipeName + "_" + this.creationTime;
            long tabletMemorySize = PipeMemoryWeightUtil.calculateTabletSizeInBytes(tablet);
            PipeTsFileToTabletsMetrics.getInstance().recordTabletGenerated(taskID, tabletMemorySize);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to record tablet metrics for pipe {}", (Object)this.pipeName, (Object)e);
        }
    }

    @Override
    public void close() {
        this.tabletInsertionIterable = null;
        try {
            if (this.tsFileSequenceReader != null) {
                this.tsFileSequenceReader.close();
            }
        }
        catch (IOException e) {
            LOGGER.warn("Failed to close TsFileSequenceReader", (Throwable)e);
        }
        if (this.allocatedMemoryBlockForTablet != null) {
            this.allocatedMemoryBlockForTablet.close();
        }
        if (this.currentModifications != null) {
            this.currentModifications = null;
        }
        if (this.allocatedMemoryBlockForModifications != null) {
            this.allocatedMemoryBlockForModifications.close();
        }
    }
}

