/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.NodeAttributes;

public class ObjectTypeAttributes
extends NodeAttributes
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=361");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=363");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=362");
    private final Boolean isAbstract;

    public ObjectTypeAttributes(UInteger specifiedAttributes, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, Boolean isAbstract) {
        super(specifiedAttributes, displayName, description, writeMask, userWriteMask);
        this.isAbstract = isAbstract;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public Boolean getIsAbstract() {
        return this.isAbstract;
    }

    protected ObjectTypeAttributes(ObjectTypeAttributesBuilder<?, ?> b) {
        super((NodeAttributes.NodeAttributesBuilder<?, ?>)b);
        this.isAbstract = ((ObjectTypeAttributesBuilder)b).isAbstract;
    }

    public static ObjectTypeAttributesBuilder<?, ?> builder() {
        return new ObjectTypeAttributesBuilderImpl();
    }

    public ObjectTypeAttributesBuilder<?, ?> toBuilder() {
        return new ObjectTypeAttributesBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObjectTypeAttributes)) {
            return false;
        }
        ObjectTypeAttributes other = (ObjectTypeAttributes)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$isAbstract = this.getIsAbstract();
        Boolean other$isAbstract = other.getIsAbstract();
        return !(this$isAbstract == null ? other$isAbstract != null : !((Object)this$isAbstract).equals(other$isAbstract));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ObjectTypeAttributes;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $isAbstract = this.getIsAbstract();
        result = result * 59 + ($isAbstract == null ? 43 : ((Object)$isAbstract).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ObjectTypeAttributes(isAbstract=" + this.getIsAbstract() + ")";
    }

    private static final class ObjectTypeAttributesBuilderImpl
    extends ObjectTypeAttributesBuilder<ObjectTypeAttributes, ObjectTypeAttributesBuilderImpl> {
        private ObjectTypeAttributesBuilderImpl() {
        }

        @Override
        protected ObjectTypeAttributesBuilderImpl self() {
            return this;
        }

        @Override
        public ObjectTypeAttributes build() {
            return new ObjectTypeAttributes(this);
        }
    }

    public static abstract class ObjectTypeAttributesBuilder<C extends ObjectTypeAttributes, B extends ObjectTypeAttributesBuilder<C, B>>
    extends NodeAttributes.NodeAttributesBuilder<C, B> {
        private Boolean isAbstract;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ObjectTypeAttributesBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ObjectTypeAttributes instance, ObjectTypeAttributesBuilder<?, ?> b) {
            b.isAbstract(instance.isAbstract);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B isAbstract(Boolean isAbstract) {
            this.isAbstract = isAbstract;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ObjectTypeAttributes.ObjectTypeAttributesBuilder(super=" + super.toString() + ", isAbstract=" + this.isAbstract + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<ObjectTypeAttributes> {
        @Override
        public Class<ObjectTypeAttributes> getType() {
            return ObjectTypeAttributes.class;
        }

        @Override
        public ObjectTypeAttributes decode(SerializationContext context, UaDecoder decoder) {
            UInteger specifiedAttributes = decoder.readUInt32("SpecifiedAttributes");
            LocalizedText displayName = decoder.readLocalizedText("DisplayName");
            LocalizedText description = decoder.readLocalizedText("Description");
            UInteger writeMask = decoder.readUInt32("WriteMask");
            UInteger userWriteMask = decoder.readUInt32("UserWriteMask");
            Boolean isAbstract = decoder.readBoolean("IsAbstract");
            return new ObjectTypeAttributes(specifiedAttributes, displayName, description, writeMask, userWriteMask, isAbstract);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, ObjectTypeAttributes value) {
            encoder.writeUInt32("SpecifiedAttributes", value.getSpecifiedAttributes());
            encoder.writeLocalizedText("DisplayName", value.getDisplayName());
            encoder.writeLocalizedText("Description", value.getDescription());
            encoder.writeUInt32("WriteMask", value.getWriteMask());
            encoder.writeUInt32("UserWriteMask", value.getUserWriteMask());
            encoder.writeBoolean("IsAbstract", value.getIsAbstract());
        }
    }
}

