/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.load.splitter;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.utils.TimePartitionUtils;
import org.apache.iotdb.db.storageengine.load.LoadTsFileManager;
import org.apache.iotdb.db.storageengine.load.splitter.ChunkData;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.exception.write.PageException;
import org.apache.tsfile.file.header.ChunkHeader;
import org.apache.tsfile.file.header.PageHeader;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.common.Chunk;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteForEncodingUtils;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.write.UnSupportedDataTypeException;
import org.apache.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchema;
import org.apache.tsfile.write.writer.TsFileIOWriter;

public class NonAlignedChunkData
implements ChunkData {
    private final TTimePartitionSlot timePartitionSlot;
    private final String device;
    private final ChunkHeader chunkHeader;
    private final PublicBAOS byteStream;
    private final DataOutputStream stream;
    private long dataSize = 0L;
    private boolean needDecodeChunk;
    private int pageNumber;
    private ChunkWriterImpl chunkWriter;
    private Chunk chunk;

    public NonAlignedChunkData(String device, ChunkHeader chunkHeader, TTimePartitionSlot timePartitionSlot) {
        this.device = device;
        this.chunkHeader = chunkHeader;
        this.timePartitionSlot = timePartitionSlot;
        this.needDecodeChunk = true;
        this.pageNumber = 0;
        this.byteStream = new PublicBAOS();
        this.stream = new DataOutputStream((OutputStream)this.byteStream);
        this.addAttrDataSize();
    }

    private void addAttrDataSize() {
        this.dataSize += 2L;
        this.dataSize += 8L;
        int deviceLength = this.device.getBytes(TSFileConfig.STRING_CHARSET).length;
        this.dataSize += (long)ReadWriteForEncodingUtils.varIntSize((int)deviceLength);
        this.dataSize += (long)deviceLength;
        this.dataSize += (long)this.chunkHeader.getSerializedSize();
    }

    @Override
    public String getDevice() {
        return this.device;
    }

    @Override
    public TTimePartitionSlot getTimePartitionSlot() {
        return this.timePartitionSlot;
    }

    @Override
    public long getDataSize() {
        return this.dataSize;
    }

    @Override
    public void setNotDecode() {
        this.needDecodeChunk = false;
    }

    @Override
    public boolean isAligned() {
        return false;
    }

    @Override
    public void writeToFileWriter(TsFileIOWriter writer) throws IOException {
        if (this.chunk != null) {
            writer.writeChunk(this.chunk);
        } else {
            this.chunkWriter.writeToFileWriter(writer);
        }
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((Boolean)this.isModification(), (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.isAligned(), (OutputStream)stream);
        this.serializeAttr(stream);
        this.byteStream.writeTo((OutputStream)stream);
        this.close();
    }

    private void serializeAttr(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((long)this.timePartitionSlot.getStartTime(), (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.device, (OutputStream)stream);
        ReadWriteIOUtils.write((long)this.dataSize, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.needDecodeChunk, (OutputStream)stream);
        this.chunkHeader.serializeTo((OutputStream)stream);
        if (this.needDecodeChunk) {
            ReadWriteIOUtils.write((int)this.pageNumber, (OutputStream)stream);
        }
    }

    @Override
    public void writeEntireChunk(ByteBuffer chunkData, IChunkMetadata chunkMetadata) throws IOException {
        this.dataSize += (long)ReadWriteIOUtils.write((ByteBuffer)chunkData, (OutputStream)this.stream);
        this.dataSize += (long)chunkMetadata.getStatistics().serialize((OutputStream)this.stream);
    }

    @Override
    public void writeEntirePage(PageHeader pageHeader, ByteBuffer pageData) throws IOException {
        ++this.pageNumber;
        this.dataSize += (long)ReadWriteIOUtils.write((Boolean)false, (OutputStream)this.stream);
        this.dataSize += (long)pageHeader.serializeTo((OutputStream)this.stream);
        this.dataSize += (long)ReadWriteIOUtils.write((ByteBuffer)pageData, (OutputStream)this.stream);
    }

    @Override
    public void writeDecodePage(long[] times, Object[] values, int satisfiedLength) throws IOException {
        ++this.pageNumber;
        long startTime = this.timePartitionSlot.getStartTime();
        long endTime = startTime + TimePartitionUtils.getTimePartitionInterval() - 1L;
        if (endTime <= startTime) {
            endTime = Long.MAX_VALUE;
        }
        this.dataSize += (long)ReadWriteIOUtils.write((Boolean)true, (OutputStream)this.stream);
        this.dataSize += (long)ReadWriteIOUtils.write((int)satisfiedLength, (OutputStream)this.stream);
        block8: for (int i = 0; i < times.length && times[i] <= endTime; ++i) {
            if (times[i] < startTime) continue;
            this.dataSize += (long)ReadWriteIOUtils.write((long)times[i], (OutputStream)this.stream);
            switch (this.chunkHeader.getDataType()) {
                case INT32: 
                case DATE: {
                    this.dataSize += (long)ReadWriteIOUtils.write((int)((Integer)values[i]), (OutputStream)this.stream);
                    continue block8;
                }
                case INT64: 
                case TIMESTAMP: {
                    this.dataSize += (long)ReadWriteIOUtils.write((long)((Long)values[i]), (OutputStream)this.stream);
                    continue block8;
                }
                case FLOAT: {
                    this.dataSize += (long)ReadWriteIOUtils.write((float)((Float)values[i]).floatValue(), (OutputStream)this.stream);
                    continue block8;
                }
                case DOUBLE: {
                    this.dataSize += (long)ReadWriteIOUtils.write((double)((Double)values[i]), (OutputStream)this.stream);
                    continue block8;
                }
                case BOOLEAN: {
                    this.dataSize += (long)ReadWriteIOUtils.write((Boolean)((Boolean)values[i]), (OutputStream)this.stream);
                    continue block8;
                }
                case TEXT: 
                case BLOB: 
                case STRING: {
                    this.dataSize += (long)ReadWriteIOUtils.write((Binary)((Binary)values[i]), (OutputStream)this.stream);
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", this.chunkHeader.getDataType()));
                }
            }
        }
    }

    private void deserializeTsFileData(InputStream stream) throws IOException, PageException {
        if (this.needDecodeChunk) {
            this.buildChunkWriter(stream);
        } else {
            this.deserializeEntireChunk(stream);
        }
    }

    private void deserializeEntireChunk(InputStream stream) throws IOException {
        ByteBuffer chunkData = ByteBuffer.wrap(ReadWriteIOUtils.readBytesWithSelfDescriptionLength((InputStream)stream));
        Statistics statistics = Statistics.deserialize((InputStream)stream, (TSDataType)this.chunkHeader.getDataType());
        this.chunk = new Chunk(this.chunkHeader, chunkData, null, statistics);
    }

    private void buildChunkWriter(InputStream stream) throws IOException, PageException {
        this.chunkWriter = new ChunkWriterImpl((IMeasurementSchema)new MeasurementSchema(this.chunkHeader.getMeasurementID(), this.chunkHeader.getDataType(), this.chunkHeader.getEncodingType(), this.chunkHeader.getCompressionType()));
        for (int j = 0; j < this.pageNumber; ++j) {
            boolean needDecode = ReadWriteIOUtils.readBool((InputStream)stream);
            if (needDecode) {
                int length = ReadWriteIOUtils.readInt((InputStream)stream);
                block9: for (int i = 0; i < length; ++i) {
                    long time = ReadWriteIOUtils.readLong((InputStream)stream);
                    switch (this.chunkHeader.getDataType()) {
                        case INT32: 
                        case DATE: {
                            this.chunkWriter.write(time, ReadWriteIOUtils.readInt((InputStream)stream));
                            continue block9;
                        }
                        case INT64: 
                        case TIMESTAMP: {
                            this.chunkWriter.write(time, ReadWriteIOUtils.readLong((InputStream)stream));
                            continue block9;
                        }
                        case FLOAT: {
                            this.chunkWriter.write(time, ReadWriteIOUtils.readFloat((InputStream)stream));
                            continue block9;
                        }
                        case DOUBLE: {
                            this.chunkWriter.write(time, ReadWriteIOUtils.readDouble((InputStream)stream));
                            continue block9;
                        }
                        case BOOLEAN: {
                            this.chunkWriter.write(time, ReadWriteIOUtils.readBool((InputStream)stream));
                            continue block9;
                        }
                        case TEXT: 
                        case BLOB: 
                        case STRING: {
                            this.chunkWriter.write(time, ReadWriteIOUtils.readBinary((InputStream)stream));
                            continue block9;
                        }
                        default: {
                            throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", this.chunkHeader.getDataType()));
                        }
                    }
                }
                this.chunkWriter.sealCurrentPage();
                continue;
            }
            PageHeader pageHeader = PageHeader.deserializeFrom((InputStream)stream, (TSDataType)this.chunkHeader.getDataType(), (boolean)true);
            this.chunkWriter.writePageHeaderAndDataIntoBuff(ByteBuffer.wrap(ReadWriteIOUtils.readBytesWithSelfDescriptionLength((InputStream)stream)), pageHeader);
        }
    }

    public static NonAlignedChunkData deserialize(InputStream stream) throws IOException, PageException {
        TTimePartitionSlot timePartitionSlot = TimePartitionUtils.getTimePartitionSlot((long)ReadWriteIOUtils.readLong((InputStream)stream));
        String device = ReadWriteIOUtils.readString((InputStream)stream);
        long dataSize = ReadWriteIOUtils.readLong((InputStream)stream);
        boolean needDecodeChunk = ReadWriteIOUtils.readBool((InputStream)stream);
        byte chunkType = ReadWriteIOUtils.readByte((InputStream)stream);
        ChunkHeader chunkHeader = ChunkHeader.deserializeFrom((InputStream)stream, (byte)chunkType);
        String measurementID = chunkHeader.getMeasurementID();
        chunkHeader.setMeasurementID((String)LoadTsFileManager.MEASUREMENT_ID_CACHE.get((Object)measurementID, m -> m));
        int pageNumber = 0;
        if (needDecodeChunk) {
            pageNumber = ReadWriteIOUtils.readInt((InputStream)stream);
        }
        NonAlignedChunkData chunkData = new NonAlignedChunkData(device, chunkHeader, timePartitionSlot);
        chunkData.needDecodeChunk = needDecodeChunk;
        chunkData.pageNumber = pageNumber;
        chunkData.deserializeTsFileData(stream);
        chunkData.dataSize = dataSize;
        chunkData.close();
        return chunkData;
    }

    private void close() throws IOException {
        this.byteStream.close();
        this.stream.close();
    }

    public String toString() {
        return "NonAlignedChunkData{dataSize=" + this.dataSize + ", timePartitionSlot=" + this.timePartitionSlot + ", device='" + this.device + '\'' + ", chunkHeader=" + this.chunkHeader + ", needDecodeChunk=" + this.needDecodeChunk + '}';
    }
}

